/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.core.discord.events;

import com.hypherionmc.craterlib.core.event.CraterEvent;
import com.hypherionmc.craterlib.core.event.CraterEventBus;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.JDA;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.channel.ChannelCreateEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.channel.ChannelDeleteEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.guild.GuildBanEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.guild.GuildJoinEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.guild.member.GuildMemberJoinEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.guild.member.GuildMemberRemoveEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.message.MessageReceivedEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.role.RoleCreateEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.role.RoleDeleteEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.session.ReadyEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.hooks.ListenerAdapter;
import fabric.com.hypherionmc.sdlink.core.accounts.MinecraftAccount;
import fabric.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import fabric.com.hypherionmc.sdlink.core.database.SDLinkAccount;
import fabric.com.hypherionmc.sdlink.core.discord.BotController;
import fabric.com.hypherionmc.sdlink.core.discord.commands.slash.general.ServerStatusSlashCommand;
import fabric.com.hypherionmc.sdlink.core.discord.hooks.BotReadyHooks;
import fabric.com.hypherionmc.sdlink.core.discord.hooks.DiscordMessageHooks;
import fabric.com.hypherionmc.sdlink.core.discord.hooks.MinecraftCommandHook;
import fabric.com.hypherionmc.sdlink.core.events.SDLinkReadyEvent;
import fabric.com.hypherionmc.sdlink.core.managers.CacheManager;
import fabric.com.hypherionmc.sdlink.core.managers.ChannelManager;
import fabric.com.hypherionmc.sdlink.core.managers.DatabaseManager;
import fabric.com.hypherionmc.sdlink.core.managers.PermissionChecker;
import fabric.com.hypherionmc.sdlink.core.services.SDLinkPlatform;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class DiscordEventHandler
extends ListenerAdapter {
    @Override
    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        if (event.isWebhookMessage()) {
            return;
        }
        if (event.getAuthor() == event.getJDA().getSelfUser()) {
            return;
        }
        if (!event.isFromGuild()) {
            return;
        }
        MinecraftCommandHook.discordMessageEvent(event);
        DiscordMessageHooks.discordMessageEvent(event);
    }

    @Override
    public void onReady(@NotNull ReadyEvent event) {
        if (event.getJDA().getStatus() == JDA.Status.CONNECTED) {
            BotController.INSTANCE.getLogger().info("Successfully connected to discord");
            PermissionChecker.checkBotSetup();
            ChannelManager.loadChannels();
            BotReadyHooks.startActivityUpdates(event);
            BotReadyHooks.startTopicUpdates();
            CraterEventBus.INSTANCE.postEvent((CraterEvent)new SDLinkReadyEvent());
            CacheManager.loadCache();
        }
    }

    @Override
    public void onButtonInteraction(@NotNull ButtonInteractionEvent event) {
        if (event.getComponentId().equals("sdrefreshbtn")) {
            event.deferEdit().queue(s -> s.editOriginalEmbeds(ServerStatusSlashCommand.runStatusCommand()).queue());
        }
    }

    @Override
    public void onGuildJoin(@NotNull GuildJoinEvent event) {
        if (event.getJDA().getStatus() == JDA.Status.CONNECTED) {
            CacheManager.loadUserCache();
        }
    }

    @Override
    public void onGuildMemberJoin(@NotNull GuildMemberJoinEvent event) {
        if (event.getJDA().getStatus() == JDA.Status.CONNECTED) {
            CacheManager.loadUserCache();
        }
    }

    @Override
    public void onGuildMemberRemove(@NotNull GuildMemberRemoveEvent event) {
        if (event.getJDA().getStatus() == JDA.Status.CONNECTED) {
            CacheManager.loadUserCache();
        }
    }

    @Override
    public void onRoleCreate(@NotNull RoleCreateEvent event) {
        if (event.getJDA().getStatus() == JDA.Status.CONNECTED) {
            CacheManager.loadRoleCache();
        }
    }

    @Override
    public void onRoleDelete(@NotNull RoleDeleteEvent event) {
        if (event.getJDA().getStatus() == JDA.Status.CONNECTED) {
            CacheManager.loadRoleCache();
        }
    }

    @Override
    public void onChannelCreate(@NotNull ChannelCreateEvent event) {
        if (event.getJDA().getStatus() == JDA.Status.CONNECTED) {
            CacheManager.loadChannelCache();
        }
    }

    @Override
    public void onChannelDelete(@NotNull ChannelDeleteEvent event) {
        if (event.getJDA().getStatus() == JDA.Status.CONNECTED) {
            CacheManager.loadChannelCache();
        }
    }

    @Override
    public void onGuildBan(@NotNull GuildBanEvent event) {
        block4: {
            if (event.getUser().isBot()) {
                return;
            }
            CacheManager.loadUserCache();
            if (!SDLinkConfig.INSTANCE.accessControl.enabled) {
                return;
            }
            try {
                List<SDLinkAccount> accounts = DatabaseManager.sdlinkDatabase.getCollection(SDLinkAccount.class);
                Optional<SDLinkAccount> account = accounts.stream().filter(a -> a.getDiscordID().equalsIgnoreCase(event.getUser().getId())).findFirst();
                account.ifPresent(a -> {
                    MinecraftAccount acc = MinecraftAccount.of(a.getUsername());
                    if (acc != null) {
                        DatabaseManager.sdlinkDatabase.remove(a, SDLinkAccount.class);
                        if (SDLinkConfig.INSTANCE.accessControl.banPlayerOnDiscordBan) {
                            SDLinkPlatform.minecraftHelper.banPlayer(acc);
                        }
                        DatabaseManager.sdlinkDatabase.reloadCollection("verifiedaccounts");
                    }
                });
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block4;
                e.printStackTrace();
            }
        }
    }
}

