/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.core.discord.commands.slash.verification;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.EmbedBuilder;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Message;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.MessageEmbed;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.SlashCommandEvent;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.menu.ButtonEmbedPaginator;
import fabric.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import fabric.com.hypherionmc.sdlink.core.database.SDLinkAccount;
import fabric.com.hypherionmc.sdlink.core.discord.commands.slash.SDLinkSlashCommand;
import fabric.com.hypherionmc.sdlink.core.managers.DatabaseManager;
import fabric.com.hypherionmc.sdlink.core.util.MessageUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ViewVerifiedAccounts
extends SDLinkSlashCommand {
    public ViewVerifiedAccounts() {
        super(true);
        this.name = "verifiedaccounts";
        this.help = "View a list of verified Minecraft Accounts";
    }

    @Override
    protected void execute(SlashCommandEvent event) {
        block3: {
            event.deferReply(true).queue();
            try {
                ButtonEmbedPaginator.Builder paginator = MessageUtil.defaultPaginator();
                DatabaseManager.sdlinkDatabase.reloadCollection("verifiedaccounts");
                List<SDLinkAccount> accounts = DatabaseManager.sdlinkDatabase.findAll(SDLinkAccount.class);
                EmbedBuilder builder = new EmbedBuilder();
                ArrayList<MessageEmbed> pages = new ArrayList<MessageEmbed>();
                AtomicInteger count = new AtomicInteger();
                if (accounts.isEmpty()) {
                    event.getHook().sendMessage("There are no verified accounts for this discord").setEphemeral(true).queue();
                    return;
                }
                MessageUtil.listBatches(accounts, 10).forEach(itm -> {
                    count.getAndIncrement();
                    builder.clear();
                    builder.setTitle("Verified Accounts - Page " + count + "/" + (int)Math.ceil((float)accounts.size() / 10.0f));
                    builder.setColor(Color.GREEN);
                    StringBuilder sBuilder = new StringBuilder();
                    itm.forEach(v -> {
                        Member member = null;
                        if (v.getDiscordID() != null && !v.getDiscordID().isEmpty()) {
                            member = event.getGuild().getMemberById(v.getDiscordID());
                        }
                        sBuilder.append(v.getUsername()).append(" -> ").append(member == null ? "Unlinked" : member.getAsMention()).append("\r\n");
                    });
                    builder.setDescription(sBuilder);
                    pages.add(builder.build());
                });
                paginator.setItems(pages);
                ButtonEmbedPaginator embedPaginator = paginator.build();
                event.getHook().sendMessageEmbeds(pages.get(0), new MessageEmbed[0]).setEphemeral(false).queue(success -> embedPaginator.paginate((Message)success, 1));
            }
            catch (Exception e) {
                event.getHook().sendMessage("Failed to execute command. Please see your server log").setEphemeral(true).queue();
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block3;
                e.printStackTrace();
            }
        }
    }
}

