/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.core.discord.commands.slash.verification;

import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.SlashCommandEvent;
import fabric.com.hypherionmc.sdlink.core.accounts.MinecraftAccount;
import fabric.com.hypherionmc.sdlink.core.database.SDLinkAccount;
import fabric.com.hypherionmc.sdlink.core.discord.commands.slash.SDLinkSlashCommand;
import fabric.com.hypherionmc.sdlink.core.managers.DatabaseManager;
import fabric.com.hypherionmc.sdlink.core.messaging.Result;
import java.util.List;

public class UnverifyAccountSlashCommand
extends SDLinkSlashCommand {
    public UnverifyAccountSlashCommand() {
        super(false);
        this.name = "unverify";
        this.help = "Unverify your previously verified Minecraft account";
    }

    @Override
    protected void execute(SlashCommandEvent event) {
        event.deferReply(true).queue();
        DatabaseManager.sdlinkDatabase.reloadCollection("verifiedaccounts");
        List<SDLinkAccount> accounts = DatabaseManager.sdlinkDatabase.findAll(SDLinkAccount.class);
        if (accounts.isEmpty()) {
            event.getHook().sendMessage("Sorry, but this server does not contain any stored players in its database").setEphemeral(true).queue();
            return;
        }
        boolean didUnverify = false;
        for (SDLinkAccount account : accounts) {
            if (account.getDiscordID() == null || !account.getDiscordID().equalsIgnoreCase(event.getMember().getId())) continue;
            MinecraftAccount minecraftAccount = MinecraftAccount.of(account.getUsername());
            Result result = minecraftAccount.unverifyAccount(event.getMember(), event.getGuild());
            event.getHook().sendMessage(result.getMessage()).setEphemeral(true).queue();
            didUnverify = true;
            break;
        }
        if (!didUnverify) {
            event.getHook().sendMessage("Sorry, we could not un-verify your Minecraft account. Please try again").setEphemeral(true).queue();
        }
    }
}

