/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.core.discord.commands.slash.verification;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.User;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.interactions.commands.OptionType;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.interactions.commands.build.OptionData;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.SlashCommandEvent;
import fabric.com.hypherionmc.sdlink.core.accounts.MinecraftAccount;
import fabric.com.hypherionmc.sdlink.core.discord.commands.slash.SDLinkSlashCommand;
import fabric.com.hypherionmc.sdlink.core.messaging.Result;
import java.util.ArrayList;

public class StaffVerifyAccountCommand
extends SDLinkSlashCommand {
    public StaffVerifyAccountCommand() {
        super(true);
        this.name = "staffverify";
        this.help = "Allow staff members verify minecraft players, without verification";
        this.options = new ArrayList<OptionData>(){
            {
                this.add(new OptionData(OptionType.USER, "discorduser", "The discord user the minecraft account belongs to").setRequired(true));
                this.add(new OptionData(OptionType.STRING, "mcname", "The minecraft account to link to the user").setRequired(true));
            }
        };
    }

    @Override
    protected void execute(SlashCommandEvent event) {
        event.deferReply(true).queue();
        String mcname = event.getOption("mcname").getAsString();
        User user = event.getOption("discorduser").getAsUser();
        Member member = event.getGuild().getMemberById(user.getId());
        if (member == null) {
            event.getHook().sendMessage(user.getEffectiveName() + " is not a member of this discord server").setEphemeral(true).queue();
            return;
        }
        MinecraftAccount minecraftAccount = MinecraftAccount.of(mcname);
        Result result = minecraftAccount.verifyAccount(member, event.getGuild());
        event.getHook().sendMessage(result.getMessage()).setEphemeral(true).queue();
    }
}

