/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.core.accounts;

import com.mojang.authlib.GameProfile;
import fabric.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import fabric.com.hypherionmc.sdlink.core.services.SDLinkPlatform;

public class DiscordAuthor {
    public static final DiscordAuthor SERVER = new DiscordAuthor(SDLinkConfig.INSTANCE.channelsAndWebhooks.serverName, SDLinkConfig.INSTANCE.channelsAndWebhooks.serverAvatar, "server", true, "");
    private final String displayName;
    private final String avatar;
    private final boolean isServer;
    private String username;
    private String uuid;
    private GameProfile profile = null;
    String realPlayerAvatar = "";
    String realPlayerName = "";

    private DiscordAuthor(String displayName, String avatar, String username, boolean isServer, String uuid) {
        this.displayName = displayName;
        this.avatar = avatar;
        this.username = username;
        this.isServer = isServer;
        this.uuid = uuid;
    }

    public static DiscordAuthor of(String displayName, String uuid, String username) {
        return new DiscordAuthor(displayName, SDLinkConfig.INSTANCE.chatConfig.playerAvatarType.resolve(SDLinkPlatform.minecraftHelper.isOnlineMode() ? uuid : username), username, false, SDLinkPlatform.minecraftHelper.isOnlineMode() ? uuid : username);
    }

    public static DiscordAuthor of(String displayName, String avatar, String username, boolean server) {
        return new DiscordAuthor(displayName, avatar, username, server, username);
    }

    public DiscordAuthor setPlayerAvatar(String usr, String userid) {
        this.realPlayerAvatar = SDLinkConfig.INSTANCE.chatConfig.playerAvatarType.resolve(SDLinkPlatform.minecraftHelper.isOnlineMode() ? userid : usr);
        return this;
    }

    public DiscordAuthor setPlayerName(String name) {
        this.realPlayerName = name;
        return this;
    }

    public DiscordAuthor setGameProfile(GameProfile profile) {
        this.profile = profile;
        this.username = profile.getName();
        this.uuid = profile.getId().toString();
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public String getUsername() {
        return this.username;
    }

    public String getUuid() {
        return this.uuid;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public String getRealPlayerAvatar() {
        return this.realPlayerAvatar;
    }

    public String getRealPlayerName() {
        return this.realPlayerName;
    }
}

