/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.util;

import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.Container;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.DynamicPropertyHandler;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.JXPathException;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.util.TypeUtils;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ValueUtils {
    private static Map dynamicPropertyHandlerMap = new HashMap();
    private static final int UNKNOWN_LENGTH_MAX_COUNT = 16000;
    static /* synthetic */ Class class$java$util$Collection;

    public static boolean isCollection(Object value) {
        if ((value = ValueUtils.getValue(value)) == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            return true;
        }
        return value instanceof Collection;
    }

    public static int getCollectionHint(Class clazz) {
        if (clazz.isArray()) {
            return 1;
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = ValueUtils.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            return 1;
        }
        if (clazz.isPrimitive()) {
            return -1;
        }
        if (clazz.isInterface()) {
            return 0;
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            return -1;
        }
        return 0;
    }

    public static int getIndexedPropertyLength(Object object, IndexedPropertyDescriptor pd) {
        if (pd.getReadMethod() != null) {
            return ValueUtils.getLength(ValueUtils.getValue(object, pd));
        }
        Method readMethod = pd.getIndexedReadMethod();
        if (readMethod == null) {
            throw new JXPathException("No indexed read method for property " + pd.getName());
        }
        for (int i = 0; i < 16000; ++i) {
            try {
                readMethod.invoke(object, new Integer(i));
                continue;
            }
            catch (Throwable t) {
                return i;
            }
        }
        throw new JXPathException("Cannot determine the length of the indexed property " + pd.getName());
    }

    public static int getLength(Object collection) {
        if (collection == null) {
            return 0;
        }
        if ((collection = ValueUtils.getValue(collection)).getClass().isArray()) {
            return Array.getLength(collection);
        }
        if (collection instanceof Collection) {
            return ((Collection)collection).size();
        }
        return 1;
    }

    public static Iterator iterate(Object collection) {
        if (collection == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (collection.getClass().isArray()) {
            int length = Array.getLength(collection);
            if (length == 0) {
                return Collections.EMPTY_LIST.iterator();
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(collection, i));
            }
            return list.iterator();
        }
        if (collection instanceof Collection) {
            return ((Collection)collection).iterator();
        }
        return Collections.singletonList(collection).iterator();
    }

    public static Object expandCollection(Object collection, int size) {
        if (collection == null) {
            return null;
        }
        if (size < ValueUtils.getLength(collection)) {
            throw new JXPathException("adjustment of " + collection + " to size " + size + " is not an expansion");
        }
        if (collection.getClass().isArray()) {
            Object bigger = Array.newInstance(collection.getClass().getComponentType(), size);
            System.arraycopy(collection, 0, bigger, 0, Array.getLength(collection));
            return bigger;
        }
        if (collection instanceof Collection) {
            while (((Collection)collection).size() < size) {
                ((Collection)collection).add(null);
            }
            return collection;
        }
        throw new JXPathException("Cannot turn " + collection.getClass().getName() + " into a collection of size " + size);
    }

    public static Object remove(Object collection, int index) {
        if ((collection = ValueUtils.getValue(collection)) == null) {
            return null;
        }
        if (index >= ValueUtils.getLength(collection)) {
            throw new JXPathException("No such element at index " + index);
        }
        if (collection.getClass().isArray()) {
            int length = Array.getLength(collection);
            Object smaller = Array.newInstance(collection.getClass().getComponentType(), length - 1);
            if (index > 0) {
                System.arraycopy(collection, 0, smaller, 0, index);
            }
            if (index < length - 1) {
                System.arraycopy(collection, index + 1, smaller, index, length - index - 1);
            }
            return smaller;
        }
        if (collection instanceof List) {
            int size = ((List)collection).size();
            if (index < size) {
                ((List)collection).remove(index);
            }
            return collection;
        }
        if (collection instanceof Collection) {
            Iterator it = ((Collection)collection).iterator();
            for (int i = 0; i < index && it.hasNext(); ++i) {
                it.next();
            }
            if (it.hasNext()) {
                it.next();
                it.remove();
            }
            return collection;
        }
        throw new JXPathException("Cannot remove " + collection.getClass().getName() + "[" + index + "]");
    }

    public static Object getValue(Object collection, int index) {
        Object value = collection = ValueUtils.getValue(collection);
        if (collection != null) {
            if (collection.getClass().isArray()) {
                if (index < 0 || index >= Array.getLength(collection)) {
                    return null;
                }
                value = Array.get(collection, index);
            } else if (collection instanceof List) {
                if (index < 0 || index >= ((List)collection).size()) {
                    return null;
                }
                value = ((List)collection).get(index);
            } else if (collection instanceof Collection) {
                Iterator it = ((Collection)collection).iterator();
                for (int i = 0; i < index; ++i) {
                    it.next();
                }
                value = it.hasNext() ? it.next() : null;
            }
        }
        return value;
    }

    public static void setValue(Object collection, int index, Object value) {
        if ((collection = ValueUtils.getValue(collection)) != null) {
            if (collection.getClass().isArray()) {
                Array.set(collection, index, ValueUtils.convert(value, collection.getClass().getComponentType()));
            } else if (collection instanceof List) {
                ((List)collection).set(index, value);
            } else if (collection instanceof Collection) {
                throw new UnsupportedOperationException("Cannot set value of an element of a " + collection.getClass().getName());
            }
        }
    }

    public static Object getValue(Object bean, PropertyDescriptor propertyDescriptor) {
        Object value;
        try {
            Method method = ValueUtils.getAccessibleMethod(propertyDescriptor.getReadMethod());
            if (method == null) {
                throw new JXPathException("No read method");
            }
            value = method.invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            throw new JXPathException("Cannot access property: " + (bean == null ? "null" : bean.getClass().getName()) + "." + propertyDescriptor.getName(), ex);
        }
        return value;
    }

    public static void setValue(Object bean, PropertyDescriptor propertyDescriptor, Object value) {
        try {
            Method method = ValueUtils.getAccessibleMethod(propertyDescriptor.getWriteMethod());
            if (method == null) {
                throw new JXPathException("No write method");
            }
            value = ValueUtils.convert(value, propertyDescriptor.getPropertyType());
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            throw new JXPathException("Cannot modify property: " + (bean == null ? "null" : bean.getClass().getName()) + "." + propertyDescriptor.getName(), ex);
        }
    }

    private static Object convert(Object value, Class type) {
        try {
            return TypeUtils.convert(value, type);
        }
        catch (Exception ex) {
            throw new JXPathException("Cannot convert value of class " + (value == null ? "null" : value.getClass().getName()) + " to type " + type, ex);
        }
    }

    public static Object getValue(Object bean, PropertyDescriptor propertyDescriptor, int index) {
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            try {
                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)propertyDescriptor;
                Method method = ipd.getIndexedReadMethod();
                if (method != null) {
                    return method.invoke(bean, new Integer(index));
                }
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getTargetException();
                if (t instanceof IndexOutOfBoundsException) {
                    return null;
                }
                throw new JXPathException("Cannot access property: " + propertyDescriptor.getName(), t);
            }
            catch (Throwable ex) {
                throw new JXPathException("Cannot access property: " + propertyDescriptor.getName(), ex);
            }
        }
        return ValueUtils.getValue(ValueUtils.getValue(bean, propertyDescriptor), index);
    }

    public static void setValue(Object bean, PropertyDescriptor propertyDescriptor, int index, Object value) {
        Object collection;
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            try {
                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)propertyDescriptor;
                Method method = ipd.getIndexedWriteMethod();
                if (method != null) {
                    method.invoke(bean, new Integer(index), ValueUtils.convert(value, ipd.getIndexedPropertyType()));
                    return;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot access property: " + propertyDescriptor.getName() + ", " + ex.getMessage());
            }
        }
        if (ValueUtils.isCollection(collection = ValueUtils.getValue(bean, propertyDescriptor))) {
            ValueUtils.setValue(collection, index, value);
        } else if (index == 0) {
            ValueUtils.setValue(bean, propertyDescriptor, value);
        } else {
            throw new RuntimeException("Not a collection: " + propertyDescriptor.getName());
        }
    }

    public static Object getValue(Object object) {
        while (object instanceof Container) {
            object = ((Container)object).getValue();
        }
        return object;
    }

    public static DynamicPropertyHandler getDynamicPropertyHandler(Class clazz) {
        DynamicPropertyHandler handler = (DynamicPropertyHandler)dynamicPropertyHandlerMap.get(clazz);
        if (handler == null) {
            try {
                handler = (DynamicPropertyHandler)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new JXPathException("Cannot allocate dynamic property handler of class " + clazz.getName(), ex);
            }
            dynamicPropertyHandlerMap.put(clazz, handler);
        }
        return handler;
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String name = method.getName();
        Class[] parameterTypes = method.getParameterTypes();
        while (clazz != null) {
            Method aMethod = ValueUtils.getAccessibleMethodFromInterfaceNest(clazz, name, parameterTypes);
            if (aMethod != null) {
                return aMethod;
            }
            if ((clazz = clazz.getSuperclass()) == null || !Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                return clazz.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
            try {
                method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (method != null || (method = ValueUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
        }
        return method;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

