/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.model.dynamic;

import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.AbstractFactory;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.DynamicPropertyHandler;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.JXPathAbstractFactoryException;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.JXPathContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.JXPathInvalidAccessException;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.model.NodePointer;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.util.ValueUtils;
import java.util.Arrays;
import java.util.Map;

public class DynamicPropertyPointer
extends PropertyPointer {
    private static final long serialVersionUID = -5720585681149150822L;
    private DynamicPropertyHandler handler;
    private String name;
    private String[] names;
    private String requiredPropertyName;

    public DynamicPropertyPointer(NodePointer parent, DynamicPropertyHandler handler) {
        super(parent);
        this.handler = handler;
    }

    public boolean isContainer() {
        return true;
    }

    public int getPropertyCount() {
        return this.getPropertyNames().length;
    }

    public String[] getPropertyNames() {
        if (this.names == null) {
            int inx;
            String[] allNames = this.handler.getPropertyNames(this.getBean());
            this.names = new String[allNames.length];
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = allNames[i];
            }
            Arrays.sort(this.names);
            if (this.requiredPropertyName != null && (inx = Arrays.binarySearch(this.names, this.requiredPropertyName)) < 0) {
                allNames = this.names;
                this.names = new String[allNames.length + 1];
                this.names[0] = this.requiredPropertyName;
                System.arraycopy(allNames, 0, this.names, 1, allNames.length);
                Arrays.sort(this.names);
            }
        }
        return this.names;
    }

    public String getPropertyName() {
        if (this.name == null) {
            String[] names = this.getPropertyNames();
            this.name = this.propertyIndex >= 0 && this.propertyIndex < names.length ? names[this.propertyIndex] : "*";
        }
        return this.name;
    }

    public void setPropertyName(String propertyName) {
        this.setPropertyIndex(Integer.MIN_VALUE);
        this.name = propertyName;
        this.requiredPropertyName = propertyName;
        if (this.names != null && Arrays.binarySearch(this.names, propertyName) < 0) {
            this.names = null;
        }
    }

    public int getPropertyIndex() {
        if (this.propertyIndex == Integer.MIN_VALUE) {
            String[] names = this.getPropertyNames();
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(this.name)) continue;
                this.setPropertyIndex(i);
                break;
            }
        }
        return super.getPropertyIndex();
    }

    public void setPropertyIndex(int index) {
        if (this.propertyIndex != index) {
            super.setPropertyIndex(index);
            this.name = null;
        }
    }

    public Object getBaseValue() {
        return this.handler.getProperty(this.getBean(), this.getPropertyName());
    }

    public Object getImmediateNode() {
        Object value = this.index == Integer.MIN_VALUE ? ValueUtils.getValue(this.handler.getProperty(this.getBean(), this.getPropertyName())) : ValueUtils.getValue(this.handler.getProperty(this.getBean(), this.getPropertyName()), this.index);
        return value;
    }

    protected boolean isActualProperty() {
        return true;
    }

    public void setValue(Object value) {
        if (this.index == Integer.MIN_VALUE) {
            this.handler.setProperty(this.getBean(), this.getPropertyName(), value);
        } else {
            ValueUtils.setValue(this.handler.getProperty(this.getBean(), this.getPropertyName()), this.index, value);
        }
    }

    public NodePointer createPath(JXPathContext context) {
        Object collection = this.getBaseValue();
        if (collection == null) {
            AbstractFactory factory2 = this.getAbstractFactory(context);
            boolean success = factory2.createObject(context, this, this.getBean(), this.getPropertyName(), 0);
            if (!success) {
                throw new JXPathAbstractFactoryException("Factory could not create an object for path: " + this.asPath());
            }
            collection = this.getBaseValue();
        }
        if (this.index != Integer.MIN_VALUE) {
            if (this.index < 0) {
                throw new JXPathInvalidAccessException("Index is less than 1: " + this.asPath());
            }
            if (this.index >= this.getLength()) {
                collection = ValueUtils.expandCollection(collection, this.index + 1);
                this.handler.setProperty(this.getBean(), this.getPropertyName(), collection);
            }
        }
        return this;
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        if (this.index == Integer.MIN_VALUE) {
            this.handler.setProperty(this.getBean(), this.getPropertyName(), value);
        } else {
            this.createPath(context);
            ValueUtils.setValue(this.getBaseValue(), this.index, value);
        }
        return this;
    }

    public void remove() {
        if (this.index == Integer.MIN_VALUE) {
            this.removeKey();
        } else if (this.isCollection()) {
            Object collection = ValueUtils.remove(this.getBaseValue(), this.index);
            this.handler.setProperty(this.getBean(), this.getPropertyName(), collection);
        } else if (this.index == 0) {
            this.removeKey();
        }
    }

    private void removeKey() {
        Object bean = this.getBean();
        if (bean instanceof Map) {
            ((Map)bean).remove(this.getPropertyName());
        } else {
            this.handler.setProperty(bean, this.getPropertyName(), null);
        }
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getImmediateParentPointer().asPath());
        if (buffer.length() == 0) {
            buffer.append("/.");
        } else if (buffer.charAt(buffer.length() - 1) == '/') {
            buffer.append('.');
        }
        buffer.append("[@name='");
        buffer.append(this.escape(this.getPropertyName()));
        buffer.append("']");
        if (this.index != Integer.MIN_VALUE && this.isCollection()) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }
}

