/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.model.beans;

import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.JXPathException;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.model.NodeIterator;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.model.NodePointer;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.model.beans.CollectionPointer;
import java.util.ArrayList;
import java.util.List;

public abstract class CollectionNodeIterator
implements NodeIterator {
    private CollectionPointer pointer;
    private boolean reverse;
    private NodePointer startWith;
    private int position;
    private List collection;

    protected CollectionNodeIterator(CollectionPointer pointer, boolean reverse, NodePointer startWith) {
        this.pointer = pointer;
        this.reverse = reverse;
        this.startWith = startWith;
    }

    protected abstract NodeIterator getElementNodeIterator(NodePointer var1);

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        if (this.collection == null) {
            this.prepare();
        }
        if (position < 1 || position > this.collection.size()) {
            return false;
        }
        this.position = position;
        return true;
    }

    public NodePointer getNodePointer() {
        if (this.position == 0) {
            return null;
        }
        return (NodePointer)this.collection.get(this.position - 1);
    }

    private void prepare() {
        this.collection = new ArrayList();
        NodePointer ptr = (NodePointer)this.pointer.clone();
        int length = ptr.getLength();
        for (int i = 0; i < length; ++i) {
            ptr.setIndex(i);
            NodePointer elementPointer = ptr.getValuePointer();
            NodeIterator iter = this.getElementNodeIterator(elementPointer);
            int j = 1;
            while (iter.setPosition(j)) {
                NodePointer childPointer = iter.getNodePointer();
                if (this.reverse) {
                    this.collection.add(0, childPointer);
                } else {
                    this.collection.add(childPointer);
                }
                ++j;
            }
        }
        if (this.startWith != null) {
            int index = this.collection.indexOf(this.startWith);
            if (index == -1) {
                throw new JXPathException("Invalid starting pointer for iterator: " + this.startWith);
            }
            while (this.collection.size() > index) {
                if (!this.reverse) {
                    this.collection.remove(this.collection.size() - 1);
                    continue;
                }
                this.collection.remove(0);
            }
        }
    }
}

