/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.compiler;

import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.Pointer;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.EvalContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.QName;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.AncestorContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.AttributeContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.ChildContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.DescendantContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.InitialContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.NamespaceContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.ParentContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.PrecedingOrFollowingContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.PredicateContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.SelfContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.SimplePathInterpreter;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.axes.UnionContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.compiler.Expression;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.compiler.NameAttributeTest;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.compiler.NodeTest;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.compiler.Step;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.model.NodePointer;

public abstract class Path
extends Expression {
    private Step[] steps;
    private boolean basicKnown = false;
    private boolean basic;

    public Path(Step[] steps) {
        this.steps = steps;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public boolean computeContextDependent() {
        if (this.steps != null) {
            for (int i = 0; i < this.steps.length; ++i) {
                if (!this.steps[i].isContextDependent()) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean isSimplePath() {
        if (!this.basicKnown) {
            this.basicKnown = true;
            this.basic = true;
            Step[] steps = this.getSteps();
            for (int i = 0; i < steps.length; ++i) {
                if (this.isSimpleStep(steps[i])) continue;
                this.basic = false;
                break;
            }
        }
        return this.basic;
    }

    protected boolean isSimpleStep(Step step) {
        if (step.getAxis() == 1) {
            NodeTest nodeTest = step.getNodeTest();
            if (!(nodeTest instanceof NodeTypeTest)) {
                return false;
            }
            int nodeType = ((NodeTypeTest)nodeTest).getNodeType();
            if (nodeType != 1) {
                return false;
            }
            return this.areBasicPredicates(step.getPredicates());
        }
        if (step.getAxis() == 2 || step.getAxis() == 5) {
            NodeTest nodeTest = step.getNodeTest();
            if (!(nodeTest instanceof NodeNameTest)) {
                return false;
            }
            if (((NodeNameTest)nodeTest).isWildcard()) {
                return false;
            }
            return this.areBasicPredicates(step.getPredicates());
        }
        return false;
    }

    protected boolean areBasicPredicates(Expression[] predicates) {
        if (predicates != null && predicates.length != 0) {
            boolean firstIndex = true;
            for (int i = 0; i < predicates.length; ++i) {
                if (predicates[i] instanceof NameAttributeTest) {
                    if (!((NameAttributeTest)predicates[i]).getNameTestExpression().isContextDependent()) continue;
                    return false;
                }
                if (predicates[i].isContextDependent()) {
                    return false;
                }
                if (!firstIndex) {
                    return false;
                }
                firstIndex = false;
            }
        }
        return true;
    }

    protected Pointer getSingleNodePointerForSteps(EvalContext context) {
        if (this.steps.length == 0) {
            return context.getSingleNodePointer();
        }
        if (this.isSimplePath()) {
            NodePointer ptr = (NodePointer)context.getSingleNodePointer();
            return SimplePathInterpreter.interpretSimpleLocationPath(context, ptr, this.steps);
        }
        return this.searchForPath(context);
    }

    protected Pointer searchForPath(EvalContext context) {
        EvalContext ctx = this.buildContextChain(context, this.steps.length, true);
        Pointer pointer = ctx.getSingleNodePointer();
        if (pointer != null) {
            return pointer;
        }
        int i = this.steps.length;
        while (--i > 0) {
            if (!this.isSimpleStep(this.steps[i])) {
                return null;
            }
            ctx = this.buildContextChain(context, i, true);
            if (!ctx.hasNext()) continue;
            Pointer partial = (Pointer)ctx.next();
            if (ctx.hasNext()) {
                return null;
            }
            if (!(partial instanceof NodePointer)) continue;
            return SimplePathInterpreter.createNullPointer(context, (NodePointer)partial, this.steps, i);
        }
        return null;
    }

    protected EvalContext evalSteps(EvalContext context) {
        return this.buildContextChain(context, this.steps.length, false);
    }

    protected EvalContext buildContextChain(EvalContext context, int stepCount, boolean createInitialContext) {
        if (createInitialContext) {
            context = new InitialContext(context);
        }
        if (this.steps.length == 0) {
            return context;
        }
        for (int i = 0; i < stepCount; ++i) {
            context = this.createContextForStep(context, this.steps[i].getAxis(), this.steps[i].getNodeTest());
            Expression[] predicates = this.steps[i].getPredicates();
            if (predicates == null) continue;
            for (int j = 0; j < predicates.length; ++j) {
                if (j != 0) {
                    context = new UnionContext(context, new EvalContext[]{context});
                }
                context = new PredicateContext(context, predicates[j]);
            }
        }
        return context;
    }

    protected EvalContext createContextForStep(EvalContext context, int axis, NodeTest nodeTest) {
        QName qname;
        String prefix;
        if (nodeTest instanceof NodeNameTest && (prefix = (qname = ((NodeNameTest)nodeTest).getNodeName()).getPrefix()) != null) {
            String namespaceURI = context.getJXPathContext().getNamespaceURI(prefix);
            nodeTest = new NodeNameTest(qname, namespaceURI);
        }
        switch (axis) {
            case 4: {
                return new AncestorContext(context, false, nodeTest);
            }
            case 10: {
                return new AncestorContext(context, true, nodeTest);
            }
            case 5: {
                return new AttributeContext(context, nodeTest);
            }
            case 2: {
                return new ChildContext(context, nodeTest, false, false);
            }
            case 9: {
                return new DescendantContext(context, false, nodeTest);
            }
            case 13: {
                return new DescendantContext(context, true, nodeTest);
            }
            case 8: {
                return new PrecedingOrFollowingContext(context, nodeTest, false);
            }
            case 11: {
                return new ChildContext(context, nodeTest, true, false);
            }
            case 6: {
                return new NamespaceContext(context, nodeTest);
            }
            case 3: {
                return new ParentContext(context, nodeTest);
            }
            case 7: {
                return new PrecedingOrFollowingContext(context, nodeTest, true);
            }
            case 12: {
                return new ChildContext(context, nodeTest, true, true);
            }
            case 1: {
                return new SelfContext(context, nodeTest);
            }
        }
        return null;
    }
}

