/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.compiler;

import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.EvalContext;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.compiler.Expression;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.ri.compiler.Operation;

public abstract class CoreOperation
extends Operation {
    protected static final int OR_PRECEDENCE = 0;
    protected static final int AND_PRECEDENCE = 1;
    protected static final int COMPARE_PRECEDENCE = 2;
    protected static final int RELATIONAL_EXPR_PRECEDENCE = 3;
    protected static final int ADD_PRECEDENCE = 4;
    protected static final int MULTIPLY_PRECEDENCE = 5;
    protected static final int NEGATE_PRECEDENCE = 6;
    protected static final int UNION_PRECEDENCE = 7;

    public CoreOperation(Expression[] args2) {
        super(args2);
    }

    public Object compute(EvalContext context) {
        return this.computeValue(context);
    }

    public abstract Object computeValue(EvalContext var1);

    public abstract String getSymbol();

    protected abstract boolean isSymmetric();

    protected abstract int getPrecedence();

    public String toString() {
        if (this.args.length == 1) {
            return this.getSymbol() + this.parenthesize(this.args[0], false);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                buffer.append(' ');
                buffer.append(this.getSymbol());
                buffer.append(' ');
            }
            buffer.append(this.parenthesize(this.args[i], i == 0));
        }
        return buffer.toString();
    }

    private String parenthesize(Expression expression, boolean left) {
        String s = expression.toString();
        if (!(expression instanceof CoreOperation)) {
            return s;
        }
        int compared = this.getPrecedence() - ((CoreOperation)expression).getPrecedence();
        if (compared < 0) {
            return s;
        }
        if (compared == 0 && (this.isSymmetric() || left)) {
            return s;
        }
        return '(' + s + ')';
    }
}

