/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jasypt.encryption.pbe;

import com.hypherionmc.sdlink.shaded.jasypt.commons.CommonUtils;
import com.hypherionmc.sdlink.shaded.jasypt.encryption.pbe.PBEStringCleanablePasswordEncryptor;
import com.hypherionmc.sdlink.shaded.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import com.hypherionmc.sdlink.shaded.jasypt.encryption.pbe.config.PBEConfig;
import com.hypherionmc.sdlink.shaded.jasypt.exceptions.AlreadyInitializedException;
import com.hypherionmc.sdlink.shaded.jasypt.iv.IvGenerator;
import com.hypherionmc.sdlink.shaded.jasypt.salt.SaltGenerator;
import java.security.Provider;

public final class PooledPBEStringEncryptor
implements PBEStringCleanablePasswordEncryptor {
    private final StandardPBEStringEncryptor firstEncryptor = new StandardPBEStringEncryptor();
    private PBEConfig config = null;
    private int poolSize = 0;
    private boolean poolSizeSet = false;
    private StandardPBEStringEncryptor[] pool;
    private int roundRobin = 0;
    private boolean initialized = false;

    public synchronized void setConfig(PBEConfig config) {
        this.firstEncryptor.setConfig(config);
        this.config = config;
    }

    public void setAlgorithm(String algorithm) {
        this.firstEncryptor.setAlgorithm(algorithm);
    }

    @Override
    public void setPassword(String password) {
        this.firstEncryptor.setPassword(password);
    }

    @Override
    public synchronized void setPasswordCharArray(char[] password) {
        this.firstEncryptor.setPasswordCharArray(password);
    }

    public void setKeyObtentionIterations(int keyObtentionIterations) {
        this.firstEncryptor.setKeyObtentionIterations(keyObtentionIterations);
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        this.firstEncryptor.setSaltGenerator(saltGenerator);
    }

    public void setIvGenerator(IvGenerator ivGenerator) {
        this.firstEncryptor.setIvGenerator(ivGenerator);
    }

    public void setProviderName(String providerName) {
        this.firstEncryptor.setProviderName(providerName);
    }

    public void setProvider(Provider provider) {
        this.firstEncryptor.setProvider(provider);
    }

    public synchronized void setStringOutputType(String stringOutputType) {
        this.firstEncryptor.setStringOutputType(stringOutputType);
    }

    public synchronized void setPoolSize(int poolSize) {
        CommonUtils.validateIsTrue(poolSize > 0, "Pool size be > 0");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.poolSize = poolSize;
        this.poolSizeSet = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            if (this.config != null) {
                Integer configPoolSize = this.config.getPoolSize();
                int n = this.poolSize = this.poolSizeSet || configPoolSize == null ? this.poolSize : configPoolSize;
            }
            if (this.poolSize <= 0) {
                throw new IllegalArgumentException("Pool size must be set and > 0");
            }
            this.pool = this.firstEncryptor.cloneAndInitializeEncryptor(this.poolSize);
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encrypt(String message) {
        int poolPosition;
        if (!this.isInitialized()) {
            this.initialize();
        }
        PooledPBEStringEncryptor pooledPBEStringEncryptor = this;
        synchronized (pooledPBEStringEncryptor) {
            poolPosition = this.roundRobin;
            this.roundRobin = (this.roundRobin + 1) % this.poolSize;
        }
        return this.pool[poolPosition].encrypt(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decrypt(String encryptedMessage) {
        int poolPosition;
        if (!this.isInitialized()) {
            this.initialize();
        }
        PooledPBEStringEncryptor pooledPBEStringEncryptor = this;
        synchronized (pooledPBEStringEncryptor) {
            poolPosition = this.roundRobin;
            this.roundRobin = (this.roundRobin + 1) % this.poolSize;
        }
        return this.pool[poolPosition].decrypt(encryptedMessage);
    }
}

