/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jasypt.encryption.pbe;

import com.hypherionmc.sdlink.shaded.jasypt.commons.CommonUtils;
import com.hypherionmc.sdlink.shaded.jasypt.encryption.pbe.PBEByteCleanablePasswordEncryptor;
import com.hypherionmc.sdlink.shaded.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import com.hypherionmc.sdlink.shaded.jasypt.encryption.pbe.config.PBEConfig;
import com.hypherionmc.sdlink.shaded.jasypt.exceptions.AlreadyInitializedException;
import com.hypherionmc.sdlink.shaded.jasypt.exceptions.EncryptionOperationNotPossibleException;
import com.hypherionmc.sdlink.shaded.jasypt.iv.IvGenerator;
import com.hypherionmc.sdlink.shaded.jasypt.salt.SaltGenerator;
import java.security.Provider;

public final class PooledPBEByteEncryptor
implements PBEByteCleanablePasswordEncryptor {
    private final StandardPBEByteEncryptor firstEncryptor = new StandardPBEByteEncryptor();
    private PBEConfig config = null;
    private int poolSize = 0;
    private boolean poolSizeSet = false;
    private StandardPBEByteEncryptor[] pool;
    private int roundRobin = 0;
    private boolean initialized = false;

    public synchronized void setConfig(PBEConfig config) {
        this.firstEncryptor.setConfig(config);
        this.config = config;
    }

    public synchronized void setAlgorithm(String algorithm) {
        this.firstEncryptor.setAlgorithm(algorithm);
    }

    @Override
    public synchronized void setPassword(String password) {
        this.firstEncryptor.setPassword(password);
    }

    @Override
    public synchronized void setPasswordCharArray(char[] password) {
        this.firstEncryptor.setPasswordCharArray(password);
    }

    public synchronized void setKeyObtentionIterations(int keyObtentionIterations) {
        this.firstEncryptor.setKeyObtentionIterations(keyObtentionIterations);
    }

    public synchronized void setSaltGenerator(SaltGenerator saltGenerator) {
        this.firstEncryptor.setSaltGenerator(saltGenerator);
    }

    public synchronized void setIvGenerator(IvGenerator ivGenerator) {
        this.firstEncryptor.setIvGenerator(ivGenerator);
    }

    public synchronized void setProviderName(String providerName) {
        this.firstEncryptor.setProviderName(providerName);
    }

    public synchronized void setProvider(Provider provider) {
        this.firstEncryptor.setProvider(provider);
    }

    public synchronized void setPoolSize(int poolSize) {
        CommonUtils.validateIsTrue(poolSize > 0, "Pool size be > 0");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.poolSize = poolSize;
        this.poolSizeSet = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            if (this.config != null) {
                Integer configPoolSize = this.config.getPoolSize();
                int n = this.poolSize = this.poolSizeSet || configPoolSize == null ? this.poolSize : configPoolSize;
            }
            if (this.poolSize <= 0) {
                throw new IllegalArgumentException("Pool size must be set and > 0");
            }
            this.pool = this.firstEncryptor.cloneAndInitializeEncryptor(this.poolSize);
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(byte[] message) throws EncryptionOperationNotPossibleException {
        int poolPosition;
        if (!this.isInitialized()) {
            this.initialize();
        }
        PooledPBEByteEncryptor pooledPBEByteEncryptor = this;
        synchronized (pooledPBEByteEncryptor) {
            poolPosition = this.roundRobin;
            this.roundRobin = (this.roundRobin + 1) % this.poolSize;
        }
        return this.pool[poolPosition].encrypt(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] encryptedMessage) throws EncryptionOperationNotPossibleException {
        int poolPosition;
        if (!this.isInitialized()) {
            this.initialize();
        }
        PooledPBEByteEncryptor pooledPBEByteEncryptor = this;
        synchronized (pooledPBEByteEncryptor) {
            poolPosition = this.roundRobin;
            this.roundRobin = (this.roundRobin + 1) % this.poolSize;
        }
        return this.pool[poolPosition].decrypt(encryptedMessage);
    }
}

