/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jasypt.digest;

import com.hypherionmc.sdlink.shaded.jasypt.commons.CommonUtils;
import com.hypherionmc.sdlink.shaded.jasypt.digest.ByteDigester;
import com.hypherionmc.sdlink.shaded.jasypt.digest.config.DigesterConfig;
import com.hypherionmc.sdlink.shaded.jasypt.exceptions.AlreadyInitializedException;
import com.hypherionmc.sdlink.shaded.jasypt.exceptions.EncryptionInitializationException;
import com.hypherionmc.sdlink.shaded.jasypt.exceptions.EncryptionOperationNotPossibleException;
import com.hypherionmc.sdlink.shaded.jasypt.salt.RandomSaltGenerator;
import com.hypherionmc.sdlink.shaded.jasypt.salt.SaltGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;

public final class StandardByteDigester
implements ByteDigester {
    public static final String DEFAULT_ALGORITHM = "MD5";
    public static final int DEFAULT_SALT_SIZE_BYTES = 8;
    public static final int DEFAULT_ITERATIONS = 1000;
    private String algorithm = "MD5";
    private int saltSizeBytes = 8;
    private int iterations = 1000;
    private SaltGenerator saltGenerator = null;
    private String providerName = null;
    private Provider provider = null;
    private boolean invertPositionOfSaltInMessageBeforeDigesting = false;
    private boolean invertPositionOfPlainSaltInEncryptionResults = false;
    private boolean useLenientSaltSizeCheck = false;
    private DigesterConfig config = null;
    private boolean algorithmSet = false;
    private boolean saltSizeBytesSet = false;
    private boolean iterationsSet = false;
    private boolean saltGeneratorSet = false;
    private boolean providerNameSet = false;
    private boolean providerSet = false;
    private boolean invertPositionOfSaltInMessageBeforeDigestingSet = false;
    private boolean invertPositionOfPlainSaltInEncryptionResultsSet = false;
    private boolean useLenientSaltSizeCheckSet = false;
    private boolean initialized = false;
    private boolean useSalt = true;
    private MessageDigest md = null;
    private int digestLengthBytes = 0;

    public synchronized void setConfig(DigesterConfig config) {
        CommonUtils.validateNotNull(config, "Config cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.config = config;
    }

    public synchronized void setAlgorithm(String algorithm) {
        CommonUtils.validateNotEmpty(algorithm, "Algorithm cannot be empty");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.algorithm = algorithm;
        this.algorithmSet = true;
    }

    public synchronized void setSaltSizeBytes(int saltSizeBytes) {
        CommonUtils.validateIsTrue(saltSizeBytes >= 0, "Salt size in bytes must be non-negative");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.saltSizeBytes = saltSizeBytes;
        this.useSalt = saltSizeBytes > 0;
        this.saltSizeBytesSet = true;
    }

    public synchronized void setIterations(int iterations) {
        CommonUtils.validateIsTrue(iterations > 0, "Number of iterations must be greater than zero");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.iterations = iterations;
        this.iterationsSet = true;
    }

    public synchronized void setSaltGenerator(SaltGenerator saltGenerator) {
        CommonUtils.validateNotNull(saltGenerator, "Salt generator cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.saltGenerator = saltGenerator;
        this.saltGeneratorSet = true;
    }

    public synchronized void setProviderName(String providerName) {
        CommonUtils.validateNotNull(providerName, "Provider name cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.providerName = providerName;
        this.providerNameSet = true;
    }

    public synchronized void setProvider(Provider provider) {
        CommonUtils.validateNotNull(provider, "Provider cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.provider = provider;
        this.providerSet = true;
    }

    public synchronized void setInvertPositionOfSaltInMessageBeforeDigesting(boolean invertPositionOfSaltInMessageBeforeDigesting) {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.invertPositionOfSaltInMessageBeforeDigesting = invertPositionOfSaltInMessageBeforeDigesting;
        this.invertPositionOfSaltInMessageBeforeDigestingSet = true;
    }

    public synchronized void setInvertPositionOfPlainSaltInEncryptionResults(boolean invertPositionOfPlainSaltInEncryptionResults) {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.invertPositionOfPlainSaltInEncryptionResults = invertPositionOfPlainSaltInEncryptionResults;
        this.invertPositionOfPlainSaltInEncryptionResultsSet = true;
    }

    public synchronized void setUseLenientSaltSizeCheck(boolean useLenientSaltSizeCheck) {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.useLenientSaltSizeCheck = useLenientSaltSizeCheck;
        this.useLenientSaltSizeCheckSet = true;
    }

    StandardByteDigester cloneDigester() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        StandardByteDigester cloned = new StandardByteDigester();
        if (CommonUtils.isNotEmpty(this.algorithm)) {
            cloned.setAlgorithm(this.algorithm);
        }
        cloned.setInvertPositionOfPlainSaltInEncryptionResults(this.invertPositionOfPlainSaltInEncryptionResults);
        cloned.setInvertPositionOfSaltInMessageBeforeDigesting(this.invertPositionOfSaltInMessageBeforeDigesting);
        cloned.setIterations(this.iterations);
        if (this.provider != null) {
            cloned.setProvider(this.provider);
        }
        if (this.providerName != null) {
            cloned.setProviderName(this.providerName);
        }
        if (this.saltGenerator != null) {
            cloned.setSaltGenerator(this.saltGenerator);
        }
        cloned.setSaltSizeBytes(this.saltSizeBytes);
        cloned.setUseLenientSaltSizeCheck(this.useLenientSaltSizeCheck);
        return cloned;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            if (this.config != null) {
                Integer configIterations;
                Integer configSaltSizeBytes;
                String configAlgorithm = this.config.getAlgorithm();
                if (configAlgorithm != null) {
                    CommonUtils.validateNotEmpty(configAlgorithm, "Algorithm cannot be empty");
                }
                if ((configSaltSizeBytes = this.config.getSaltSizeBytes()) != null) {
                    CommonUtils.validateIsTrue(configSaltSizeBytes >= 0, "Salt size in bytes must be non-negative");
                }
                if ((configIterations = this.config.getIterations()) != null) {
                    CommonUtils.validateIsTrue(configIterations > 0, "Number of iterations must be greater than zero");
                }
                SaltGenerator configSaltGenerator = this.config.getSaltGenerator();
                String configProviderName = this.config.getProviderName();
                if (configProviderName != null) {
                    CommonUtils.validateNotEmpty(configProviderName, "Provider name cannot be empty");
                }
                Provider configProvider = this.config.getProvider();
                Boolean configInvertPositionOfSaltInMessageBeforeDigesting = this.config.getInvertPositionOfSaltInMessageBeforeDigesting();
                Boolean configInvertPositionOfPlainSaltInEncryptionResults = this.config.getInvertPositionOfPlainSaltInEncryptionResults();
                Boolean configUseLenientSaltSizeCheck = this.config.getUseLenientSaltSizeCheck();
                this.algorithm = this.algorithmSet || configAlgorithm == null ? this.algorithm : configAlgorithm;
                this.saltSizeBytes = this.saltSizeBytesSet || configSaltSizeBytes == null ? this.saltSizeBytes : configSaltSizeBytes;
                this.iterations = this.iterationsSet || configIterations == null ? this.iterations : configIterations;
                this.saltGenerator = this.saltGeneratorSet || configSaltGenerator == null ? this.saltGenerator : configSaltGenerator;
                this.providerName = this.providerNameSet || configProviderName == null ? this.providerName : configProviderName;
                this.provider = this.providerSet || configProvider == null ? this.provider : configProvider;
                this.invertPositionOfSaltInMessageBeforeDigesting = this.invertPositionOfSaltInMessageBeforeDigestingSet || configInvertPositionOfSaltInMessageBeforeDigesting == null ? this.invertPositionOfSaltInMessageBeforeDigesting : configInvertPositionOfSaltInMessageBeforeDigesting;
                this.invertPositionOfPlainSaltInEncryptionResults = this.invertPositionOfPlainSaltInEncryptionResultsSet || configInvertPositionOfPlainSaltInEncryptionResults == null ? this.invertPositionOfPlainSaltInEncryptionResults : configInvertPositionOfPlainSaltInEncryptionResults;
                boolean bl = this.useLenientSaltSizeCheck = this.useLenientSaltSizeCheckSet || configUseLenientSaltSizeCheck == null ? this.useLenientSaltSizeCheck : configUseLenientSaltSizeCheck;
            }
            if (this.saltGenerator == null) {
                this.saltGenerator = new RandomSaltGenerator();
            }
            if (this.useLenientSaltSizeCheck && !this.saltGenerator.includePlainSaltInEncryptionResults()) {
                throw new EncryptionInitializationException("The configured Salt Generator (" + this.saltGenerator.getClass().getName() + ") does not include plain salt in encryption results, which is not compatiblewith setting the salt size checking behaviour to \"lenient\".");
            }
            try {
                this.md = this.provider != null ? MessageDigest.getInstance(this.algorithm, this.provider) : (this.providerName != null ? MessageDigest.getInstance(this.algorithm, this.providerName) : MessageDigest.getInstance(this.algorithm));
            }
            catch (NoSuchAlgorithmException e) {
                throw new EncryptionInitializationException(e);
            }
            catch (NoSuchProviderException e) {
                throw new EncryptionInitializationException(e);
            }
            this.digestLengthBytes = this.md.getDigestLength();
            if (this.digestLengthBytes <= 0) {
                throw new EncryptionInitializationException("The configured algorithm (" + this.algorithm + ") or its provider do  not allow knowing the digest length beforehand (getDigestLength() operation), which is not compatiblewith setting the salt size checking behaviour to \"lenient\".");
            }
            this.initialized = true;
        }
    }

    @Override
    public byte[] digest(byte[] message) {
        if (message == null) {
            return null;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        byte[] salt = null;
        if (this.useSalt) {
            salt = this.saltGenerator.generateSalt(this.saltSizeBytes);
        }
        return this.digest(message, salt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] digest(byte[] message, byte[] salt) {
        try {
            byte[] digest = null;
            MessageDigest messageDigest = this.md;
            synchronized (messageDigest) {
                this.md.reset();
                if (salt != null) {
                    if (!this.invertPositionOfSaltInMessageBeforeDigesting) {
                        this.md.update(salt);
                        this.md.update(message);
                    } else {
                        this.md.update(message);
                        this.md.update(salt);
                    }
                } else {
                    this.md.update(message);
                }
                digest = this.md.digest();
                for (int i = 0; i < this.iterations - 1; ++i) {
                    this.md.reset();
                    digest = this.md.digest(digest);
                }
            }
            if (this.saltGenerator.includePlainSaltInEncryptionResults() && salt != null) {
                if (!this.invertPositionOfPlainSaltInEncryptionResults) {
                    return CommonUtils.appendArrays(salt, digest);
                }
                return CommonUtils.appendArrays(digest, salt);
            }
            return digest;
        }
        catch (Exception e) {
            throw new EncryptionOperationNotPossibleException();
        }
    }

    @Override
    public boolean matches(byte[] message, byte[] digest) {
        if (message == null) {
            return digest == null;
        }
        if (digest == null) {
            return false;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            byte[] salt = null;
            if (this.useSalt) {
                if (this.saltGenerator.includePlainSaltInEncryptionResults()) {
                    int digestSaltSize = this.saltSizeBytes;
                    if (this.digestLengthBytes > 0) {
                        if (this.useLenientSaltSizeCheck) {
                            if (digest.length < this.digestLengthBytes) {
                                throw new EncryptionOperationNotPossibleException();
                            }
                            digestSaltSize = digest.length - this.digestLengthBytes;
                        } else if (digest.length != this.digestLengthBytes + this.saltSizeBytes) {
                            throw new EncryptionOperationNotPossibleException();
                        }
                    } else if (digest.length < this.saltSizeBytes) {
                        throw new EncryptionOperationNotPossibleException();
                    }
                    if (!this.invertPositionOfPlainSaltInEncryptionResults) {
                        salt = new byte[digestSaltSize];
                        System.arraycopy(digest, 0, salt, 0, digestSaltSize);
                    } else {
                        salt = new byte[digestSaltSize];
                        System.arraycopy(digest, digest.length - digestSaltSize, salt, 0, digestSaltSize);
                    }
                } else {
                    salt = this.saltGenerator.generateSalt(this.saltSizeBytes);
                }
            }
            byte[] encryptedMessage = this.digest(message, salt);
            return StandardByteDigester.digestsAreEqual(encryptedMessage, digest);
        }
        catch (Exception e) {
            throw new EncryptionOperationNotPossibleException();
        }
    }

    private static boolean digestsAreEqual(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        int aLen = a.length;
        if (b.length != aLen) {
            return false;
        }
        int match = 0;
        for (int i = 0; i < aLen; ++i) {
            match |= a[i] ^ b[i];
        }
        return match == 0;
    }
}

