/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.requests;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.internal.utils.JDALogger;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.commons.JDAUtilitiesInfo;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.requests.OAuth2Action;
import com.hypherionmc.sdlink.shaded.okhttp3.Call;
import com.hypherionmc.sdlink.shaded.okhttp3.Callback;
import com.hypherionmc.sdlink.shaded.okhttp3.OkHttpClient;
import com.hypherionmc.sdlink.shaded.okhttp3.RequestBody;
import com.hypherionmc.sdlink.shaded.okhttp3.Response;
import java.io.IOException;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class OAuth2Requester {
    protected static final Logger LOGGER = JDALogger.getLog(OAuth2Requester.class);
    protected static final String USER_AGENT = "JDA-Utils Oauth2(https://github.com/Chew/JDA-Chewtils | " + JDAUtilitiesInfo.VERSION + ")";
    protected static final RequestBody EMPTY_BODY = RequestBody.create(null, new byte[0]);
    private final OkHttpClient httpClient;

    public OAuth2Requester(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    <T> void submitAsync(final OAuth2Action<T> request, final Consumer<T> success, final Consumer<Throwable> failure) {
        this.httpClient.newCall(request.buildRequest()).enqueue(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(Call call, Response response) {
                try {
                    Object value = request.handle(response);
                    OAuth2Requester.logSuccessfulRequest(request);
                    try {
                        if (value != null) {
                            success.accept(value);
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.error("OAuth2Action success callback threw an exception!", t);
                    }
                }
                catch (Throwable t) {
                    try {
                        failure.accept(t);
                    }
                    catch (Throwable t1) {
                        LOGGER.error("OAuth2Action success callback threw an exception!", t1);
                    }
                }
                finally {
                    response.close();
                }
            }

            @Override
            public void onFailure(Call call, IOException e) {
                LOGGER.error("Requester encountered an error when submitting a request!", (Throwable)e);
            }
        });
    }

    <T> T submitSync(OAuth2Action<T> request) throws IOException {
        try (Response response = this.httpClient.newCall(request.buildRequest()).execute();){
            T value = request.handle(response);
            OAuth2Requester.logSuccessfulRequest(request);
            T t = value;
            return t;
        }
    }

    private static void logSuccessfulRequest(OAuth2Action request) {
        LOGGER.debug("Got a response for {} - {}\nHeaders: {}", new Object[]{request.getMethod(), request.getUrl(), request.getHeaders()});
    }
}

