/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.requests;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.internal.requests.Method;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.internal.utils.Checks;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.entities.impl.OAuth2ClientImpl;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.requests.OAuth2Requester;
import com.hypherionmc.sdlink.shaded.javax.annotation.WillClose;
import com.hypherionmc.sdlink.shaded.okhttp3.Headers;
import com.hypherionmc.sdlink.shaded.okhttp3.Request;
import com.hypherionmc.sdlink.shaded.okhttp3.RequestBody;
import com.hypherionmc.sdlink.shaded.okhttp3.Response;
import java.io.IOException;
import java.util.function.Consumer;

public abstract class OAuth2Action<T> {
    protected static final Consumer DEFAULT_SUCCESS = t -> {};
    protected static final Consumer<Throwable> DEFAULT_FAILURE = t -> OAuth2Requester.LOGGER.error("Requester encountered an error while processing response!", t);
    protected final OAuth2ClientImpl client;
    protected final Method method;
    protected final String url;

    public OAuth2Action(OAuth2ClientImpl client, Method method, String url) {
        Checks.notNull(client, "OAuth2Client");
        Checks.notNull(method, "Request method");
        Checks.notEmpty(url, "URL");
        this.client = client;
        this.method = method;
        this.url = url;
    }

    protected RequestBody getBody() {
        return OAuth2Requester.EMPTY_BODY;
    }

    protected Headers getHeaders() {
        return Headers.of(new String[0]);
    }

    protected Request buildRequest() {
        Request.Builder builder = new Request.Builder();
        switch (this.method) {
            case GET: {
                builder.get();
                break;
            }
            case POST: {
                builder.post(this.getBody());
                break;
            }
            default: {
                throw new IllegalArgumentException(this.method.name() + " requests are not supported!");
            }
        }
        builder.url(this.url);
        builder.header("User-Agent", OAuth2Requester.USER_AGENT);
        builder.headers(this.getHeaders());
        return builder.build();
    }

    protected Method getMethod() {
        return this.method;
    }

    protected String getUrl() {
        return this.url;
    }

    public void queue() {
        this.queue(DEFAULT_SUCCESS);
    }

    public void queue(Consumer<T> success) {
        this.queue(success, DEFAULT_FAILURE);
    }

    public void queue(Consumer<T> success, Consumer<Throwable> failure) {
        this.client.getRequester().submitAsync(this, success, failure);
    }

    public T complete() throws IOException {
        return this.client.getRequester().submitSync(this);
    }

    public OAuth2ClientImpl getClient() {
        return this.client;
    }

    protected abstract T handle(@WillClose Response var1) throws IOException;
}

