/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.entities.impl;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.JDA;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.User;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.sharding.ShardManager;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.OAuth2Client;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.Scope;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.entities.OAuth2User;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.exceptions.MissingScopeException;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.session.Session;

public class OAuth2UserImpl
implements OAuth2User {
    private final OAuth2Client client;
    private final Session session;
    private final long id;
    private final String name;
    private final String discriminator;
    private final String avatar;
    private final String email;
    private final boolean verified;
    private final boolean mfaEnabled;
    private static final String[] DEFAULT_AVATARS = new String[]{"6debd47ed13483642cf09e832ed0bc1b", "322c936a8c8be1b803cd94861bdfa868", "dd4dbc0016779df1378e7812eabaa04d", "0e291f67c9274a1abdddeb3fd919cbaa", "1cbd08c76f8af6dddce02c5138971129"};

    public OAuth2UserImpl(OAuth2Client client, Session session, long id, String name, String discriminator, String avatar, String email, boolean verified, boolean mfaEnabled) {
        this.client = client;
        this.session = session;
        this.id = id;
        this.name = name;
        this.discriminator = discriminator;
        this.avatar = avatar;
        this.email = email;
        this.verified = verified;
        this.mfaEnabled = mfaEnabled;
    }

    @Override
    public OAuth2Client getClient() {
        return this.client;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public String getId() {
        return Long.toUnsignedString(this.id);
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmail() {
        if (!Scope.contains(this.getSession().getScopes(), Scope.EMAIL)) {
            throw new MissingScopeException("get email for user", Scope.EMAIL);
        }
        return this.email;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }

    @Override
    public boolean isMfaEnabled() {
        return this.mfaEnabled;
    }

    @Override
    public String getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public String getAvatarId() {
        return this.avatar;
    }

    @Override
    public String getAvatarUrl() {
        return this.getAvatarId() == null ? null : "https://cdn.discordapp.com/avatars/" + this.getId() + "/" + this.getAvatarId() + (this.getAvatarId().startsWith("a_") ? ".gif" : ".png");
    }

    @Override
    public String getDefaultAvatarId() {
        return DEFAULT_AVATARS[Integer.parseInt(this.getDiscriminator()) % DEFAULT_AVATARS.length];
    }

    @Override
    public String getDefaultAvatarUrl() {
        return "https://discord.com/assets/" + this.getDefaultAvatarId() + ".png";
    }

    @Override
    public String getEffectiveAvatarUrl() {
        return this.getAvatarUrl() == null ? this.getDefaultAvatarUrl() : this.getAvatarUrl();
    }

    @Override
    public String getAsMention() {
        return "<@" + this.id + '>';
    }

    @Override
    public User getJDAUser(JDA jda) {
        return jda.getUserById(this.id);
    }

    @Override
    public User getJDAUser(ShardManager shardManager) {
        return shardManager.getUserById(this.id);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OAuth2UserImpl)) {
            return false;
        }
        OAuth2UserImpl oUser = (OAuth2UserImpl)o;
        return this == oUser || this.id == oUser.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "U:" + this.getName() + '(' + this.id + ')';
    }
}

