/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.entities.impl;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.Permission;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.OAuth2Client;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2.entities.OAuth2Guild;
import java.util.EnumSet;

public class OAuth2GuildImpl
implements OAuth2Guild {
    private final OAuth2Client client;
    private final long id;
    private final String name;
    private final String icon;
    private final boolean owner;
    private final long permissions;

    public OAuth2GuildImpl(OAuth2Client client, long id, String name, String icon, boolean owner, long permissions) {
        this.client = client;
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.owner = owner;
        this.permissions = permissions;
    }

    @Override
    public OAuth2Client getClient() {
        return this.client;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIconId() {
        return this.icon;
    }

    @Override
    public String getIconUrl() {
        return this.icon == null ? null : "https://cdn.discordapp.com/icons/" + this.id + "/" + this.icon + ".png";
    }

    @Override
    public long getPermissionsRaw() {
        return this.permissions;
    }

    @Override
    public EnumSet<Permission> getPermissions() {
        return Permission.getPermissions(this.permissions);
    }

    @Override
    public boolean isOwner() {
        return this.owner;
    }

    @Override
    public boolean hasPermission(Permission ... perms) {
        if (this.isOwner()) {
            return true;
        }
        long adminPermRaw = Permission.ADMINISTRATOR.getRawValue();
        long permissions = this.getPermissionsRaw();
        if ((permissions & adminPermRaw) == adminPermRaw) {
            return true;
        }
        long checkPermsRaw = Permission.getRaw(perms);
        return (permissions & checkPermsRaw) == checkPermsRaw;
    }
}

