/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.oauth2;

public enum Scope {
    BOT("bot"),
    CONNECTIONS("connections"),
    EMAIL("email"),
    IDENTIFY("identify"),
    GUILDS("guilds"),
    GUILDS_JOIN("guilds.join"),
    GDM_JOIN("gdm.join"),
    MESSAGES_READ("messages.read"),
    RPC("rpc"),
    RPC_API("rpc.api"),
    RPC_NOTIFICATIONS_READ("rpc.notifications.read"),
    WEBHOOK_INCOMING("webhook.incoming"),
    UNKNOWN("");

    private final String text;

    private Scope(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public static boolean contains(Scope[] scopes, Scope scope) {
        if (scopes == null || scopes.length == 0 || scope == null || scope == UNKNOWN) {
            return false;
        }
        for (Scope s : scopes) {
            if (s != scope) continue;
            return true;
        }
        return false;
    }

    public static String join(Scope ... scopes) {
        return Scope.join(false, scopes);
    }

    public static String join(boolean bySpace, Scope ... scopes) {
        if (scopes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(scopes[0].getText());
        for (int i = 1; i < scopes.length; ++i) {
            if (bySpace) {
                sb.append(" ");
            } else {
                sb.append("%20");
            }
            sb.append(scopes[i].getText());
        }
        return sb.toString();
    }

    public static Scope from(String scope) {
        for (Scope s : Scope.values()) {
            if (!s.text.equalsIgnoreCase(scope)) continue;
            return s;
        }
        return UNKNOWN;
    }
}

