/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.menu;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.EmbedBuilder;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Message;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Role;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.User;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.emoji.Emoji;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.exceptions.PermissionException;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.requests.RestAction;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.messages.MessageCreateData;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.messages.MessageEditData;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.internal.utils.Checks;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.commons.waiter.EventWaiter;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.menu.Menu;
import java.awt.Color;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class SelectionDialog
extends Menu {
    private final List<String> choices;
    private final String leftEnd;
    private final String rightEnd;
    private final String defaultLeft;
    private final String defaultRight;
    private final Function<Integer, Color> color;
    private final boolean loop;
    private final Function<Integer, String> text;
    private final BiConsumer<Message, Integer> success;
    private final Consumer<Message> cancel;
    private final boolean singleSelectionMode;
    public static final String UP = "\ud83d\udd3c";
    public static final String DOWN = "\ud83d\udd3d";
    public static final String SELECT = "\u2705";
    public static final String CANCEL = "\u274e";

    SelectionDialog(EventWaiter waiter, Set<User> users, Set<Role> roles, long timeout2, TimeUnit unit, List<String> choices, String leftEnd, String rightEnd, String defaultLeft, String defaultRight, Function<Integer, Color> color, boolean loop, BiConsumer<Message, Integer> success, Consumer<Message> cancel, Function<Integer, String> text, boolean singleSelectionMode) {
        super(waiter, users, roles, timeout2, unit);
        this.choices = choices;
        this.leftEnd = leftEnd;
        this.rightEnd = rightEnd;
        this.defaultLeft = defaultLeft;
        this.defaultRight = defaultRight;
        this.color = color;
        this.loop = loop;
        this.success = success;
        this.cancel = cancel;
        this.text = text;
        this.singleSelectionMode = singleSelectionMode;
    }

    @Deprecated
    SelectionDialog(EventWaiter waiter, Set<User> users, Set<Role> roles, long timeout2, TimeUnit unit, List<String> choices, String leftEnd, String rightEnd, String defaultLeft, String defaultRight, Function<Integer, Color> color, boolean loop, BiConsumer<Message, Integer> success, Consumer<Message> cancel, Function<Integer, String> text) {
        this(waiter, users, roles, timeout2, unit, choices, leftEnd, rightEnd, defaultLeft, defaultRight, color, loop, success, cancel, text, false);
    }

    @Override
    public void display(MessageChannel channel) {
        this.showDialog(channel, 1);
    }

    @Override
    public void display(Message message) {
        this.showDialog(message, 1);
    }

    public void showDialog(MessageChannel channel, int selection) {
        if (selection < 1) {
            selection = 1;
        } else if (selection > this.choices.size()) {
            selection = this.choices.size();
        }
        MessageEditData msg = this.render(selection);
        this.initialize(channel.sendMessage(MessageCreateData.fromEditData(msg)), selection);
    }

    public void showDialog(Message message, int selection) {
        if (selection < 1) {
            selection = 1;
        } else if (selection > this.choices.size()) {
            selection = this.choices.size();
        }
        MessageEditData msg = this.render(selection);
        this.initialize(message.editMessage(msg), selection);
    }

    private void initialize(RestAction<Message> action, int selection) {
        action.queue(m -> {
            if (this.choices.size() > 1) {
                m.addReaction(Emoji.fromFormatted(UP)).queue();
                m.addReaction(Emoji.fromFormatted(SELECT)).queue();
                m.addReaction(Emoji.fromFormatted(CANCEL)).queue();
                m.addReaction(Emoji.fromFormatted(DOWN)).queue(v -> this.selectionDialog((Message)m, selection), v -> this.selectionDialog((Message)m, selection));
            } else {
                m.addReaction(Emoji.fromFormatted(SELECT)).queue();
                m.addReaction(Emoji.fromFormatted(CANCEL)).queue(v -> this.selectionDialog((Message)m, selection), v -> this.selectionDialog((Message)m, selection));
            }
        });
    }

    private void selectionDialog(Message message, int selection) {
        this.waiter.waitForEvent(MessageReactionAddEvent.class, event -> {
            if (!event.getMessageId().equals(message.getId())) {
                return false;
            }
            if (!(UP.equals(event.getReaction().getEmoji().getName()) || DOWN.equals(event.getReaction().getEmoji().getName()) || CANCEL.equals(event.getReaction().getEmoji().getName()) || SELECT.equals(event.getReaction().getEmoji().getName()))) {
                return false;
            }
            return this.isValidUser(event.getUser(), event.isFromGuild() ? event.getGuild() : null);
        }, event -> {
            int newSelection = selection;
            switch (event.getReaction().getEmoji().getName()) {
                case "\ud83d\udd3c": {
                    if (newSelection > 1) {
                        --newSelection;
                        break;
                    }
                    if (!this.loop) break;
                    newSelection = this.choices.size();
                    break;
                }
                case "\ud83d\udd3d": {
                    if (newSelection < this.choices.size()) {
                        ++newSelection;
                        break;
                    }
                    if (!this.loop) break;
                    newSelection = 1;
                    break;
                }
                case "\u2705": {
                    this.success.accept(message, selection);
                    if (!this.singleSelectionMode) break;
                    return;
                }
                case "\u274e": {
                    this.cancel.accept(message);
                    return;
                }
            }
            try {
                event.getReaction().removeReaction(event.getUser()).queue();
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
            int n = newSelection;
            message.editMessage(this.render(n)).queue(m -> this.selectionDialog((Message)m, n));
        }, this.timeout, this.unit, () -> this.cancel.accept(message));
    }

    private MessageEditData render(int selection) {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < this.choices.size(); ++i) {
            if (i + 1 == selection) {
                sbuilder.append("\n").append(this.leftEnd).append(this.choices.get(i)).append(this.rightEnd);
                continue;
            }
            sbuilder.append("\n").append(this.defaultLeft).append(this.choices.get(i)).append(this.defaultRight);
        }
        MessageEditBuilder mbuilder = new MessageEditBuilder();
        String content = this.text.apply(selection);
        if (content != null) {
            mbuilder.setContent(content);
        }
        return ((MessageEditBuilder)mbuilder.setEmbeds(new EmbedBuilder().setColor(this.color.apply(selection)).setDescription(sbuilder.toString()).build())).build();
    }

    public static class Builder
    extends Menu.Builder<Builder, SelectionDialog> {
        private final List<String> choices = new LinkedList<String>();
        private String leftEnd = "";
        private String rightEnd = "";
        private String defaultLeft = "";
        private String defaultRight = "";
        private Function<Integer, Color> color = i -> null;
        private boolean loop = true;
        private Function<Integer, String> text = i -> null;
        private BiConsumer<Message, Integer> selection;
        private Consumer<Message> cancel = m -> {};
        private boolean singleSelectionMode = false;

        @Override
        public SelectionDialog build() {
            Checks.check(this.waiter != null, "Must set an EventWaiter");
            Checks.check(!this.choices.isEmpty(), "Must have at least one choice");
            Checks.check(this.selection != null, "Must provide a selection consumer");
            return new SelectionDialog(this.waiter, this.users, this.roles, this.timeout, this.unit, this.choices, this.leftEnd, this.rightEnd, this.defaultLeft, this.defaultRight, this.color, this.loop, this.selection, this.cancel, this.text, this.singleSelectionMode);
        }

        public Builder setColor(Color color) {
            this.color = i -> color;
            return this;
        }

        public Builder setColor(Function<Integer, Color> color) {
            this.color = color;
            return this;
        }

        public Builder setText(String text) {
            this.text = i -> text;
            return this;
        }

        public Builder setText(Function<Integer, String> text) {
            this.text = text;
            return this;
        }

        public Builder setSelectedEnds(String left, String right) {
            this.leftEnd = left;
            this.rightEnd = right;
            return this;
        }

        public Builder setDefaultEnds(String left, String right) {
            this.defaultLeft = left;
            this.defaultRight = right;
            return this;
        }

        public Builder useLooping(boolean loop) {
            this.loop = loop;
            return this;
        }

        public Builder useSingleSelectionMode(boolean singleSelectionMode) {
            this.singleSelectionMode = singleSelectionMode;
            return this;
        }

        public Builder setSelectionConsumer(BiConsumer<Message, Integer> selection) {
            this.selection = selection;
            return this;
        }

        public Builder setCanceled(Consumer<Message> cancel) {
            this.cancel = cancel;
            return this;
        }

        public Builder clearChoices() {
            this.choices.clear();
            return this;
        }

        public Builder setChoices(String ... choices) {
            this.choices.clear();
            this.choices.addAll(Arrays.asList(choices));
            return this;
        }

        public Builder addChoices(String ... choices) {
            this.choices.addAll(Arrays.asList(choices));
            return this;
        }
    }
}

