/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.examples.command;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.EmbedBuilder;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.OnlineStatus;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.Permission;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.Region;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Guild;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.Command;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.CommandEvent;
import java.time.format.DateTimeFormatter;

public class ServerinfoCommand
extends Command {
    private static final String LINESTART = "\u25ab";
    private static final String GUILD_EMOJI = "\ud83d\udda5";
    private static final String NO_REGION = "\u2754";

    public ServerinfoCommand() {
        this.name = "serverinfo";
        this.aliases = new String[]{"server", "guildinfo"};
        this.help = "shows server info";
        this.botPermissions = new Permission[]{Permission.MESSAGE_EMBED_LINKS};
        this.guildOnly = true;
    }

    @Override
    protected void execute(CommandEvent event) {
        Guild guild = event.getGuild();
        Member owner = guild.getOwner();
        long onlineCount = guild.getMembers().stream().filter(u -> u.getOnlineStatus() != OnlineStatus.OFFLINE).count();
        long botCount = guild.getMembers().stream().filter(m -> m.getUser().isBot()).count();
        EmbedBuilder builder = new EmbedBuilder();
        String title = ("\ud83d\udda5 Information about **" + guild.getName() + "**:").replace("@everyone", "@\u0435veryone").replace("@here", "@h\u0435re").replace("discord.gg/", "dis\u0441ord.gg/");
        String str = "\u25abID: **" + guild.getId() + "**\n" + LINESTART + "Owner: " + (owner == null ? "Unknown" : "**" + owner.getUser().getName() + "**#" + owner.getUser().getDiscriminator()) + "\n";
        if (!guild.getVoiceChannels().isEmpty()) {
            Region reg = guild.getVoiceChannels().get(0).getRegion();
            str = str + "\u25abLocation: " + (reg.getEmoji() == null || reg.getEmoji().isEmpty() ? NO_REGION : reg.getEmoji()) + " **" + reg.getName() + "**\n";
        }
        str = str + "\u25abCreation: **" + guild.getTimeCreated().format(DateTimeFormatter.RFC_1123_DATE_TIME) + "**\n" + LINESTART + "Users: **" + guild.getMemberCache().size() + "** (" + onlineCount + " online, " + botCount + " bots)\n" + LINESTART + "Channels: **" + guild.getTextChannelCache().size() + "** Text, **" + guild.getVoiceChannelCache().size() + "** Voice, **" + guild.getCategoryCache().size() + "** Categories\n" + LINESTART + "Verification: **" + guild.getVerificationLevel().name() + "**";
        if (!guild.getFeatures().isEmpty()) {
            str = str + "\n\u25abFeatures: **" + String.join((CharSequence)"**, **", guild.getFeatures()) + "**";
        }
        if (guild.getSplashId() != null) {
            builder.setImage(guild.getSplashUrl() + "?size=1024");
            str = str + "\n\u25abSplash: ";
        }
        if (guild.getIconUrl() != null) {
            builder.setThumbnail(guild.getIconUrl());
        }
        builder.setColor(owner == null ? null : owner.getColor());
        builder.setDescription(str);
        event.reply(((MessageCreateBuilder)((MessageCreateBuilder)new MessageCreateBuilder().setContent(title)).setEmbeds(builder.build())).build());
    }
}

