/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.examples.command;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.EmbedBuilder;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.Permission;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Role;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.Command;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.CommandEvent;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.commons.utils.FinderUtil;
import java.awt.Color;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;

public class RoleinfoCommand
extends Command {
    private static final String LINESTART = "\u25ab";
    private static final String ROLE_EMOJI = "\ud83c\udfad";

    public RoleinfoCommand() {
        this.name = "roleinfo";
        this.aliases = new String[]{"rinfo", "rankinfo"};
        this.help = "shows info about a role";
        this.arguments = "<role>";
        this.botPermissions = new Permission[]{Permission.MESSAGE_EMBED_LINKS};
        this.guildOnly = true;
    }

    @Override
    protected void execute(CommandEvent event) {
        if (event.getArgs().isEmpty()) {
            event.replyError("Please provide the name of a role!");
            return;
        }
        List<Role> found = FinderUtil.findRoles(event.getArgs(), event.getGuild());
        if (found.isEmpty()) {
            event.replyError("I couldn't find the role you were looking for!");
            return;
        }
        if (found.size() > 1) {
            event.replyWarning(RoleinfoCommand.listOfRoles(found, event.getArgs()));
            return;
        }
        Role role = found.get(0);
        String title = ("\ud83c\udfad Information about **" + role.getName() + "**:").replace("@everyone", "@\u0435veryone").replace("@here", "@h\u0435re").replace("discord.gg/", "dis\u0441ord.gg/");
        List<Member> list = role.isPublicRole() ? event.getGuild().getMembers() : event.getGuild().getMembersWithRoles(role);
        Color color = role.getColor();
        StringBuilder desr = new StringBuilder("\u25abID: **" + role.getId() + "**\n" + LINESTART + "Creation: **" + role.getTimeCreated().format(DateTimeFormatter.RFC_1123_DATE_TIME) + "**\n" + LINESTART + "Position: **" + role.getPosition() + "**\n" + LINESTART + "Color: **#" + (color == null ? "000000" : Integer.toHexString(color.getRGB()).toUpperCase(Locale.ROOT).substring(2)) + "**\n" + LINESTART + "Mentionable: **" + role.isMentionable() + "**\n" + LINESTART + "Hoisted: **" + role.isHoisted() + "**\n" + LINESTART + "Managed: **" + role.isManaged() + "**\n" + LINESTART + "Permissions: ");
        if (role.getPermissions().isEmpty()) {
            desr.append("None");
        } else {
            desr.append(role.getPermissions().stream().map(p -> "`, `" + p.getName()).reduce("", String::concat).substring(3)).append("`");
        }
        desr.append("\n").append(LINESTART).append("Members: **").append(list.size()).append("**\n");
        if (list.size() * 24 <= 2048 - desr.length()) {
            list.forEach(m -> desr.append("<@").append(m.getUser().getId()).append("> "));
        }
        event.reply(((MessageCreateBuilder)((MessageCreateBuilder)new MessageCreateBuilder().setContent(title)).setEmbeds(new EmbedBuilder().setDescription(desr.toString().trim()).setColor(role.getColor()).build())).build());
    }

    private static String listOfRoles(List<Role> list, String query) {
        String out = String.format("**Multiple roles found matching \"%s\":**", query);
        for (int i = 0; i < 6 && i < list.size(); ++i) {
            out = out + "\n - " + list.get(i).getName() + " (ID:" + list.get(i).getId() + ")";
        }
        if (list.size() > 6) {
            out = out + "\n**And " + (list.size() - 6) + " more...**";
        }
        return out;
    }
}

