/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.examples.command;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.JDA;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.Permission;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.channel.ChannelType;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.exceptions.PermissionException;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.Command;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.CommandEvent;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.commons.waiter.EventWaiter;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.standard.CommandInfo;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.standard.Error;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.standard.RequiredPermissions;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.examples.doc.Author;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.menu.Paginator;
import java.awt.Color;
import java.util.concurrent.TimeUnit;

@CommandInfo(name={"Guildlist"}, description="Gets a paginated list of the guilds the bot is on.", requirements={"The bot has all necessary permissions.", "The user is the bot's owner."})
@Error(value="If arguments are provided, but they are not an integer.", response="[PageNumber] is not a valid integer!")
@RequiredPermissions(value={Permission.MESSAGE_EMBED_LINKS, Permission.MESSAGE_ADD_REACTION})
@Author(value="John Grosh (jagrosh)")
public class GuildlistCommand
extends Command {
    private final Paginator.Builder pbuilder;

    public GuildlistCommand(EventWaiter waiter) {
        this.name = "guildlist";
        this.help = "shows the list of guilds the bot is on";
        this.arguments = "[pagenum]";
        this.botPermissions = new Permission[]{Permission.MESSAGE_EMBED_LINKS, Permission.MESSAGE_ADD_REACTION};
        this.guildOnly = false;
        this.ownerCommand = true;
        this.pbuilder = (Paginator.Builder)((Paginator.Builder)new Paginator.Builder().setColumns(1).setItemsPerPage(10).showPageNumbers(true).waitOnSinglePage(false).useNumberedItems(false).setFinalAction(m -> {
            try {
                m.clearReactions().queue();
            }
            catch (PermissionException ex) {
                m.delete().queue();
            }
        }).setEventWaiter(waiter)).setTimeout(1L, TimeUnit.MINUTES);
    }

    @Override
    protected void execute(CommandEvent event) {
        int page = 1;
        if (!event.getArgs().isEmpty()) {
            try {
                page = Integer.parseInt(event.getArgs());
            }
            catch (NumberFormatException e) {
                event.reply(event.getClient().getError() + " `" + event.getArgs() + "` is not a valid integer!");
                return;
            }
        }
        this.pbuilder.clearItems();
        event.getJDA().getGuilds().stream().map(g -> "**" + g.getName() + "** (ID:" + g.getId() + ") ~ " + g.getMembers().size() + " Members").forEach(xva$0 -> this.pbuilder.addItems((String)xva$0));
        Paginator p = ((Paginator.Builder)this.pbuilder.setColor(event.isFromType(ChannelType.TEXT) ? event.getSelfMember().getColor() : Color.black).setText(event.getClient().getSuccess() + " Guilds that **" + event.getSelfUser().getName() + "** is connected to" + (event.getJDA().getShardInfo() == JDA.ShardInfo.SINGLE ? ":" : "(Shard ID " + event.getJDA().getShardInfo().getShardId() + "):")).setUsers(event.getAuthor())).build();
        p.paginate(event.getChannel(), page);
    }
}

