/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.standard;

import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.ConvertedBy;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.DocConverter;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.DocMultiple;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.standard.Errors;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@ConvertedBy(value=Converter.class)
@DocMultiple(preface="**Possible Errors:**\n\n", prefixEach="+ ", separateBy="\n\n")
@Documented
@Repeatable(value=Errors.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface Error {
    public String value();

    public String response() default "";

    public String prefix() default "";

    public static class Converter
    implements DocConverter<Error> {
        @Override
        public String read(Error annotation) {
            StringBuilder b = new StringBuilder(annotation.prefix());
            if (!annotation.response().isEmpty()) {
                b.append("\"").append(annotation.response()).append("\" - ");
            }
            b.append(annotation.value());
            return b.toString();
        }
    }
}

