/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.standard;

import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.ConvertedBy;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.DocConverter;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@ConvertedBy(value=Converter.class)
@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface CommandInfo {
    public String[] name() default {};

    public String usage() default "";

    public String description() default "";

    public String[] requirements() default {};

    public static class Converter
    implements DocConverter<CommandInfo> {
        @Override
        public String read(CommandInfo annotation) {
            int i;
            String[] names = annotation.name();
            String usage = annotation.usage();
            String description = annotation.description();
            String[] requirements = annotation.requirements();
            StringBuilder b = new StringBuilder();
            if (names.length > 0) {
                b.append("**Name:** `").append(names[0]).append("`").append("\n\n");
                if (names.length > 1) {
                    b.append("**Aliases:**");
                    for (i = 1; i < names.length; ++i) {
                        b.append(" `").append(names[i]).append("`").append(i != names.length - 1 ? "," : "\n\n");
                    }
                }
            }
            if (!usage.isEmpty()) {
                b.append("**Usage:** ").append(usage).append("\n\n");
            }
            if (!description.isEmpty()) {
                b.append("**Description:** ").append(description).append("\n\n");
            }
            if (requirements.length == 1) {
                b.append("**Requirement:** ").append(requirements[0]).append("\n\n");
            } else if (requirements.length > 1) {
                b.append("**Requirements:**\n");
                for (i = 1; i <= requirements.length; ++i) {
                    b.append(i).append(") ").append(requirements[i - 1]);
                    if (i == requirements.length) continue;
                    b.append("\n");
                }
            }
            return b.toString();
        }
    }
}

