/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc;

import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.commons.utils.FixedSizeCache;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.ConvertedBy;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.DocConverter;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.DocMultiple;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.standard.CommandInfo;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.standard.Error;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.doc.standard.RequiredPermissions;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class DocGenerator {
    private final HashMap<Class<? extends Annotation>, DocConverter<? extends Annotation>> map;
    private final FixedSizeCache<AnnotatedElement, String> cache;
    private final String separator;

    public static DocGenerator getDefaultGenerator() {
        return new DocGenerator().register(CommandInfo.class, new Object[0]).register(Error.class, new Object[0]).register(RequiredPermissions.class, new Object[0]);
    }

    public DocGenerator() {
        this(20);
    }

    public DocGenerator(int cacheSize) {
        this("\n\n", cacheSize);
    }

    public DocGenerator(String separator, int cacheSize) {
        this.separator = separator;
        this.map = new HashMap();
        this.cache = new FixedSizeCache(cacheSize);
    }

    public String getDocFor(Class<?> cla) {
        return this.read(cla);
    }

    public String getDocFor(Method method) {
        return this.read(method);
    }

    public List<String> getDocForMethods(Class<?> cla) {
        ArrayList<String> list = new ArrayList<String>();
        for (Method method : cla.getMethods()) {
            String doc = this.read(method);
            if (doc.isEmpty()) continue;
            list.add(doc);
        }
        return list;
    }

    public <T extends Annotation> DocGenerator register(Class<T> type, Object ... converterParams) {
        DocConverter instance;
        ConvertedBy convertedBy = type.getAnnotation(ConvertedBy.class);
        if (convertedBy == null) {
            throw new IllegalArgumentException("Illegal annotation type! Not annotated with @ConvertedBy!");
        }
        try {
            if (converterParams.length > 0) {
                Class[] tArray = Arrays.stream(converterParams).map(Object::getClass).collect(Collectors.toList()).toArray(new Class[converterParams.length]);
                instance = convertedBy.value().getDeclaredConstructor(tArray).newInstance(converterParams);
            } else {
                instance = convertedBy.value().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Instance of " + convertedBy.value() + " could not be instantiated!", e);
        }
        return this.register(type, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Annotation> DocGenerator register(Class<T> type, DocConverter<T> converter) {
        HashMap<Class<? extends Annotation>, DocConverter<? extends Annotation>> hashMap = this.map;
        synchronized (hashMap) {
            this.map.put(type, converter);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(AnnotatedElement ae) {
        if (this.cache.contains(ae)) {
            return this.cache.get(ae);
        }
        StringBuilder b = new StringBuilder();
        HashMap<Class<? extends Annotation>, DocConverter<? extends Annotation>> hashMap = this.map;
        synchronized (hashMap) {
            int lastIndex = this.map.keySet().size() - 1;
            int index = 0;
            for (Class<? extends Annotation> key : this.map.keySet()) {
                DocMultiple docMultiple = key.getAnnotation(DocMultiple.class);
                if (docMultiple == null) {
                    Annotation a = ae.getAnnotation(key);
                    if (a == null) continue;
                    b.append(this.map.get(key).read(a));
                    if (index >= lastIndex) continue;
                    b.append(this.separator);
                    continue;
                }
                Annotation[] ans = ae.getAnnotationsByType(key);
                int len = ans.length;
                for (int i = 0; i < len; ++i) {
                    if (i == 0) {
                        b.append(docMultiple.preface());
                    }
                    b.append(docMultiple.prefixEach()).append(this.map.get(key).read(ans[i]));
                    if (i < len - 1) {
                        b.append(docMultiple.separateBy());
                        continue;
                    }
                    if (index >= lastIndex) continue;
                    b.append(this.separator);
                }
            }
        }
        String doc = b.toString().trim();
        this.cache.add(ae, doc);
        return doc;
    }
}

