/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.commons.utils;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.internal.utils.Checks;
import java.util.Arrays;
import java.util.Objects;

public class TableBuilder {
    private String[][] values;
    private String[] headers;
    private String[] rowNames;
    private Borders borders;
    private String tableName = "";
    private Alignment alignment = Alignment.CENTER;
    private int padding = 1;
    private boolean codeblock = false;
    private boolean frame = false;
    private boolean autoAdjust = true;

    public String build() {
        int i;
        int k;
        int j;
        int i2;
        int i3;
        Checks.notNull(this.borders, "Borders");
        Checks.notNull(this.values, "Values");
        Checks.notEmpty((Object[])this.values, "Values");
        Checks.check(Arrays.stream(this.values).allMatch(row -> Arrays.stream(row).allMatch(Objects::nonNull)), "A value may not be null");
        Checks.check(this.padding >= 0, "Padding must not be < 0");
        boolean headersPresent = this.headers != null;
        boolean rowNamesPresent = this.rowNames != null;
        int rows = rowNamesPresent ? this.rowNames.length : this.values.length;
        int columns = headersPresent ? this.headers.length : Arrays.stream(this.values).mapToInt(s -> ((String[])s).length).max().orElse(0);
        Checks.check(this.values.length >= rows, "The amount of rows must not be smaller than specified in the row names");
        int oldColumns = columns;
        Checks.check(Arrays.stream(this.values).noneMatch(row -> ((String[])row).length < oldColumns), "The amount of columns must be consistent");
        if (headersPresent) {
            ++rows;
        }
        if (rowNamesPresent) {
            ++columns;
        }
        String[][] newValues = new String[rows][columns];
        if (headersPresent && rowNamesPresent) {
            newValues[0][0] = this.tableName;
            System.arraycopy(this.headers, 0, newValues[0], 1, this.headers.length);
            for (i3 = 1; i3 < rows; ++i3) {
                newValues[i3][0] = this.rowNames[i3 - 1];
                System.arraycopy(this.values[i3 - 1], 0, newValues[i3], 1, columns - 1);
            }
        } else if (rowNamesPresent) {
            for (i3 = 0; i3 < rows; ++i3) {
                newValues[i3][0] = this.rowNames[i3];
                System.arraycopy(this.values[i3], 0, newValues[i3], 1, columns - 1);
            }
        } else if (headersPresent) {
            System.arraycopy(this.headers, 0, newValues[0], 0, columns);
            System.arraycopy(this.values, 0, newValues, 1, rows - 1);
        } else {
            newValues = this.values;
        }
        this.values = newValues;
        if (this.autoAdjust) {
            int[] maxLengths = new int[columns];
            Arrays.fill(maxLengths, 0);
            for (String[] row2 : this.values) {
                for (i2 = 0; i2 < row2.length; ++i2) {
                    int length = row2[i2].length();
                    if (length <= maxLengths[i2]) continue;
                    maxLengths[i2] = length;
                }
            }
            for (String[] row2 : this.values) {
                for (int j2 = 0; j2 < row2.length; ++j2) {
                    String value = row2[j2];
                    int adjustment = maxLengths[j2] - value.length();
                    StringBuilder newValue = new StringBuilder();
                    this.setAlignment(adjustment, value, newValue);
                    row2[j2] = newValue.toString();
                }
            }
        } else {
            Checks.notNull(this.headers, "Headers");
            boolean check2 = true;
            block6: for (String[] row2 : this.values) {
                for (i2 = 0; i2 < this.headers.length; ++i2) {
                    if (row2[i2].length() <= this.headers[i2].length()) continue;
                    check2 = false;
                    break block6;
                }
            }
            Checks.check(check2, "Length of values must not be longer than length of headers");
        }
        StringBuilder builder = new StringBuilder();
        if (this.codeblock) {
            builder.append("```\n");
        }
        String[] firstRow = this.values[0];
        if (this.frame) {
            builder.append(this.borders.upLeftCorner);
            for (j = 0; j < firstRow.length; ++j) {
                for (k = 0; k < firstRow[j].length(); ++k) {
                    builder.append(this.borders.horizontalOutline);
                }
                if (j == 0) {
                    builder.append(this.borders.firstColumnUpperIntersection);
                    continue;
                }
                if (j >= firstRow.length - 1) continue;
                builder.append(this.borders.upperIntersection);
            }
            builder.append(this.borders.upRightCorner);
            builder.append("\n");
        }
        this.appendRow(builder, firstRow);
        builder.append("\n");
        if (this.frame) {
            builder.append(this.borders.headerLeftIntersection);
        }
        for (i = 0; i < firstRow.length; ++i) {
            for (int j3 = 0; j3 < firstRow[i].length(); ++j3) {
                builder.append(this.borders.headerDelimiter);
            }
            if (i == 0) {
                builder.append(this.borders.headerColumnCrossDelimiter);
                continue;
            }
            if (i >= firstRow.length - 1) continue;
            builder.append(this.borders.headerCrossDelimiter);
        }
        if (this.frame) {
            builder.append(this.borders.headerRightIntersection);
        }
        builder.append("\n");
        for (i = 1; i < rows; ++i) {
            String[] row3 = this.values[i];
            this.appendRow(builder, row3);
            if (i >= this.values.length - 1) continue;
            builder.append("\n");
            if (this.frame) {
                builder.append(this.borders.leftIntersection);
            }
            for (int j4 = 0; j4 < row3.length; ++j4) {
                for (int k2 = 0; k2 < row3[j4].length(); ++k2) {
                    builder.append(this.borders.rowDelimiter);
                }
                if (j4 == 0) {
                    builder.append(this.borders.firstColumnCrossDelimiter);
                    continue;
                }
                if (j4 >= row3.length - 1) continue;
                builder.append(this.borders.crossDelimiter);
            }
            if (this.frame) {
                builder.append(this.borders.rightIntersection);
            }
            builder.append("\n");
        }
        if (this.frame) {
            builder.append("\n");
            builder.append(this.borders.lowLeftCorner);
            for (j = 0; j < firstRow.length; ++j) {
                for (k = 0; k < firstRow[j].length(); ++k) {
                    builder.append(this.borders.horizontalOutline);
                }
                if (j == 0) {
                    builder.append(this.borders.firstColumnLowerIntersection);
                    continue;
                }
                if (j >= firstRow.length - 1) continue;
                builder.append(this.borders.lowerIntersection);
            }
            builder.append(this.borders.lowRightCorner);
        }
        if (this.codeblock) {
            builder.append("```");
        }
        return builder.toString();
    }

    private void appendRow(StringBuilder builder, String[] row) {
        if (this.frame) {
            builder.append(this.borders.verticalOutline);
        }
        for (int i = 0; i < row.length; ++i) {
            builder.append(row[i]);
            if (i == 0) {
                builder.append(this.borders.firstColumnDelimiter);
                continue;
            }
            if (i >= row.length - 1) continue;
            builder.append(this.borders.columnDelimiter);
        }
        if (this.frame) {
            builder.append(this.borders.verticalOutline);
        }
    }

    private void setAlignment(int adjustment, String oldValue, StringBuilder newValueBuilder) {
        int i;
        for (i = 0; i < this.padding; ++i) {
            newValueBuilder.append(" ");
        }
        switch (this.alignment) {
            case RIGHT: {
                int k;
                for (k = 0; k < adjustment; ++k) {
                    newValueBuilder.append(" ");
                }
                newValueBuilder.append(oldValue);
                break;
            }
            case LEFT: {
                int k;
                newValueBuilder.append(oldValue);
                for (k = 0; k < adjustment; ++k) {
                    newValueBuilder.append(" ");
                }
                break;
            }
            case CENTER: {
                int k;
                boolean even = adjustment % 2 == 0;
                int half = adjustment / 2;
                for (k = 0; k < half; ++k) {
                    newValueBuilder.append(" ");
                }
                newValueBuilder.append(oldValue);
                for (k = 0; k < half; ++k) {
                    newValueBuilder.append(" ");
                }
                if (even) break;
                newValueBuilder.append(" ");
            }
        }
        for (i = 0; i < this.padding; ++i) {
            newValueBuilder.append(" ");
        }
    }

    public TableBuilder addHeaders(String ... headers) {
        this.headers = headers;
        return this;
    }

    public TableBuilder addRowNames(String ... rows) {
        this.rowNames = rows;
        return this;
    }

    public TableBuilder setValues(String[][] values2) {
        this.values = values2;
        return this;
    }

    public TableBuilder setBorders(Borders borders) {
        this.borders = borders;
        return this;
    }

    public TableBuilder setName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableBuilder setAlignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public TableBuilder setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public TableBuilder codeblock(boolean codeblock) {
        this.codeblock = codeblock;
        return this;
    }

    public TableBuilder frame(boolean frame) {
        this.frame = frame;
        return this;
    }

    public TableBuilder autoAdjust(boolean autoAdjust) {
        this.autoAdjust = autoAdjust;
        return this;
    }

    public static class Borders {
        public static final Borders HEADER_ROW_FRAME = Borders.newHeaderRowNamesFrameBorders("\u2500", "\u2502", "\u253c", "\u251c", "\u2524", "\u252c", "\u2534", "\u250c", "\u2510", "\u2514", "\u2518", "\u2550", "\u256a", "\u255e", "\u2561", "\u2551", "\u256b", "\u2565", "\u2568", "\u256c", "\u2500", "\u2502");
        public static final Borders HEADER_FRAME = Borders.newHeaderFrameBorders("\u2500", "\u2502", "\u253c", "\u251c", "\u2524", "\u252c", "\u2534", "\u250c", "\u2510", "\u2514", "\u2518", "\u2550", "\u256a", "\u255e", "\u2561", "\u2500", "\u2502");
        public static final Borders FRAME = Borders.newFrameBorders("\u2500", "\u2502", "\u253c", "\u251c", "\u2524", "\u252c", "\u2534", "\u250c", "\u2510", "\u2514", "\u2518", "\u2500", "\u2502");
        public static final Borders HEADER_ROW_PLAIN = Borders.newHeaderRowNamesPlainBorders("\u2500", "\u2502", "\u253c", "\u2550", "\u256a", "\u2551", "\u256b", "\u256c");
        public static final Borders HEADER_PLAIN = Borders.newHeaderPlainBorders("\u2500", "\u2502", "\u253c", "\u2550", "\u256a");
        public static final Borders PLAIN = Borders.newPlainBorders("\u2500", "\u2502", "\u253c");
        public static final String UNKNOWN = "\ufffd";
        public final String rowDelimiter;
        public final String columnDelimiter;
        public final String crossDelimiter;
        public final String leftIntersection;
        public final String rightIntersection;
        public final String upperIntersection;
        public final String lowerIntersection;
        public final String upLeftCorner;
        public final String upRightCorner;
        public final String lowLeftCorner;
        public final String lowRightCorner;
        public final String headerDelimiter;
        public final String headerCrossDelimiter;
        public final String headerLeftIntersection;
        public final String headerRightIntersection;
        public final String firstColumnDelimiter;
        public final String firstColumnCrossDelimiter;
        public final String firstColumnUpperIntersection;
        public final String firstColumnLowerIntersection;
        public final String headerColumnCrossDelimiter;
        public final String horizontalOutline;
        public final String verticalOutline;

        private Borders(String rowDelimiter, String columnDelimiter, String crossDelimiter, String leftIntersection, String rightIntersection, String upperIntersection, String lowerIntersection, String upLeftCorner, String upRightCorner, String lowLeftCorner, String lowRightCorner, String headerDelimiter, String headerCrossDelimiter, String headerLeftIntersection, String headerRightIntersection, String firstColumnDelimiter, String firstColumnCrossDelimiter, String firstColumnUpperIntersection, String firstColumnLowerIntersection, String headerColumnCrossDelimiter, String horizontalOutline, String verticalOutline) {
            this.rowDelimiter = rowDelimiter;
            this.columnDelimiter = columnDelimiter;
            this.crossDelimiter = crossDelimiter;
            this.leftIntersection = leftIntersection;
            this.rightIntersection = rightIntersection;
            this.upperIntersection = upperIntersection;
            this.lowerIntersection = lowerIntersection;
            this.upLeftCorner = upLeftCorner;
            this.upRightCorner = upRightCorner;
            this.lowLeftCorner = lowLeftCorner;
            this.lowRightCorner = lowRightCorner;
            this.headerDelimiter = headerDelimiter;
            this.headerCrossDelimiter = headerCrossDelimiter;
            this.headerLeftIntersection = headerLeftIntersection;
            this.headerRightIntersection = headerRightIntersection;
            this.firstColumnDelimiter = firstColumnDelimiter;
            this.firstColumnCrossDelimiter = firstColumnCrossDelimiter;
            this.firstColumnUpperIntersection = firstColumnUpperIntersection;
            this.firstColumnLowerIntersection = firstColumnLowerIntersection;
            this.headerColumnCrossDelimiter = headerColumnCrossDelimiter;
            this.horizontalOutline = horizontalOutline;
            this.verticalOutline = verticalOutline;
        }

        private Borders(String rowDelimiter, String columnDelimiter, String crossDelimiter, String leftIntersection, String rightIntersection, String upperIntersection, String lowerIntersection, String upLeftCorner, String upRightCorner, String lowLeftCorner, String lowRightCorner, String headerDelimiter, String headerCrossDelimiter, String headerLeftIntersection, String headerRightIntersection, String horizontalOutline, String verticalOutline) {
            this(rowDelimiter, columnDelimiter, crossDelimiter, leftIntersection, rightIntersection, upperIntersection, lowerIntersection, upLeftCorner, upRightCorner, lowLeftCorner, lowRightCorner, headerDelimiter, headerCrossDelimiter, headerLeftIntersection, headerRightIntersection, columnDelimiter, crossDelimiter, upperIntersection, lowerIntersection, headerCrossDelimiter, horizontalOutline, verticalOutline);
        }

        private Borders(String rowDelimiter, String columnDelimiter, String crossDelimiter, String leftIntersection, String rightIntersection, String upperIntersection, String lowerIntersection, String upLeftCorner, String upRightCorner, String lowLeftCorner, String lowRightCorner, String horizontalOutline, String verticalOutline) {
            this(rowDelimiter, columnDelimiter, crossDelimiter, leftIntersection, rightIntersection, upperIntersection, lowerIntersection, upLeftCorner, upRightCorner, lowLeftCorner, lowRightCorner, rowDelimiter, crossDelimiter, leftIntersection, rightIntersection, horizontalOutline, verticalOutline);
        }

        private Borders(String rowDelimiter, String columnDelimiter, String crossDelimiter, String headerDelimiter, String headerCrossDelimiter, String firstColumnDelimiter, String firstColumnCrossDelimiter, String headerColumnCrossDelimiter) {
            this(rowDelimiter, columnDelimiter, crossDelimiter, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, headerDelimiter, headerCrossDelimiter, UNKNOWN, UNKNOWN, firstColumnDelimiter, firstColumnCrossDelimiter, UNKNOWN, UNKNOWN, headerColumnCrossDelimiter, UNKNOWN, UNKNOWN);
        }

        private Borders(String rowDelimiter, String columnDelimiter, String crossDelimiter, String headerDelimiter, String headerCrossDelimiter) {
            this(rowDelimiter, columnDelimiter, crossDelimiter, headerDelimiter, headerCrossDelimiter, columnDelimiter, crossDelimiter, headerCrossDelimiter);
        }

        private Borders(String rowDelimiter, String columnDelimiter, String crossDelimiter) {
            this(rowDelimiter, columnDelimiter, crossDelimiter, rowDelimiter, crossDelimiter);
        }

        public static Borders newHeaderRowNamesFrameBorders(String rowDelimiter, String columnDelimiter, String crossDelimiter, String leftIntersection, String rightIntersection, String upperIntersection, String lowerIntersection, String upLeftCorner, String upRightCorner, String lowLeftCorner, String lowRightCorner, String headerDelimiter, String headerCrossDelimiter, String headerLeftIntersection, String headerRightIntersection, String firstColumnDelimiter, String firstColumnCrossDelimiter, String firstColumnUpperIntersection, String firstColumnLowerIntersection, String headerColumnCrossDelimiter, String horizontalOutline, String verticalOutline) {
            return new Borders(rowDelimiter, columnDelimiter, crossDelimiter, leftIntersection, rightIntersection, upperIntersection, lowerIntersection, upLeftCorner, upRightCorner, lowLeftCorner, lowRightCorner, headerDelimiter, headerCrossDelimiter, headerLeftIntersection, headerRightIntersection, firstColumnDelimiter, firstColumnCrossDelimiter, firstColumnUpperIntersection, firstColumnLowerIntersection, headerColumnCrossDelimiter, horizontalOutline, verticalOutline);
        }

        public static Borders newHeaderFrameBorders(String rowDelimiter, String columnDelimiter, String crossDelimiter, String leftIntersection, String rightIntersection, String upperIntersection, String lowerIntersection, String upLeftCorner, String upRightCorner, String lowLeftCorner, String lowRightCorner, String headerDelimiter, String headerCrossDelimiter, String headerLeftIntersection, String headerRightIntersection, String horizontalOutline, String verticalOutline) {
            return new Borders(rowDelimiter, columnDelimiter, crossDelimiter, leftIntersection, rightIntersection, upperIntersection, lowerIntersection, upLeftCorner, upRightCorner, lowLeftCorner, lowRightCorner, headerDelimiter, headerCrossDelimiter, headerLeftIntersection, headerRightIntersection, horizontalOutline, verticalOutline);
        }

        public static Borders newFrameBorders(String rowDelimiter, String columnDelimiter, String crossDelimiter, String leftIntersection, String rightIntersection, String upperIntersection, String lowerIntersection, String upLeftCorner, String upRightCorner, String lowLeftCorner, String lowRightCorner, String horizontalOutline, String verticalOutline) {
            return new Borders(rowDelimiter, columnDelimiter, crossDelimiter, leftIntersection, rightIntersection, upperIntersection, lowerIntersection, upLeftCorner, upRightCorner, lowLeftCorner, lowRightCorner, horizontalOutline, verticalOutline);
        }

        public static Borders newHeaderRowNamesPlainBorders(String rowDelimiter, String columnDelimiter, String crossDelimiter, String headerDelimiter, String headerCrossDelimiter, String firstColumnDelimiter, String firstColumnCrossDelimiter, String headerColumnCrossDelimiter) {
            return new Borders(rowDelimiter, columnDelimiter, crossDelimiter, headerDelimiter, headerCrossDelimiter, firstColumnDelimiter, firstColumnCrossDelimiter, headerColumnCrossDelimiter);
        }

        public static Borders newHeaderPlainBorders(String rowDelimiter, String columnDelimiter, String crossDelimiter, String headerDelimiter, String headerCrossDelimiter) {
            return new Borders(rowDelimiter, columnDelimiter, crossDelimiter, headerDelimiter, headerCrossDelimiter);
        }

        public static Borders newPlainBorders(String rowDelimiter, String columnDelimiter, String crossDelimiter) {
            return new Borders(rowDelimiter, columnDelimiter, crossDelimiter);
        }
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

