/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.io.jsondb.io;

import com.hypherionmc.sdlink.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.hypherionmc.sdlink.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.hypherionmc.sdlink.shaded.io.jsondb.CollectionMetaData;
import com.hypherionmc.sdlink.shaded.io.jsondb.InvalidJsonDbApiUsageException;
import com.hypherionmc.sdlink.shaded.io.jsondb.JsonDBConfig;
import com.hypherionmc.sdlink.shaded.io.jsondb.SchemaVersion;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWriter {
    private Logger logger = LoggerFactory.getLogger(JsonWriter.class);
    private File dbFilesLocation;
    private String collectionName;
    private File collectionFile;
    private Charset charset;
    private ObjectMapper objectMapper;
    private SchemaVersion schemaVersion;
    private CollectionMetaData cmd;
    private File lockFilesLocation;
    private File fileLockLocation;
    private RandomAccessFile raf;
    private FileChannel channel;

    public JsonWriter(JsonDBConfig dbConfig, CollectionMetaData cmd, String collectionName, File collectionFile) throws IOException {
        this.dbFilesLocation = dbConfig.getDbFilesLocation();
        this.collectionName = collectionName;
        this.collectionFile = collectionFile;
        this.charset = dbConfig.getCharset();
        this.objectMapper = dbConfig.getObjectMapper();
        this.schemaVersion = new SchemaVersion(cmd.getSchemaVersion());
        this.cmd = cmd;
        this.lockFilesLocation = new File(collectionFile.getParentFile(), "lock");
        this.fileLockLocation = new File(this.lockFilesLocation, collectionFile.getName() + ".lock");
        if (!this.lockFilesLocation.exists()) {
            this.lockFilesLocation.mkdirs();
        }
        if (!this.fileLockLocation.exists()) {
            this.fileLockLocation.createNewFile();
        }
        this.raf = new RandomAccessFile(this.fileLockLocation, "rw");
        this.channel = this.raf.getChannel();
    }

    private FileLock acquireLock() throws IOException {
        try {
            FileLock fileLock = this.channel.lock();
            return fileLock;
        }
        catch (IOException e) {
            try {
                this.channel.close();
                this.raf.close();
            }
            catch (IOException e1) {
                this.logger.error("Failed while closing RandomAccessFile for collection file {}", (Object)this.collectionFile.getName());
            }
            throw e;
        }
    }

    private void releaseLock(FileLock lock) {
        try {
            if (lock != null && lock.isValid()) {
                lock.release();
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to release lock for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
        }
        try {
            this.channel.close();
        }
        catch (IOException e) {
            this.logger.error("Failed to close FileChannel for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
        }
        try {
            this.raf.close();
        }
        catch (IOException e) {
            this.logger.error("Failed to close RandomAccessFile for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> boolean appendToJsonFile(Collection<T> collection, Object objectToSave) {
        if (this.cmd.isReadOnly()) {
            throw new InvalidJsonDbApiUsageException("Failed to modify collection, Collection is loaded as readonly");
        }
        lock = null;
        try {
            lock = this.acquireLock();
        }
        catch (IOException e) {
            this.logger.error("Failed to acquire lock for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
            var5_6 = false;
            this.releaseLock(lock);
            return var5_6;
        }
        try {
            tFile = File.createTempFile(this.collectionName, null, this.dbFilesLocation);
        }
        catch (IOException e) {
            this.logger.error("Failed to create temporary file for append", (Throwable)e);
            var6_9 = false;
            this.releaseLock(lock);
            return var6_9;
        }
        tFileName = tFile.getName();
        fos = null;
        osr = null;
        writer = null;
        try {
            fos = new FileOutputStream(tFile);
            osr = new OutputStreamWriter((OutputStream)fos, this.charset);
            writer = new BufferedWriter(osr);
            version = this.objectMapper.writeValueAsString(this.schemaVersion);
            writer.write(version);
            writer.newLine();
            for (T o : collection) {
                documentData = this.objectMapper.writeValueAsString(o);
                writer.write(documentData);
                writer.newLine();
            }
            newDocument = this.objectMapper.writeValueAsString(objectToSave);
            writer.write(newDocument);
            writer.newLine();
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed in coverting Object to Json collection {}", (Object)this.collectionName, (Object)e);
            throw new InvalidJsonDbApiUsageException("Failed Json Processing for collection " + this.collectionName, e);
        }
        catch (IOException e) {
            this.logger.error("Failed to append object to temporary collection file {}", (Object)tFileName, (Object)e);
            var10_22 = false;
            this.releaseLock(lock);
            return var10_22;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close BufferedWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                osr.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close OutputStreamWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close FileOutputStream for temporary collection file {}", (Object)tFileName, (Object)e);
            }
        }
        ** try [egrp 17[TRYBLOCK] [16 : 569->598)] { 
lbl-1000:
        // 1 sources

        {
            Files.move(tFile.toPath(), this.collectionFile.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
        }
lbl71:
        // 1 sources

        catch (IOException e) {
            this.logger.error("Failed to move temporary collection file {} to collection file {}", new Object[]{tFileName, this.collectionFile.getName(), e});
        }
        var9_20 = true;
        return var9_20;
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public <T> boolean appendToJsonFile(Collection<T> collection, Collection<? extends T> batchToSave) {
        if (this.cmd.isReadOnly()) {
            throw new InvalidJsonDbApiUsageException("Failed to modify collection, Collection is loaded as readonly");
        }
        lock = null;
        try {
            lock = this.acquireLock();
        }
        catch (IOException e) {
            this.logger.error("Failed to acquire lock for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
            var5_6 = false;
            this.releaseLock(lock);
            return var5_6;
        }
        try {
            tFile = File.createTempFile(this.collectionName, null, this.dbFilesLocation);
        }
        catch (IOException e) {
            this.logger.error("Failed to create temporary file for append", (Throwable)e);
            var6_9 = false;
            this.releaseLock(lock);
            return var6_9;
        }
        tFileName = tFile.getName();
        fos = null;
        osr = null;
        writer = null;
        try {
            fos = new FileOutputStream(tFile);
            osr = new OutputStreamWriter((OutputStream)fos, this.charset);
            writer = new BufferedWriter(osr);
            version = this.objectMapper.writeValueAsString(this.schemaVersion);
            writer.write(version);
            writer.newLine();
            for (T o : collection) {
                documentData = this.objectMapper.writeValueAsString(o /* !! */ );
                writer.write(documentData);
                writer.newLine();
            }
            for (T o : batchToSave) {
                documentData = this.objectMapper.writeValueAsString(o /* !! */ );
                writer.write(documentData);
                writer.newLine();
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed in coverting Object to Json collection {}", (Object)this.collectionName, (Object)e);
            throw new InvalidJsonDbApiUsageException("Failed Json Processing for collection " + this.collectionName, e);
        }
        catch (IOException e) {
            this.logger.error("Failed to append object to temporary collection file {}", (Object)tFileName, (Object)e);
            var10_22 = false;
            this.releaseLock(lock);
            return var10_22;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close BufferedWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                osr.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close OutputStreamWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close FileOutputStream for temporary collection file {}", (Object)tFileName, (Object)e);
            }
        }
        ** try [egrp 17[TRYBLOCK] [16 : 600->629)] { 
lbl-1000:
        // 1 sources

        {
            Files.move(tFile.toPath(), this.collectionFile.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
        }
lbl73:
        // 1 sources

        catch (IOException e) {
            this.logger.error("Failed to move temporary collection file {} to collection file {}", new Object[]{tFileName, this.collectionFile.getName(), e});
        }
        var9_20 = true;
        return var9_20;
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> boolean removeFromJsonFile(Map<Object, T> collection, Object id) {
        if (this.cmd.isReadOnly()) {
            throw new InvalidJsonDbApiUsageException("Failed to modify collection, Collection is loaded as readonly");
        }
        lock = null;
        try {
            lock = this.acquireLock();
        }
        catch (IOException e) {
            this.logger.error("Failed to acquire lock for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
            var5_6 = false;
            this.releaseLock(lock);
            return var5_6;
        }
        try {
            tFile = File.createTempFile(this.collectionName, null, this.dbFilesLocation);
        }
        catch (IOException e) {
            this.logger.error("Failed to create temporary file for append", (Throwable)e);
            var6_9 = false;
            this.releaseLock(lock);
            return var6_9;
        }
        tFileName = tFile.getName();
        fos = null;
        osr = null;
        writer = null;
        try {
            fos = new FileOutputStream(tFile);
            osr = new OutputStreamWriter((OutputStream)fos, this.charset);
            writer = new BufferedWriter(osr);
            version = this.objectMapper.writeValueAsString(this.schemaVersion);
            writer.write(version);
            writer.newLine();
            for (Map.Entry<Object, T> entry : collection.entrySet()) {
                if (entry.getKey().equals(id)) continue;
                documentData = this.objectMapper.writeValueAsString(entry.getValue());
                writer.write(documentData);
                writer.newLine();
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed in coverting Object to Json collection {}", (Object)this.collectionName, (Object)e);
            throw new InvalidJsonDbApiUsageException("Failed Json Processing for collection " + this.collectionName, e);
        }
        catch (IOException e) {
            this.logger.error("Failed to append object to temporary collection file {}", (Object)tFileName, (Object)e);
            var10_22 = false;
            this.releaseLock(lock);
            return var10_22;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close BufferedWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                osr.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close OutputStreamWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close FileOutputStream for temporary collection file {}", (Object)tFileName, (Object)e);
            }
        }
        ** try [egrp 17[TRYBLOCK] [16 : 574->603)] { 
lbl-1000:
        // 1 sources

        {
            Files.move(tFile.toPath(), this.collectionFile.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
        }
lbl69:
        // 1 sources

        catch (IOException e) {
            this.logger.error("Failed to move temporary collection file {} to collection file {}", new Object[]{tFileName, this.collectionFile.getName(), e});
        }
        var9_20 = true;
        return var9_20;
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> boolean removeFromJsonFile(Map<Object, T> collection, Set<Object> removeIds) {
        if (this.cmd.isReadOnly()) {
            throw new InvalidJsonDbApiUsageException("Failed to modify collection, Collection is loaded as readonly");
        }
        lock = null;
        try {
            lock = this.acquireLock();
        }
        catch (IOException e) {
            this.logger.error("Failed to acquire lock for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
            var5_6 = false;
            this.releaseLock(lock);
            return var5_6;
        }
        try {
            tFile = File.createTempFile(this.collectionName, null, this.dbFilesLocation);
        }
        catch (IOException e) {
            this.logger.error("Failed to create temporary file for append", (Throwable)e);
            var6_9 = false;
            this.releaseLock(lock);
            return var6_9;
        }
        tFileName = tFile.getName();
        fos = null;
        osr = null;
        writer = null;
        try {
            fos = new FileOutputStream(tFile);
            osr = new OutputStreamWriter((OutputStream)fos, this.charset);
            writer = new BufferedWriter(osr);
            version = this.objectMapper.writeValueAsString(this.schemaVersion);
            writer.write(version);
            writer.newLine();
            for (Map.Entry<Object, T> entry : collection.entrySet()) {
                if (removeIds.contains(entry.getKey())) continue;
                documentData = this.objectMapper.writeValueAsString(entry.getValue());
                writer.write(documentData);
                writer.newLine();
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed in coverting Object to Json collection {}", (Object)this.collectionName, (Object)e);
            throw new InvalidJsonDbApiUsageException("Failed Json Processing for collection " + this.collectionName, e);
        }
        catch (IOException e) {
            this.logger.error("Failed to append object to temporary collection file {}", (Object)tFileName, (Object)e);
            var10_22 = false;
            this.releaseLock(lock);
            return var10_22;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close BufferedWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                osr.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close OutputStreamWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close FileOutputStream for temporary collection file {}", (Object)tFileName, (Object)e);
            }
        }
        ** try [egrp 17[TRYBLOCK] [16 : 576->605)] { 
lbl-1000:
        // 1 sources

        {
            Files.move(tFile.toPath(), this.collectionFile.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
        }
lbl69:
        // 1 sources

        catch (IOException e) {
            this.logger.error("Failed to move temporary collection file {} to collection file {}", new Object[]{tFileName, this.collectionFile.getName(), e});
        }
        var9_20 = true;
        return var9_20;
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> boolean updateInJsonFile(Map<Object, T> collection, Object id, T objectToSave) {
        if (this.cmd.isReadOnly()) {
            throw new InvalidJsonDbApiUsageException("Failed to modify collection, Collection is loaded as readonly");
        }
        lock = null;
        try {
            lock = this.acquireLock();
        }
        catch (IOException e) {
            this.logger.error("Failed to acquire lock for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
            var6_7 = false;
            this.releaseLock(lock);
            return var6_7;
        }
        try {
            tFile = File.createTempFile(this.collectionName, null, this.dbFilesLocation);
        }
        catch (IOException e) {
            this.logger.error("Failed to create temporary file for append", (Throwable)e);
            var7_10 = false;
            this.releaseLock(lock);
            return var7_10;
        }
        tFileName = tFile.getName();
        fos = null;
        osr = null;
        writer = null;
        try {
            fos = new FileOutputStream(tFile);
            osr = new OutputStreamWriter((OutputStream)fos, this.charset);
            writer = new BufferedWriter(osr);
            version = this.objectMapper.writeValueAsString(this.schemaVersion);
            writer.write(version);
            writer.newLine();
            for (Map.Entry<Object, T> entry : collection.entrySet()) {
                o = null;
                o = entry.getKey().equals(id) != false ? objectToSave : entry.getValue();
                documentData = this.objectMapper.writeValueAsString(o);
                writer.write(documentData);
                writer.newLine();
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed in coverting Object to Json collection {}", (Object)this.collectionName, (Object)e);
            throw new InvalidJsonDbApiUsageException("Failed Json Processing for collection " + this.collectionName, e);
        }
        catch (IOException e) {
            this.logger.error("Failed to append object to temporary collection file {}", (Object)tFileName, (Object)e);
            var11_23 = false;
            this.releaseLock(lock);
            return var11_23;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close BufferedWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                osr.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close OutputStreamWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close FileOutputStream for temporary collection file {}", (Object)tFileName, (Object)e);
            }
        }
        ** try [egrp 17[TRYBLOCK] [16 : 592->621)] { 
lbl-1000:
        // 1 sources

        {
            Files.move(tFile.toPath(), this.collectionFile.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
        }
lbl70:
        // 1 sources

        catch (IOException e) {
            this.logger.error("Failed to move temporary collection file {} to collection file {}", new Object[]{tFileName, this.collectionFile.getName(), e});
        }
        var10_21 = true;
        return var10_21;
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> boolean updateInJsonFile(Map<Object, T> collection, Map<Object, T> modifiedObjects) {
        if (this.cmd.isReadOnly()) {
            throw new InvalidJsonDbApiUsageException("Failed to modify collection, Collection is loaded as readonly");
        }
        lock = null;
        try {
            lock = this.acquireLock();
        }
        catch (IOException e) {
            this.logger.error("Failed to acquire lock for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
            var5_6 = false;
            this.releaseLock(lock);
            return var5_6;
        }
        try {
            tFile = File.createTempFile(this.collectionName, null, this.dbFilesLocation);
        }
        catch (IOException e) {
            this.logger.error("Failed to create temporary file for append", (Throwable)e);
            var6_9 = false;
            this.releaseLock(lock);
            return var6_9;
        }
        tFileName = tFile.getName();
        fos = null;
        osr = null;
        writer = null;
        try {
            fos = new FileOutputStream(tFile);
            osr = new OutputStreamWriter((OutputStream)fos, this.charset);
            writer = new BufferedWriter(osr);
            version = this.objectMapper.writeValueAsString(this.schemaVersion);
            writer.write(version);
            writer.newLine();
            for (Map.Entry<Object, T> entry : collection.entrySet()) {
                o = null;
                o = modifiedObjects.containsKey(entry.getKey()) != false ? modifiedObjects.get(entry.getKey()) : entry.getValue();
                documentData = this.objectMapper.writeValueAsString(o);
                writer.write(documentData);
                writer.newLine();
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed in coverting Object to Json collection {}", (Object)this.collectionName, (Object)e);
            throw new InvalidJsonDbApiUsageException("Failed Json Processing for collection " + this.collectionName, e);
        }
        catch (IOException e) {
            this.logger.error("Failed to append object to temporary collection file {}", (Object)tFileName, (Object)e);
            var10_22 = false;
            this.releaseLock(lock);
            return var10_22;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close BufferedWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                osr.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close OutputStreamWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close FileOutputStream for temporary collection file {}", (Object)tFileName, (Object)e);
            }
        }
        ** try [egrp 17[TRYBLOCK] [16 : 601->630)] { 
lbl-1000:
        // 1 sources

        {
            Files.move(tFile.toPath(), this.collectionFile.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
        }
lbl70:
        // 1 sources

        catch (IOException e) {
            this.logger.error("Failed to move temporary collection file {} to collection file {}", new Object[]{tFileName, this.collectionFile.getName(), e});
        }
        var9_20 = true;
        return var9_20;
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> boolean reWriteJsonFile(Collection<T> collection, boolean ignoreReadonly) {
        if (!ignoreReadonly && this.cmd.isReadOnly()) {
            throw new InvalidJsonDbApiUsageException("Failed to modify collection, Collection is loaded as readonly");
        }
        lock = null;
        try {
            lock = this.acquireLock();
        }
        catch (IOException e) {
            this.logger.error("Failed to acquire lock for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
            var5_6 = false;
            this.releaseLock(lock);
            return var5_6;
        }
        try {
            tFile = File.createTempFile(this.collectionName, null, this.dbFilesLocation);
        }
        catch (IOException e) {
            this.logger.error("Failed to create temporary file for append", (Throwable)e);
            var6_9 = false;
            this.releaseLock(lock);
            return var6_9;
        }
        tFileName = tFile.getName();
        fos = null;
        osr = null;
        writer = null;
        try {
            fos = new FileOutputStream(tFile);
            osr = new OutputStreamWriter((OutputStream)fos, this.charset);
            writer = new BufferedWriter(osr);
            version = this.objectMapper.writeValueAsString(this.schemaVersion);
            writer.write(version);
            writer.newLine();
            for (T o : collection) {
                documentData = this.objectMapper.writeValueAsString(o);
                writer.write(documentData);
                writer.newLine();
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed in coverting Object to Json collection {}", (Object)this.collectionName, (Object)e);
            throw new InvalidJsonDbApiUsageException("Failed Json Processing for collection " + this.collectionName, e);
        }
        catch (IOException e) {
            this.logger.error("Failed to append object to temporary collection file {}", (Object)tFileName, (Object)e);
            var10_22 = false;
            this.releaseLock(lock);
            return var10_22;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close BufferedWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                osr.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close OutputStreamWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close FileOutputStream for temporary collection file {}", (Object)tFileName, (Object)e);
            }
        }
        ** try [egrp 17[TRYBLOCK] [16 : 551->580)] { 
lbl-1000:
        // 1 sources

        {
            Files.move(tFile.toPath(), this.collectionFile.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
        }
lbl68:
        // 1 sources

        catch (IOException e) {
            this.logger.error("Failed to move temporary collection file {} to collection file {}", new Object[]{tFileName, this.collectionFile.getName(), e});
        }
        var9_20 = true;
        return var9_20;
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> boolean renameKeyInJsonFile(Collection<T> collection, boolean ignoreReadonly, String oldKey, String newKey) {
        if (!ignoreReadonly && this.cmd.isReadOnly()) {
            throw new InvalidJsonDbApiUsageException("Failed to modify collection, Collection is loaded as readonly");
        }
        lock = null;
        try {
            lock = this.acquireLock();
        }
        catch (IOException e) {
            this.logger.error("Failed to acquire lock for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
            var7_8 = false;
            this.releaseLock(lock);
            return var7_8;
        }
        try {
            tFile = File.createTempFile(this.collectionName, null, this.dbFilesLocation);
        }
        catch (IOException e) {
            this.logger.error("Failed to create temporary file for append", (Throwable)e);
            var8_11 = false;
            this.releaseLock(lock);
            return var8_11;
        }
        tFileName = tFile.getName();
        fos = null;
        osr = null;
        writer = null;
        try {
            fos = new FileOutputStream(tFile);
            osr = new OutputStreamWriter((OutputStream)fos, this.charset);
            writer = new BufferedWriter(osr);
            version = this.objectMapper.writeValueAsString(this.schemaVersion);
            writer.write(version);
            writer.newLine();
            oldKeyWithQuotes = "\"" + oldKey + "\":";
            newKeyWithQuotes = "\"" + newKey + "\":";
            for (T o : collection) {
                documentData = this.objectMapper.writeValueAsString(o);
                documentData = documentData.replace(oldKeyWithQuotes, newKeyWithQuotes);
                writer.write(documentData);
                writer.newLine();
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed in coverting Object to Json collection {}", (Object)this.collectionName, (Object)e);
            throw new InvalidJsonDbApiUsageException("Failed Json Processing for collection " + this.collectionName, e);
        }
        catch (IOException e) {
            this.logger.error("Failed to append object to temporary collection file {}", (Object)tFileName, (Object)e);
            var12_24 = false;
            this.releaseLock(lock);
            return var12_24;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close BufferedWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                osr.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close OutputStreamWriter for temporary collection file {}", (Object)tFileName, (Object)e);
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close FileOutputStream for temporary collection file {}", (Object)tFileName, (Object)e);
            }
        }
        ** try [egrp 17[TRYBLOCK] [16 : 584->613)] { 
lbl-1000:
        // 1 sources

        {
            Files.move(tFile.toPath(), this.collectionFile.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
        }
lbl71:
        // 1 sources

        catch (IOException e) {
            this.logger.error("Failed to move temporary collection file {} to collection file {}", new Object[]{tFileName, this.collectionFile.getName(), e});
        }
        var11_22 = true;
        return var11_22;
        finally {
            this.releaseLock(lock);
        }
    }
}

