/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.io.jsondb.io;

import com.hypherionmc.sdlink.shaded.io.jsondb.JsonDBConfig;
import com.hypherionmc.sdlink.shaded.io.jsondb.io.JsonFileLockException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReader {
    private Logger logger = LoggerFactory.getLogger(JsonReader.class);
    private File collectionFile;
    private RandomAccessFile raf;
    private FileInputStream fis;
    private FileChannel channel;
    private InputStreamReader isr;
    private BufferedReader reader;
    private FileLock lock;
    private File lockFilesLocation;
    private File fileLockLocation;

    public JsonReader(JsonDBConfig dbConfig, File collectionFile) throws IOException {
        this.collectionFile = collectionFile;
        this.lockFilesLocation = new File(collectionFile.getParentFile(), "lock");
        this.fileLockLocation = new File(this.lockFilesLocation, collectionFile.getName() + ".lock");
        if (!this.lockFilesLocation.exists()) {
            this.lockFilesLocation.mkdirs();
        }
        if (!this.fileLockLocation.exists()) {
            this.fileLockLocation.createNewFile();
        }
        CharsetDecoder decoder = dbConfig.getCharset().newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.raf = new RandomAccessFile(this.fileLockLocation, "rw");
        this.channel = this.raf.getChannel();
        try {
            this.lock = this.channel.lock();
        }
        catch (IOException | OverlappingFileLockException e) {
            try {
                this.channel.close();
                this.raf.close();
            }
            catch (IOException e1) {
                this.logger.error("Failed while closing RandomAccessFile for collection file {}", (Object)collectionFile.getName());
            }
            throw new JsonFileLockException("JsonReader failed to obtain a file lock for file " + this.fileLockLocation, e);
        }
        this.fis = new FileInputStream(collectionFile);
        this.isr = new InputStreamReader((InputStream)this.fis, decoder);
        this.reader = new BufferedReader(this.isr);
    }

    public String readLine() throws IOException {
        return this.reader.readLine();
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            this.logger.error("Failed to close BufferedReader for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
        }
        try {
            this.isr.close();
        }
        catch (IOException e) {
            this.logger.error("Failed to close InputStreamReader for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
        }
        try {
            if (this.lock.isValid()) {
                this.lock.release();
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to release lock for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
        }
        try {
            this.channel.close();
        }
        catch (IOException e) {
            this.logger.error("Failed to close FileChannel for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
        }
        try {
            this.fis.close();
        }
        catch (IOException e) {
            this.logger.error("Failed to close FileInputStream for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
        }
        try {
            this.raf.close();
        }
        catch (IOException e) {
            this.logger.error("Failed to close RandomAccessFile for collection file {}", (Object)this.collectionFile.getName(), (Object)e);
        }
    }
}

