/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.io.jsondb.events;

import com.hypherionmc.sdlink.shaded.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hypherionmc.sdlink.shaded.io.jsondb.CollectionMetaData;
import com.hypherionmc.sdlink.shaded.io.jsondb.JsonDBConfig;
import com.hypherionmc.sdlink.shaded.io.jsondb.JsonDBException;
import com.hypherionmc.sdlink.shaded.io.jsondb.events.CollectionFileChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerList {
    private Logger logger = LoggerFactory.getLogger(EventListenerList.class);
    private JsonDBConfig dbConfig = null;
    private Map<String, CollectionMetaData> cmdMap;
    private List<CollectionFileChangeListener> listeners;
    private ExecutorService collectionFilesWatcherExecutor;
    private WatchService watcher = null;
    private boolean stopWatcher;

    public EventListenerList(JsonDBConfig dbConfig, Map<String, CollectionMetaData> cmdMap) {
        this.dbConfig = dbConfig;
        this.cmdMap = cmdMap;
    }

    public void addCollectionFileChangeListener(CollectionFileChangeListener listener) {
        if (null == this.listeners) {
            this.listeners = new ArrayList<CollectionFileChangeListener>();
            this.listeners.add(listener);
            this.collectionFilesWatcherExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("jsondb-files-watcher-thread-%d").build());
            try {
                this.watcher = this.dbConfig.getDbFilesPath().getFileSystem().newWatchService();
                this.dbConfig.getDbFilesPath().register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (IOException e) {
                this.logger.error("Failed to create the WatchService for the dbFiles location", (Throwable)e);
                throw new JsonDBException("Failed to create the WatchService for the dbFiles location", e);
            }
            this.collectionFilesWatcherExecutor.execute(new CollectionFilesWatcherRunnable());
        } else {
            this.listeners.add(listener);
        }
    }

    public void removeCollectionFileChangeListener(CollectionFileChangeListener listener) {
        if (null != this.listeners) {
            this.listeners.remove(listener);
        }
        if (this.listeners.size() < 1) {
            this.stopWatcher = true;
            this.collectionFilesWatcherExecutor.shutdownNow();
            try {
                this.watcher.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close the WatchService for the dbFiles location", (Throwable)e);
            }
        }
    }

    public boolean hasCollectionFileChangeListener() {
        return null != this.listeners && this.listeners.size() > 0;
    }

    public void shutdown() {
        if (null != this.listeners && this.listeners.size() > 0) {
            this.stopWatcher = true;
            this.collectionFilesWatcherExecutor.shutdownNow();
            try {
                this.watcher.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close the WatchService for the dbFiles location", (Throwable)e);
            }
            this.listeners.clear();
        }
    }

    private class CollectionFilesWatcherRunnable
    implements Runnable {
        private CollectionFilesWatcherRunnable() {
        }

        @Override
        public void run() {
            while (!EventListenerList.this.stopWatcher) {
                WatchKey watckKey = null;
                try {
                    watckKey = EventListenerList.this.watcher.take();
                }
                catch (InterruptedException e) {
                    EventListenerList.this.logger.debug("The watcher service thread was interrupted", (Throwable)e);
                    return;
                }
                List<WatchEvent<?>> events = watckKey.pollEvents();
                for (WatchEvent<?> event : events) {
                    WatchEvent<?> ev;
                    File file;
                    String fileName;
                    int extnLocation;
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW || (extnLocation = (fileName = (file = ((Path)(ev = event).context()).toFile()).getName()).lastIndexOf(46)) == -1) continue;
                    String collectionName = fileName.substring(0, extnLocation);
                    if (!fileName.endsWith(".json") || !EventListenerList.this.cmdMap.containsKey(collectionName)) continue;
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        for (CollectionFileChangeListener listener : EventListenerList.this.listeners) {
                            listener.collectionFileAdded(collectionName);
                        }
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        for (CollectionFileChangeListener listener : EventListenerList.this.listeners) {
                            listener.collectionFileDeleted(collectionName);
                        }
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                    for (CollectionFileChangeListener listener : EventListenerList.this.listeners) {
                        listener.collectionFileModified(collectionName);
                    }
                }
            }
        }
    }
}

