/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.io.jsondb;

import com.hypherionmc.sdlink.shaded.fasterxml.jackson.core.JsonParseException;
import com.hypherionmc.sdlink.shaded.fasterxml.jackson.databind.JsonMappingException;
import com.hypherionmc.sdlink.shaded.io.jsondb.CollectionMetaData;
import com.hypherionmc.sdlink.shaded.io.jsondb.InvalidJsonDbApiUsageException;
import com.hypherionmc.sdlink.shaded.io.jsondb.JsonDBConfig;
import com.hypherionmc.sdlink.shaded.io.jsondb.JsonDBException;
import com.hypherionmc.sdlink.shaded.io.jsondb.JsonDBOperations;
import com.hypherionmc.sdlink.shaded.io.jsondb.SchemaVersion;
import com.hypherionmc.sdlink.shaded.io.jsondb.Util;
import com.hypherionmc.sdlink.shaded.io.jsondb.crypto.CryptoUtil;
import com.hypherionmc.sdlink.shaded.io.jsondb.crypto.ICipher;
import com.hypherionmc.sdlink.shaded.io.jsondb.events.CollectionFileChangeListener;
import com.hypherionmc.sdlink.shaded.io.jsondb.events.EventListenerList;
import com.hypherionmc.sdlink.shaded.io.jsondb.io.JsonFileLockException;
import com.hypherionmc.sdlink.shaded.io.jsondb.io.JsonReader;
import com.hypherionmc.sdlink.shaded.io.jsondb.io.JsonWriter;
import com.hypherionmc.sdlink.shaded.io.jsondb.query.Update;
import com.hypherionmc.sdlink.shaded.io.jsondb.query.ddl.AbstractOperation;
import com.hypherionmc.sdlink.shaded.io.jsondb.query.ddl.AddOperation;
import com.hypherionmc.sdlink.shaded.io.jsondb.query.ddl.CollectionSchemaUpdate;
import com.hypherionmc.sdlink.shaded.io.jsondb.query.ddl.DeleteOperation;
import com.hypherionmc.sdlink.shaded.io.jsondb.query.ddl.RenameOperation;
import com.hypherionmc.sdlink.shaded.org.apache.commons.beanutils.BeanUtils;
import com.hypherionmc.sdlink.shaded.org.apache.commons.jxpath.JXPathContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.CharacterCodingException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDBTemplate
implements JsonDBOperations {
    private Logger logger = LoggerFactory.getLogger(JsonDBTemplate.class);
    private JsonDBConfig dbConfig = null;
    private final boolean encrypted;
    private File lockFilesLocation;
    private EventListenerList eventListenerList;
    private Map<String, CollectionMetaData> cmdMap;
    private AtomicReference<Map<String, File>> fileObjectsRef = new AtomicReference(new ConcurrentHashMap());
    private AtomicReference<Map<String, Map<Object, ?>>> collectionsRef = new AtomicReference(new ConcurrentHashMap());
    private AtomicReference<Map<String, JXPathContext>> contextsRef = new AtomicReference(new ConcurrentHashMap());

    public JsonDBTemplate(String dbFilesLocationString, String baseScanPackage) {
        this(dbFilesLocationString, baseScanPackage, null, false, null);
    }

    public JsonDBTemplate(String dbFilesLocationString, String baseScanPackage, boolean compatibilityMode, Comparator<String> schemaComparator) {
        this(dbFilesLocationString, baseScanPackage, null, compatibilityMode, schemaComparator);
    }

    public JsonDBTemplate(String dbFilesLocationString, String baseScanPackage, ICipher cipher) {
        this(dbFilesLocationString, baseScanPackage, cipher, false, null);
    }

    public JsonDBTemplate(String dbFilesLocationString, String baseScanPackage, ICipher cipher, boolean compatibilityMode, Comparator<String> schemaComparator) {
        this.dbConfig = new JsonDBConfig(dbFilesLocationString, baseScanPackage, cipher, compatibilityMode, schemaComparator);
        if (null == cipher) {
            this.logger.info("Encryption is not enabled for JSON DB");
            this.encrypted = false;
        } else {
            this.logger.info("Encryption is enabled for JSON DB");
            this.encrypted = true;
        }
    }

    public void setupDB(Set<Class<?>> tables) {
        this.initialize(tables);
        this.eventListenerList = new EventListenerList(this.dbConfig, this.cmdMap);
    }

    private void initialize(Set<Class<?>> tables) {
        this.lockFilesLocation = new File(this.dbConfig.getDbFilesLocation(), "lock");
        if (!this.lockFilesLocation.exists()) {
            this.lockFilesLocation.mkdirs();
        }
        if (!this.dbConfig.getDbFilesLocation().exists()) {
            try {
                Files.createDirectory(this.dbConfig.getDbFilesPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.error("DbFiles directory does not exist. Failed to create a new empty DBFiles directory {}", (Throwable)e);
                throw new InvalidJsonDbApiUsageException("DbFiles directory does not exist. Failed to create a new empty DBFiles directory " + this.dbConfig.getDbFilesLocationString());
            }
        } else if (this.dbConfig.getDbFilesLocation().isFile()) {
            throw new InvalidJsonDbApiUsageException("Specified DbFiles directory is actually a file cannot use it as a directory");
        }
        this.cmdMap = CollectionMetaData.builder(this.dbConfig, tables);
        this.loadDB();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JsonDBTemplate.this.eventListenerList.shutdown();
            }
        });
    }

    @Override
    public void reLoadDB() {
        this.loadDB();
    }

    private synchronized void loadDB() {
        for (String collectionName : this.cmdMap.keySet()) {
            File collectionFile = new File(this.dbConfig.getDbFilesLocation(), collectionName + ".json");
            if (collectionFile.exists()) {
                this.reloadCollection(collectionName);
                continue;
            }
            if (!this.collectionsRef.get().containsKey(collectionName)) continue;
            this.contextsRef.get().remove(collectionName);
            this.collectionsRef.get().remove(collectionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadCollection(String collectionName) {
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        cmd.getCollectionLock().writeLock().lock();
        try {
            Map collection;
            File collectionFile = this.fileObjectsRef.get().get(collectionName);
            if (null == collectionFile) {
                collectionFile = new File(this.dbConfig.getDbFilesLocation(), collectionName + ".json");
                if (!collectionFile.exists()) {
                    throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' cannot be found at " + collectionFile.getAbsolutePath());
                }
                Map<String, File> fileObjectMap = this.fileObjectsRef.get();
                ConcurrentHashMap<String, File> newFileObjectmap = new ConcurrentHashMap<String, File>(fileObjectMap);
                newFileObjectmap.put(collectionName, collectionFile);
                this.fileObjectsRef.set(newFileObjectmap);
            }
            if (null != (collection = this.loadCollection(collectionFile, collectionName, cmd))) {
                JXPathContext newContext = JXPathContext.newContext(collection.values());
                this.contextsRef.get().put(collectionName, newContext);
                this.collectionsRef.get().put(collectionName, collection);
            } else {
                this.contextsRef.get().remove(collectionName);
                this.collectionsRef.get().remove(collectionName);
            }
        }
        finally {
            cmd.getCollectionLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Map<Object, T> loadCollection(File collectionFile, String collectionName, CollectionMetaData cmd) {
        Class entity = cmd.getClazz();
        Method getterMethodForId = cmd.getIdAnnotatedFieldGetterMethod();
        JsonReader jr = null;
        LinkedHashMap collection = new LinkedHashMap();
        String line = null;
        int lineNo = 1;
        try {
            jr = new JsonReader(this.dbConfig, collectionFile);
            while ((line = jr.readLine()) != null) {
                if (lineNo == 1) {
                    SchemaVersion v = this.dbConfig.getObjectMapper().readValue(line, SchemaVersion.class);
                    cmd.setActualSchemaVersion(v.getSchemaVersion());
                } else {
                    Object row = this.dbConfig.getObjectMapper().readValue(line, entity);
                    Object id = Util.getIdForEntity(row, getterMethodForId);
                    collection.put(id, row);
                }
                ++lineNo;
            }
        }
        catch (JsonParseException je) {
            this.logger.error("Failed Json Parsing for file {} line {}", new Object[]{collectionFile.getName(), lineNo, je});
            Map<Object, T> map = null;
            return map;
        }
        catch (JsonMappingException jm) {
            this.logger.error("Failed Mapping Parsed Json to Entity {} for file {} line {}", new Object[]{entity.getSimpleName(), collectionFile.getName(), lineNo, jm});
            Map<Object, T> map = null;
            return map;
        }
        catch (CharacterCodingException ce) {
            this.logger.error("Unsupported Character Encoding in file {} expected Encoding {}", new Object[]{collectionFile.getName(), this.dbConfig.getCharset().displayName(), ce});
            Map<Object, T> map = null;
            return map;
        }
        catch (JsonFileLockException jfe) {
            this.logger.error("Failed to acquire lock for collection file {}", (Object)collectionFile.getName(), (Object)jfe);
            Map<Object, T> map = null;
            return map;
        }
        catch (FileNotFoundException fe) {
            this.logger.error("Collection file {} not found", (Object)collectionFile.getName(), (Object)fe);
            Map<Object, T> map = null;
            return map;
        }
        catch (IOException e) {
            this.logger.error("Some IO Exception reading the Json File {}", (Object)collectionFile.getName(), (Object)e);
            Map<Object, T> map = null;
            return map;
        }
        catch (Throwable t) {
            this.logger.error("Throwable Caught {}, {} ", (Object)collectionFile.getName(), (Object)t);
            Map<Object, T> map = null;
            return map;
        }
        finally {
            if (null != jr) {
                jr.close();
            }
        }
        return collection;
    }

    @Override
    public void addCollectionFileChangeListener(CollectionFileChangeListener listener) {
        this.eventListenerList.addCollectionFileChangeListener(listener);
    }

    @Override
    public void removeCollectionFileChangeListener(CollectionFileChangeListener listener) {
        this.eventListenerList.removeCollectionFileChangeListener(listener);
    }

    @Override
    public boolean hasCollectionFileChangeListener() {
        return this.eventListenerList.hasCollectionFileChangeListener();
    }

    @Override
    public <T> void createCollection(Class<T> entityClass) {
        this.createCollection(Util.determineCollectionName(entityClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void createCollection(String collectionName) {
        block9: {
            CollectionMetaData cmd = this.cmdMap.get(collectionName);
            if (null == cmd) {
                throw new InvalidJsonDbApiUsageException("No class found with @Document Annotation and attribute collectionName as: " + collectionName);
            }
            Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
            if (null != collection) {
                throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' already exists.");
            }
            cmd.getCollectionLock().writeLock().lock();
            if (this.collectionsRef.get().get(collectionName) != null) {
                return;
            }
            try {
                String collectionFileName = collectionName + ".json";
                File fileObject = new File(this.dbConfig.getDbFilesLocation(), collectionFileName);
                try {
                    fileObject.createNewFile();
                }
                catch (IOException e) {
                    this.logger.error("IO Exception creating the collection file {}", (Object)collectionFileName, (Object)e);
                    throw new InvalidJsonDbApiUsageException("Unable to create a collection file for collection: " + collectionName);
                }
                if (Util.stampVersion(this.dbConfig, fileObject, cmd.getSchemaVersion())) {
                    collection = new LinkedHashMap();
                    this.collectionsRef.get().put(collectionName, collection);
                    this.contextsRef.get().put(collectionName, JXPathContext.newContext(collection.values()));
                    this.fileObjectsRef.get().put(collectionName, fileObject);
                    cmd.setActualSchemaVersion(cmd.getSchemaVersion());
                    break block9;
                }
                fileObject.delete();
                throw new JsonDBException("Failed to stamp version for collection: " + collectionName);
            }
            finally {
                cmd.getCollectionLock().writeLock().unlock();
            }
        }
    }

    @Override
    public <T> void dropCollection(Class<T> entityClass) {
        this.dropCollection(Util.determineCollectionName(entityClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropCollection(String collectionName) {
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        if (null == cmd || !this.collectionsRef.get().containsKey(collectionName)) {
            throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
        }
        cmd.getCollectionLock().writeLock().lock();
        try {
            File toDelete = this.fileObjectsRef.get().get(collectionName);
            try {
                Files.deleteIfExists(toDelete.toPath());
            }
            catch (IOException e) {
                this.logger.error("IO Exception deleting the collection file {}", (Object)toDelete.getName(), (Object)e);
                throw new InvalidJsonDbApiUsageException("Unable to create a collection file for collection: " + collectionName);
            }
            this.fileObjectsRef.get().remove(collectionName);
            this.collectionsRef.get().remove(collectionName);
            this.contextsRef.get().remove(collectionName);
        }
        finally {
            cmd.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> void updateCollectionSchema(CollectionSchemaUpdate update, Class<T> entityClass) {
        this.updateCollectionSchema(update, Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> void updateCollectionSchema(CollectionSchemaUpdate update, String collectionName) {
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
        if (null == cmd || null == collection) {
            throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
        }
        boolean reloadCollectionAsSomethingChanged = false;
        if (null != update) {
            Map<String, AddOperation> addOps;
            AbstractOperation op;
            Map<String, RenameOperation> renOps = update.getRenameOperations();
            if (renOps.size() > 0) {
                reloadCollectionAsSomethingChanged = true;
                cmd.getCollectionLock().writeLock().lock();
                for (Map.Entry<String, RenameOperation> entry : renOps.entrySet()) {
                    JsonWriter jw;
                    String string = entry.getKey();
                    op = entry.getValue();
                    String newKey = ((RenameOperation)op).getNewName();
                    try {
                        jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
                    }
                    catch (IOException ioe) {
                        this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                        throw new JsonDBException("Failed to save " + collectionName, ioe);
                    }
                    jw.renameKeyInJsonFile(collection.values(), true, string, newKey);
                }
                cmd.getCollectionLock().writeLock().unlock();
            }
            if ((addOps = update.getAddOperations()).size() > 0) {
                JsonWriter jsonWriter;
                reloadCollectionAsSomethingChanged = true;
                cmd.getCollectionLock().writeLock().lock();
                for (Map.Entry<String, AddOperation> entry : addOps.entrySet()) {
                    op = entry.getValue();
                    Object value = null;
                    value = ((AddOperation)op).isSecret() ? this.dbConfig.getCipher().encrypt((String)((AddOperation)op).getDefaultValue()) : ((AddOperation)op).getDefaultValue();
                    String fieldName = entry.getKey();
                    Method setterMethod = cmd.getSetterMethodForFieldName(fieldName);
                    for (Object object : collection.values()) {
                        Util.setFieldValueForEntity(object, value, setterMethod);
                    }
                }
                try {
                    jsonWriter = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
                }
                catch (IOException iOException) {
                    this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)iOException);
                    throw new JsonDBException("Failed to save " + collectionName, iOException);
                }
                jsonWriter.reWriteJsonFile(collection.values(), true);
                cmd.getCollectionLock().writeLock().unlock();
            }
            Map<String, DeleteOperation> map = update.getDeleteOperations();
            if (renOps.size() < 1 && addOps.size() < 1 && map.size() > 0) {
                JsonWriter jsonWriter;
                reloadCollectionAsSomethingChanged = true;
                cmd.getCollectionLock().writeLock().lock();
                try {
                    jsonWriter = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
                }
                catch (IOException ioe) {
                    this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                    throw new JsonDBException("Failed to save " + collectionName, ioe);
                }
                jsonWriter.reWriteJsonFile(collection.values(), true);
                cmd.getCollectionLock().writeLock().unlock();
            }
            if (reloadCollectionAsSomethingChanged) {
                this.reloadCollection(collectionName);
            }
        }
    }

    @Override
    public Set<String> getCollectionNames() {
        return this.collectionsRef.get().keySet();
    }

    @Override
    public String getCollectionName(Class<?> entityClass) {
        return Util.determineCollectionName(entityClass);
    }

    @Override
    public <T> List<T> getCollection(Class<T> entityClass) {
        String collectionName = Util.determineCollectionName(entityClass);
        Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
        if (null == collection) {
            this.createCollection(collectionName);
            collection = this.collectionsRef.get().get(collectionName);
        }
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        ArrayList<Object> newCollection = new ArrayList<Object>();
        try {
            for (Object document : collection.values()) {
                Object obj = Util.deepCopy(document);
                if (this.encrypted && cmd.hasSecret() && null != obj) {
                    CryptoUtil.decryptFields(obj, cmd, this.dbConfig.getCipher());
                }
                newCollection.add(obj);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        return newCollection;
    }

    @Override
    public <T> boolean collectionExists(Class<T> entityClass) {
        return this.collectionExists(Util.determineCollectionName(entityClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean collectionExists(String collectionName) {
        CollectionMetaData collectionMeta = this.cmdMap.get(collectionName);
        if (null == collectionMeta) {
            return false;
        }
        collectionMeta.getCollectionLock().readLock().lock();
        try {
            boolean bl = this.collectionsRef.get().containsKey(collectionName);
            return bl;
        }
        finally {
            collectionMeta.getCollectionLock().readLock().unlock();
        }
    }

    @Override
    public <T> boolean isCollectionReadonly(Class<T> entityClass) {
        return this.isCollectionReadonly(Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> boolean isCollectionReadonly(String collectionName) {
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        return cmd.isReadOnly();
    }

    @Override
    public <T> List<T> find(String jxQuery, Class<T> entityClass) {
        return this.find(jxQuery, Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> find(String jxQuery, String collectionName) {
        return this.find(jxQuery, collectionName, null);
    }

    @Override
    public <T> List<T> find(String jxQuery, Class<T> entityClass, Comparator<? super T> comparator) {
        return this.find(jxQuery, Util.determineCollectionName(entityClass), comparator);
    }

    @Override
    public <T> List<T> find(String jxQuery, String collectionName, Comparator<? super T> comparator) {
        return this.find(jxQuery, collectionName, comparator, null);
    }

    @Override
    public <T> List<T> find(String jxQuery, Class<T> entityClass, Comparator<? super T> comparator, String slice) {
        return this.find(jxQuery, Util.determineCollectionName(entityClass), comparator, slice);
    }

    @Override
    public <T> List<T> find(String jxQuery, String collectionName, Comparator<? super T> comparator, String slice) {
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
        if (null == cmd || null == collection) {
            throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
        }
        cmd.getCollectionLock().readLock().lock();
        boolean isSliceable = Util.isSliceable(slice);
        try {
            List<Integer> indexes;
            JXPathContext context = this.contextsRef.get().get(collectionName);
            Iterator resultItr = context.iterate(jxQuery);
            ArrayList<Object> newCollection = new ArrayList<Object>();
            while (resultItr.hasNext()) {
                Object document = resultItr.next();
                if (isSliceable) {
                    newCollection.add(document);
                    continue;
                }
                Object obj = Util.deepCopy(document);
                if (this.encrypted && cmd.hasSecret() && null != obj) {
                    CryptoUtil.decryptFields(obj, cmd, this.dbConfig.getCipher());
                }
                newCollection.add(obj);
            }
            if (comparator != null) {
                newCollection.sort(comparator);
            }
            if (isSliceable && (indexes = Util.getSliceIndexes(slice, newCollection.size())) != null) {
                ArrayList<Object> slicedCollection = new ArrayList<Object>(indexes.size());
                Object object = indexes.iterator();
                while (object.hasNext()) {
                    int index = object.next();
                    Object obj = Util.deepCopy(newCollection.get(index));
                    if (this.encrypted && cmd.hasSecret() && null != obj) {
                        CryptoUtil.decryptFields(obj, cmd, this.dbConfig.getCipher());
                    }
                    slicedCollection.add(obj);
                }
                object = slicedCollection;
                return object;
            }
            ArrayList<Object> arrayList = newCollection;
            return arrayList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            cmd.getCollectionLock().readLock().unlock();
        }
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        return this.findAll(Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAll(String collectionName) {
        return this.findAll(collectionName, null);
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass, Comparator<? super T> comparator) {
        return this.findAll(Util.determineCollectionName(entityClass), comparator);
    }

    @Override
    public <T> List<T> findAll(String collectionName, Comparator<? super T> comparator) {
        return this.findAll(collectionName, comparator, null);
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass, Comparator<? super T> comparator, String slice) {
        return this.findAll(Util.determineCollectionName(entityClass), comparator, slice);
    }

    @Override
    public <T> List<T> findAll(String collectionName, Comparator<? super T> comparator, String slice) {
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
        if (null == cmd || null == collection) {
            throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
        }
        cmd.getCollectionLock().readLock().lock();
        boolean isSliceable = Util.isSliceable(slice);
        try {
            List<Integer> indexes;
            ArrayList<Object> newCollection = new ArrayList<Object>();
            for (Object document : collection.values()) {
                if (isSliceable) {
                    newCollection.add(document);
                    continue;
                }
                Object obj = Util.deepCopy(document);
                if (this.encrypted && cmd.hasSecret() && null != obj) {
                    CryptoUtil.decryptFields(obj, cmd, this.dbConfig.getCipher());
                }
                newCollection.add(obj);
            }
            if (comparator != null) {
                newCollection.sort(comparator);
            }
            if (isSliceable && (indexes = Util.getSliceIndexes(slice, newCollection.size())) != null) {
                ArrayList<Object> slicedCollection = new ArrayList<Object>(indexes.size());
                Object object = indexes.iterator();
                while (object.hasNext()) {
                    int index = object.next();
                    Object obj = Util.deepCopy(newCollection.get(index));
                    if (this.encrypted && cmd.hasSecret() && null != obj) {
                        CryptoUtil.decryptFields(obj, cmd, this.dbConfig.getCipher());
                    }
                    slicedCollection.add(obj);
                }
                object = slicedCollection;
                return object;
            }
            ArrayList<Object> arrayList = newCollection;
            return arrayList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            cmd.getCollectionLock().readLock().unlock();
        }
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        return this.findById(id, Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findById(Object id, String collectionName) {
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
        if (null == cmd || null == collection) {
            throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
        }
        cmd.getCollectionLock().readLock().lock();
        try {
            Object obj = Util.deepCopy(collection.get(id));
            if (this.encrypted && cmd.hasSecret() && null != obj) {
                CryptoUtil.decryptFields(obj, cmd, this.dbConfig.getCipher());
            }
            Object object = obj;
            return (T)object;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            cmd.getCollectionLock().readLock().unlock();
        }
    }

    @Override
    public <T> T findOne(String jxQuery, Class<T> entityClass) {
        return this.findOne(jxQuery, Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findOne(String jxQuery, String collectionName) {
        CollectionMetaData collectionMeta = this.cmdMap.get(collectionName);
        if (null == collectionMeta || !this.collectionsRef.get().containsKey(collectionName)) {
            throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first");
        }
        collectionMeta.getCollectionLock().readLock().lock();
        try {
            JXPathContext context = this.contextsRef.get().get(collectionName);
            Iterator resultItr = context.iterate(jxQuery);
            if (resultItr.hasNext()) {
                Object document = resultItr.next();
                Object obj = Util.deepCopy(document);
                if (this.encrypted && collectionMeta.hasSecret() && null != obj) {
                    CryptoUtil.decryptFields(obj, collectionMeta, this.dbConfig.getCipher());
                }
                Object object = obj;
                return (T)object;
            }
            T t = null;
            return t;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            collectionMeta.getCollectionLock().readLock().unlock();
        }
    }

    @Override
    public <T> void insert(Object objectToSave) {
        if (null == objectToSave) {
            throw new InvalidJsonDbApiUsageException("Null Object cannot be inserted into DB");
        }
        Util.ensureNotRestricted(objectToSave);
        this.insert(objectToSave, Util.determineEntityCollectionName(objectToSave));
    }

    @Override
    public <T> void insert(Object objectToSave, String collectionName) {
        if (null == objectToSave) {
            throw new InvalidJsonDbApiUsageException("Null Object cannot be inserted into DB");
        }
        Util.ensureNotRestricted(objectToSave);
        Object objToSave = Util.deepCopy(objectToSave);
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        cmd.getCollectionLock().writeLock().lock();
        try {
            JsonWriter jw;
            Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
            if (null == collection) {
                throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first");
            }
            Object id = Util.getIdForEntity(objectToSave, cmd.getIdAnnotatedFieldGetterMethod());
            if (this.encrypted && cmd.hasSecret()) {
                CryptoUtil.encryptFields(objToSave, cmd, this.dbConfig.getCipher());
            }
            if (null == id) {
                id = Util.setIdForEntity(objToSave, cmd.getIdAnnotatedFieldSetterMethod());
            } else if (collection.containsKey(id)) {
                throw new InvalidJsonDbApiUsageException("Object already present in Collection. Use Update or Upsert operation instead of Insert");
            }
            try {
                jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
            }
            catch (IOException ioe) {
                this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                throw new JsonDBException("Failed to save " + collectionName, ioe);
            }
            boolean appendResult = jw.appendToJsonFile(collection.values(), objToSave);
            if (appendResult) {
                collection.put(Util.deepCopy(id), objToSave);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            cmd.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> void insert(Collection<? extends T> batchToSave, Class<T> entityClass) {
        this.insert(batchToSave, Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> void insert(Collection<? extends T> batchToSave, String collectionName) {
        if (null == batchToSave) {
            throw new InvalidJsonDbApiUsageException("Null Object batch cannot be inserted into DB");
        }
        CollectionMetaData collectionMeta = this.cmdMap.get(collectionName);
        collectionMeta.getCollectionLock().writeLock().lock();
        try {
            JsonWriter jw;
            Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
            if (null == collection) {
                throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first");
            }
            CollectionMetaData cmd = this.cmdMap.get(collectionName);
            HashSet<Object> uniqueIds = new HashSet<Object>();
            LinkedHashMap<Object, Object> newCollection = new LinkedHashMap<Object, Object>();
            for (T o : batchToSave) {
                Object obj = Util.deepCopy(o);
                Object id = Util.getIdForEntity(obj, cmd.getIdAnnotatedFieldGetterMethod());
                if (this.encrypted && cmd.hasSecret()) {
                    CryptoUtil.encryptFields(obj, cmd, this.dbConfig.getCipher());
                }
                if (null == id) {
                    id = Util.setIdForEntity(obj, cmd.getIdAnnotatedFieldSetterMethod());
                } else if (collection.containsKey(id)) {
                    throw new InvalidJsonDbApiUsageException("Object already present in Collection. Use Update or Upsert operation instead of Insert");
                }
                if (!uniqueIds.add(id)) {
                    throw new InvalidJsonDbApiUsageException("Duplicate object with id: " + id + " within the passed in parameter");
                }
                newCollection.put(Util.deepCopy(id), obj);
            }
            try {
                jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
            }
            catch (IOException ioe) {
                this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                throw new JsonDBException("Failed to save " + collectionName, ioe);
            }
            boolean appendResult = jw.appendToJsonFile(collection.values(), newCollection.values());
            if (appendResult) {
                collection.putAll(newCollection);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            collectionMeta.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> void save(Object objectToSave, Class<T> entityClass) {
        this.save(objectToSave, Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> void save(Object objectToSave, String collectionName) {
        if (null == objectToSave) {
            throw new InvalidJsonDbApiUsageException("Null Object cannot be updated into DB");
        }
        Util.ensureNotRestricted(objectToSave);
        Object objToSave = Util.deepCopy(objectToSave);
        CollectionMetaData collectionMeta = this.cmdMap.get(collectionName);
        collectionMeta.getCollectionLock().writeLock().lock();
        try {
            Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
            if (null == collection) {
                throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
            }
            CollectionMetaData cmd = this.cmdMap.get(collectionName);
            Object id = Util.getIdForEntity(objToSave, cmd.getIdAnnotatedFieldGetterMethod());
            Object existingObject = collection.get(id);
            if (null == existingObject) {
                throw new InvalidJsonDbApiUsageException(String.format("Document with Id: '%s' not found in Collection by name '%s' not found. Insert or Upsert the object first.", id, collectionName));
            }
            if (this.encrypted && cmd.hasSecret()) {
                CryptoUtil.encryptFields(objToSave, cmd, this.dbConfig.getCipher());
            }
            JsonWriter jw = null;
            try {
                jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
            }
            catch (IOException ioe) {
                this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                throw new JsonDBException("Failed to save " + collectionName, ioe);
            }
            boolean updateResult = jw.updateInJsonFile(collection, id, objToSave);
            if (updateResult) {
                Object newObject = objToSave;
                collection.put(id, newObject);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            collectionMeta.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> T remove(Object objectToRemove) {
        return this.remove(objectToRemove, Util.determineEntityCollectionName(objectToRemove));
    }

    @Override
    public <T> T remove(Object objectToRemove, Class<T> entityClass) {
        return this.remove(objectToRemove, Util.determineCollectionName(entityClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T remove(Object objectToRemove, String collectionName) {
        if (null == objectToRemove) {
            throw new InvalidJsonDbApiUsageException("Null Object cannot be removed from DB");
        }
        Util.ensureNotRestricted(objectToRemove);
        CollectionMetaData collectionMeta = this.cmdMap.get(collectionName);
        collectionMeta.getCollectionLock().writeLock().lock();
        try {
            JsonWriter jw;
            Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
            if (null == collection) {
                throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
            }
            CollectionMetaData cmd = this.cmdMap.get(collectionName);
            Object id = Util.getIdForEntity(objectToRemove, cmd.getIdAnnotatedFieldGetterMethod());
            if (!collection.containsKey(id)) {
                throw new InvalidJsonDbApiUsageException(String.format("Objects with Id %s not found in collection %s", id, collectionName));
            }
            try {
                jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
            }
            catch (IOException ioe) {
                this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                throw new JsonDBException("Failed to save " + collectionName, ioe);
            }
            boolean substractResult = jw.removeFromJsonFile(collection, id);
            if (substractResult) {
                Object objectRemoved;
                Object obj = objectRemoved = collection.remove(id);
                return (T)obj;
            }
            T t = null;
            return t;
        }
        finally {
            collectionMeta.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> List<T> remove(Collection<? extends T> batchToRemove, Class<T> entityClass) {
        return this.remove(batchToRemove, Util.determineCollectionName(entityClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> remove(Collection<? extends T> batchToRemove, String collectionName) {
        if (null == batchToRemove) {
            throw new InvalidJsonDbApiUsageException("Null Object batch cannot be removed from DB");
        }
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        cmd.getCollectionLock().writeLock().lock();
        try {
            JsonWriter jw;
            Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
            if (null == collection) {
                throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
            }
            HashSet<Object> removeIds = new HashSet<Object>();
            for (T o : batchToRemove) {
                Object id = Util.getIdForEntity(o, cmd.getIdAnnotatedFieldGetterMethod());
                if (!collection.containsKey(id)) continue;
                removeIds.add(id);
            }
            if (removeIds.size() < 1) {
                Iterator<T> iterator2 = null;
                return iterator2;
            }
            try {
                jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
            }
            catch (IOException ioe) {
                this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                throw new JsonDBException("Failed to save " + collectionName, ioe);
            }
            boolean substractResult = jw.removeFromJsonFile(collection, removeIds);
            ArrayList removedObjects = null;
            if (substractResult) {
                removedObjects = new ArrayList();
                for (Object e : removeIds) {
                    removedObjects.add(collection.remove(e));
                }
            }
            ArrayList<?> arrayList = removedObjects;
            return arrayList;
        }
        finally {
            cmd.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> void upsert(Object objectToSave) {
        if (null == objectToSave) {
            throw new InvalidJsonDbApiUsageException("Null Object cannot be upserted into DB");
        }
        Util.ensureNotRestricted(objectToSave);
        this.upsert(objectToSave, Util.determineEntityCollectionName(objectToSave));
    }

    @Override
    public <T> void upsert(Object objectToSave, String collectionName) {
        if (null == objectToSave) {
            throw new InvalidJsonDbApiUsageException("Null Object cannot be upserted into DB");
        }
        Util.ensureNotRestricted(objectToSave);
        Object objToSave = Util.deepCopy(objectToSave);
        CollectionMetaData collectionMeta = this.cmdMap.get(collectionName);
        collectionMeta.getCollectionLock().writeLock().lock();
        try {
            JsonWriter jw;
            Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
            if (null == collection) {
                throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first");
            }
            CollectionMetaData cmd = this.cmdMap.get(collectionName);
            Object id = Util.getIdForEntity(objectToSave, cmd.getIdAnnotatedFieldGetterMethod());
            if (this.encrypted && cmd.hasSecret()) {
                CryptoUtil.encryptFields(objToSave, cmd, this.dbConfig.getCipher());
            }
            boolean insert = true;
            if (null == id) {
                id = Util.setIdForEntity(objToSave, cmd.getIdAnnotatedFieldSetterMethod());
            } else if (collection.containsKey(id)) {
                insert = false;
            }
            try {
                jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
            }
            catch (IOException ioe) {
                this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                throw new JsonDBException("Failed to save " + collectionName, ioe);
            }
            if (insert) {
                boolean insertResult = jw.appendToJsonFile(collection.values(), objToSave);
                if (insertResult) {
                    collection.put(Util.deepCopy(id), objToSave);
                }
            } else {
                boolean updateResult = jw.updateInJsonFile(collection, id, objToSave);
                if (updateResult) {
                    Object newObject = objToSave;
                    collection.put(id, newObject);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            collectionMeta.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> void upsert(Collection<? extends T> batchToSave, Class<T> entityClass) {
        this.upsert(batchToSave, Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> void upsert(Collection<? extends T> batchToSave, String collectionName) {
        if (null == batchToSave) {
            throw new InvalidJsonDbApiUsageException("Null Object batch cannot be upserted into DB");
        }
        CollectionMetaData collectionMeta = this.cmdMap.get(collectionName);
        collectionMeta.getCollectionLock().writeLock().lock();
        try {
            boolean updateResult;
            boolean insertResult;
            JsonWriter jw;
            Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
            if (null == collection) {
                throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first");
            }
            CollectionMetaData cmd = this.cmdMap.get(collectionName);
            HashSet<Object> uniqueIds = new HashSet<Object>();
            LinkedHashMap<Object, Object> collectionToInsert = new LinkedHashMap<Object, Object>();
            LinkedHashMap<Object, Object> collectionToUpdate = new LinkedHashMap<Object, Object>();
            for (T o : batchToSave) {
                Object obj = Util.deepCopy(o);
                Object id = Util.getIdForEntity(obj, cmd.getIdAnnotatedFieldGetterMethod());
                if (this.encrypted && cmd.hasSecret()) {
                    CryptoUtil.encryptFields(obj, cmd, this.dbConfig.getCipher());
                }
                boolean insert = true;
                if (null == id) {
                    id = Util.setIdForEntity(obj, cmd.getIdAnnotatedFieldSetterMethod());
                } else if (collection.containsKey(id)) {
                    insert = false;
                }
                if (!uniqueIds.add(id)) {
                    throw new InvalidJsonDbApiUsageException("Duplicate object with id: " + id + " within the passed in parameter");
                }
                if (insert) {
                    collectionToInsert.put(Util.deepCopy(id), obj);
                    continue;
                }
                collectionToUpdate.put(Util.deepCopy(id), obj);
            }
            try {
                jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
            }
            catch (IOException ioe) {
                this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                throw new JsonDBException("Failed to save " + collectionName, ioe);
            }
            if (collectionToInsert.size() > 0 && (insertResult = jw.appendToJsonFile(collection.values(), collectionToInsert.values()))) {
                collection.putAll(collectionToInsert);
            }
            if (collectionToUpdate.size() > 0 && (updateResult = jw.updateInJsonFile(collection, collectionToUpdate))) {
                collection.putAll(collectionToUpdate);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            collectionMeta.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> T findAndRemove(String jxQuery, Class<T> entityClass) {
        return this.findAndRemove(jxQuery, Util.determineCollectionName(entityClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T findAndRemove(String jxQuery, String collectionName) {
        if (null == jxQuery) {
            throw new InvalidJsonDbApiUsageException("Query string cannot be null.");
        }
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
        if (null == cmd || null == collection) {
            throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
        }
        cmd.getCollectionLock().writeLock().lock();
        try {
            JXPathContext context = this.contextsRef.get().get(collectionName);
            Iterator resultItr = context.iterate(jxQuery);
            Object objectToRemove = null;
            if (resultItr.hasNext()) {
                objectToRemove = resultItr.next();
            }
            if (null != objectToRemove) {
                JsonWriter jw;
                Object idToRemove = Util.getIdForEntity(objectToRemove, cmd.getIdAnnotatedFieldGetterMethod());
                if (!collection.containsKey(idToRemove)) {
                    throw new InvalidJsonDbApiUsageException(String.format("Objects with Id %s not found in collection %s", idToRemove, collectionName));
                }
                try {
                    jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
                }
                catch (IOException ioe) {
                    this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                    throw new JsonDBException("Failed to save " + collectionName, ioe);
                }
                boolean substractResult = jw.removeFromJsonFile(collection, idToRemove);
                if (substractResult) {
                    Object objectRemoved;
                    Object obj = objectRemoved = collection.remove(idToRemove);
                    return (T)obj;
                }
                this.logger.error("Unexpected, Failed to substract the object");
            }
            T t = null;
            return t;
        }
        finally {
            cmd.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> List<T> findAllAndRemove(String jxQuery, Class<T> entityClass) {
        return this.findAllAndRemove(jxQuery, Util.determineCollectionName(entityClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> findAllAndRemove(String jxQuery, String collectionName) {
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
        if (null == cmd || null == collection) {
            throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
        }
        cmd.getCollectionLock().writeLock().lock();
        try {
            JsonWriter jw;
            Object objectToRemove;
            JXPathContext context = this.contextsRef.get().get(collectionName);
            Iterator resultItr = context.iterate(jxQuery);
            HashSet<Object> removeIds = new HashSet<Object>();
            while (resultItr.hasNext()) {
                objectToRemove = resultItr.next();
                Object idToRemove = Util.getIdForEntity(objectToRemove, cmd.getIdAnnotatedFieldGetterMethod());
                removeIds.add(idToRemove);
            }
            if (removeIds.size() < 1) {
                objectToRemove = null;
                return objectToRemove;
            }
            try {
                jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
            }
            catch (IOException ioe) {
                this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                throw new JsonDBException("Failed to save " + collectionName, ioe);
            }
            boolean substractResult = jw.removeFromJsonFile(collection, removeIds);
            ArrayList removedObjects = null;
            if (substractResult) {
                removedObjects = new ArrayList();
                for (Object e : removeIds) {
                    removedObjects.add(collection.remove(e));
                }
            }
            ArrayList<?> arrayList = removedObjects;
            return arrayList;
        }
        finally {
            cmd.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> T findAndModify(String jxQuery, Update update, Class<T> entityClass) {
        return this.findAndModify(jxQuery, update, Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findAndModify(String jxQuery, Update update, String collectionName) {
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
        if (null == cmd || null == collection) {
            throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
        }
        cmd.getCollectionLock().writeLock().lock();
        try {
            JXPathContext context = this.contextsRef.get().get(collectionName);
            Iterator resultItr = context.iterate(jxQuery);
            Object objectToModify = null;
            Object clonedModifiedObject = null;
            if (resultItr.hasNext()) {
                objectToModify = resultItr.next();
            }
            if (null != objectToModify) {
                clonedModifiedObject = Util.deepCopy(objectToModify);
                for (Map.Entry<String, Object> entry : update.getUpdateData().entrySet()) {
                    Object newValue = Util.deepCopy(entry.getValue());
                    if (this.encrypted && cmd.hasSecret() && cmd.isSecretField(entry.getKey())) {
                        newValue = this.dbConfig.getCipher().encrypt(newValue.toString());
                    }
                    try {
                        BeanUtils.copyProperty(clonedModifiedObject, entry.getKey(), newValue);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        this.logger.error("Failed to copy updated data into existing collection document using BeanUtils", (Throwable)e);
                        T t = null;
                        cmd.getCollectionLock().writeLock().unlock();
                        return t;
                    }
                }
                Object idToModify = Util.getIdForEntity(clonedModifiedObject, cmd.getIdAnnotatedFieldGetterMethod());
                JsonWriter jw = null;
                try {
                    jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
                }
                catch (IOException ioe) {
                    this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                    throw new JsonDBException("Failed to save " + collectionName, ioe);
                }
                boolean updateResult = jw.updateInJsonFile(collection, idToModify, clonedModifiedObject);
                if (updateResult) {
                    collection.put(idToModify, clonedModifiedObject);
                    Object returnObj = Util.deepCopy(clonedModifiedObject);
                    if (this.encrypted && cmd.hasSecret() && null != returnObj) {
                        CryptoUtil.decryptFields(returnObj, cmd, this.dbConfig.getCipher());
                    }
                    Object object = returnObj;
                    return (T)object;
                }
            }
            Iterator<Map.Entry<String, Object>> iterator2 = null;
            return (T)iterator2;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            cmd.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> List<T> findAllAndModify(String jxQuery, Update update, Class<T> entityClass) {
        return this.findAllAndModify(jxQuery, update, Util.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAllAndModify(String jxQuery, Update update, String collectionName) {
        CollectionMetaData cmd = this.cmdMap.get(collectionName);
        Map<Object, ?> collection = this.collectionsRef.get().get(collectionName);
        if (null == cmd || null == collection) {
            throw new InvalidJsonDbApiUsageException("Collection by name '" + collectionName + "' not found. Create collection first.");
        }
        cmd.getCollectionLock().writeLock().lock();
        try {
            JXPathContext context = this.contextsRef.get().get(collectionName);
            Iterator resultItr = context.iterate(jxQuery);
            HashMap<Object, Object> clonedModifiedObjects = new HashMap<Object, Object>();
            while (resultItr.hasNext()) {
                Object objectToModify = resultItr.next();
                Object clonedModifiedObject = Util.deepCopy(objectToModify);
                for (Map.Entry<String, Object> entry : update.getUpdateData().entrySet()) {
                    Object newValue = Util.deepCopy(entry.getValue());
                    if (this.encrypted && cmd.hasSecret() && cmd.isSecretField(entry.getKey())) {
                        newValue = this.dbConfig.getCipher().encrypt(newValue.toString());
                    }
                    try {
                        BeanUtils.copyProperty(clonedModifiedObject, entry.getKey(), newValue);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        this.logger.error("Failed to copy updated data into existing collection document using BeanUtils", (Throwable)e);
                        List<T> list = null;
                        cmd.getCollectionLock().writeLock().unlock();
                        return list;
                    }
                }
                Object id = Util.getIdForEntity(clonedModifiedObject, cmd.getIdAnnotatedFieldGetterMethod());
                clonedModifiedObjects.put(id, clonedModifiedObject);
            }
            JsonWriter jw = null;
            try {
                jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
            }
            catch (IOException ioe) {
                this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                throw new JsonDBException("Failed to save " + collectionName, ioe);
            }
            boolean updateResult = jw.updateInJsonFile(collection, clonedModifiedObjects);
            if (updateResult) {
                collection.putAll(clonedModifiedObjects);
                ArrayList<Object> returnObjects = new ArrayList<Object>();
                for (Object obj : clonedModifiedObjects.values()) {
                    Object returnObj = Util.deepCopy(obj);
                    if (this.encrypted && cmd.hasSecret() && null != returnObj) {
                        CryptoUtil.decryptFields(returnObj, cmd, this.dbConfig.getCipher());
                    }
                    returnObjects.add(returnObj);
                }
                ArrayList<Object> arrayList = returnObjects;
                return arrayList;
            }
            Iterator<Map.Entry<String, Object>> iterator2 = null;
            return iterator2;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)e);
            throw new JsonDBException("Error when decrypting value for a @Secret annotated field for entity: " + collectionName, e);
        }
        finally {
            cmd.getCollectionLock().writeLock().unlock();
        }
    }

    @Override
    public <T> void changeEncryption(ICipher newCipher) {
        if (!this.encrypted) {
            throw new InvalidJsonDbApiUsageException("DB is not encrypted, nothing to change for EncryptionKey");
        }
        for (Map.Entry<String, Map<Object, ?>> entry : this.collectionsRef.get().entrySet()) {
            CollectionMetaData cmd = this.cmdMap.get(entry.getKey());
            if (!cmd.hasSecret()) continue;
            cmd.getCollectionLock().writeLock().lock();
        }
        String collectionName = null;
        try {
            for (Map.Entry<String, Map<Object, ?>> entry : this.collectionsRef.get().entrySet()) {
                collectionName = entry.getKey();
                Map<Object, ?> collection = entry.getValue();
                CollectionMetaData cmd = this.cmdMap.get(collectionName);
                if (!cmd.hasSecret()) continue;
                LinkedHashMap<Object, Object> reCryptedObjects = new LinkedHashMap<Object, Object>();
                for (Map.Entry<Object, ?> object : collection.entrySet()) {
                    Object clonedObject = Util.deepCopy(object.getValue());
                    CryptoUtil.decryptFields(clonedObject, cmd, this.dbConfig.getCipher());
                    CryptoUtil.encryptFields(clonedObject, cmd, newCipher);
                    reCryptedObjects.put(object.getKey(), clonedObject);
                }
                JsonWriter jw = null;
                try {
                    jw = new JsonWriter(this.dbConfig, cmd, collectionName, this.fileObjectsRef.get().get(collectionName));
                }
                catch (IOException ioe) {
                    this.logger.error("Failed to obtain writer for " + collectionName, (Throwable)ioe);
                    throw new JsonDBException("Failed to save " + collectionName, ioe);
                }
                boolean updateResult = jw.updateInJsonFile(collection, reCryptedObjects);
                if (!updateResult) {
                    throw new JsonDBException("Failed to write re-crypted collection data to .json files, database might have become insconsistent");
                }
                collection.putAll(reCryptedObjects);
            }
            this.dbConfig.setCipher(newCipher);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            this.logger.error("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, (Throwable)exception);
            throw new JsonDBException("Error when encrypting value for a @Secret annotated field for entity: " + collectionName, exception);
        }
        finally {
            for (Map.Entry<String, Map<Object, ?>> entry : this.collectionsRef.get().entrySet()) {
                CollectionMetaData cmd = this.cmdMap.get(entry.getKey());
                if (!cmd.hasSecret()) continue;
                cmd.getCollectionLock().writeLock().unlock();
            }
        }
    }

    @Override
    public void backup(String backupPath) {
    }

    @Override
    public void restore(String restorePath, boolean merge) {
    }
}

