/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.io.jsondb;

import com.hypherionmc.sdlink.shaded.io.jsondb.JsonDBConfig;
import com.hypherionmc.sdlink.shaded.io.jsondb.annotation.Document;
import com.hypherionmc.sdlink.shaded.io.jsondb.annotation.Id;
import com.hypherionmc.sdlink.shaded.io.jsondb.annotation.Secret;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CollectionMetaData {
    private String collectionName;
    private String schemaVersion;
    private String actualSchemaVersion;
    private Comparator<String> schemaComparator;
    private Class<?> clazz;
    private String idAnnotatedFieldName;
    private Method idAnnotatedFieldGetterMethod;
    private Method idAnnotatedFieldSetterMethod;
    private final ReentrantReadWriteLock collectionLock;
    private List<String> secretAnnotatedFieldNames = new ArrayList<String>();
    private Map<String, Method> getterMethodMap = new TreeMap<String, Method>();
    private Map<String, Method> setterMethodMap = new TreeMap<String, Method>();
    private boolean hasSecret;
    private boolean readonly;

    public CollectionMetaData(String collectionName, Class<?> clazz, String schemaVersion, Comparator<String> schemaComparator) {
        this.collectionName = collectionName;
        this.schemaVersion = schemaVersion;
        this.schemaComparator = schemaComparator;
        this.clazz = clazz;
        this.collectionLock = new ReentrantReadWriteLock();
        ArrayList<Field[]> fields = new ArrayList<Field[]>();
        Field[] startFields = clazz.getDeclaredFields();
        int totalFields = startFields.length;
        fields.add(startFields);
        while (clazz.getSuperclass() != Object.class) {
            clazz = clazz.getSuperclass();
            Field[] toAdd = clazz.getDeclaredFields();
            totalFields += toAdd.length;
            fields.add(toAdd);
        }
        int x = 0;
        Field[] fs = new Field[totalFields];
        Iterator iterator2 = fields.iterator();
        while (iterator2.hasNext()) {
            Field[] field;
            Field[] fieldArray = field = (Field[])iterator2.next();
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field value;
                fs[x] = value = fieldArray[i];
                ++x;
            }
        }
        Method[] ms = clazz.getDeclaredMethods();
        for (Field f : fs) {
            Annotation[] annotations;
            String fieldName = f.getName();
            for (Annotation a : annotations = f.getDeclaredAnnotations()) {
                if (a.annotationType().equals(Id.class)) {
                    this.idAnnotatedFieldName = fieldName;
                }
                if (!a.annotationType().equals(Secret.class)) continue;
                this.secretAnnotatedFieldNames.add(fieldName);
                this.hasSecret = true;
            }
            String getterMethodName = this.formGetterMethodName(f);
            String setterMethodName = this.formSetterMethodName(f);
            for (Method m : ms) {
                if (m.getName().equals(getterMethodName)) {
                    this.getterMethodMap.put(fieldName, m);
                }
                if (!m.getName().equals(setterMethodName)) continue;
                this.setterMethodMap.put(fieldName, m);
            }
        }
        this.idAnnotatedFieldGetterMethod = this.getterMethodMap.get(this.idAnnotatedFieldName);
        this.idAnnotatedFieldSetterMethod = this.setterMethodMap.get(this.idAnnotatedFieldName);
    }

    protected ReentrantReadWriteLock getCollectionLock() {
        return this.collectionLock;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getActualSchemaVersion() {
        return this.actualSchemaVersion;
    }

    public void setActualSchemaVersion(String actualSchemaVersion) {
        this.actualSchemaVersion = actualSchemaVersion;
        int compareResult = this.schemaComparator.compare(this.schemaVersion, actualSchemaVersion);
        this.readonly = compareResult != 0;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public String getIdAnnotatedFieldName() {
        return this.idAnnotatedFieldName;
    }

    public Method getIdAnnotatedFieldGetterMethod() {
        return this.idAnnotatedFieldGetterMethod;
    }

    public Method getIdAnnotatedFieldSetterMethod() {
        return this.idAnnotatedFieldSetterMethod;
    }

    public List<String> getSecretAnnotatedFieldNames() {
        return this.secretAnnotatedFieldNames;
    }

    public boolean isSecretField(String fieldName) {
        return this.secretAnnotatedFieldNames.contains(fieldName);
    }

    public Method getGetterMethodForFieldName(String fieldName) {
        return this.getterMethodMap.get(fieldName);
    }

    public Method getSetterMethodForFieldName(String fieldName) {
        return this.setterMethodMap.get(fieldName);
    }

    public boolean hasSecret() {
        return this.hasSecret;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    private String formGetterMethodName(Field field) {
        String fieldName = field.getName();
        if (field.getType().equals(Boolean.TYPE)) {
            return "is" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        }
        return "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    private String formSetterMethodName(Field field) {
        String fieldName = field.getName();
        return "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    public static Map<String, CollectionMetaData> builder(JsonDBConfig dbConfig, Set<Class<?>> tables) {
        LinkedHashMap<String, CollectionMetaData> collectionMetaData = new LinkedHashMap<String, CollectionMetaData>();
        for (Class<?> c : tables) {
            if (!c.isAnnotationPresent(Document.class)) continue;
            Document d = c.getAnnotation(Document.class);
            String collectionName = d.collection();
            String version = d.schemaVersion();
            CollectionMetaData cmd = new CollectionMetaData(collectionName, c, version, dbConfig.getSchemaComparator());
            collectionMetaData.put(collectionName, cmd);
        }
        return collectionMetaData;
    }
}

