/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.gnu.trove.map.hash;

import com.hypherionmc.sdlink.shaded.gnu.trove.TIntCollection;
import com.hypherionmc.sdlink.shaded.gnu.trove.TShortCollection;
import com.hypherionmc.sdlink.shaded.gnu.trove.function.TIntFunction;
import com.hypherionmc.sdlink.shaded.gnu.trove.impl.HashFunctions;
import com.hypherionmc.sdlink.shaded.gnu.trove.impl.hash.THashPrimitiveIterator;
import com.hypherionmc.sdlink.shaded.gnu.trove.impl.hash.TPrimitiveHash;
import com.hypherionmc.sdlink.shaded.gnu.trove.impl.hash.TShortIntHash;
import com.hypherionmc.sdlink.shaded.gnu.trove.iterator.TIntIterator;
import com.hypherionmc.sdlink.shaded.gnu.trove.iterator.TShortIntIterator;
import com.hypherionmc.sdlink.shaded.gnu.trove.iterator.TShortIterator;
import com.hypherionmc.sdlink.shaded.gnu.trove.map.TShortIntMap;
import com.hypherionmc.sdlink.shaded.gnu.trove.procedure.TIntProcedure;
import com.hypherionmc.sdlink.shaded.gnu.trove.procedure.TShortIntProcedure;
import com.hypherionmc.sdlink.shaded.gnu.trove.procedure.TShortProcedure;
import com.hypherionmc.sdlink.shaded.gnu.trove.set.TShortSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TShortIntHashMap
extends TShortIntHash
implements TShortIntMap,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient int[] _values;

    public TShortIntHashMap() {
    }

    public TShortIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TShortIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TShortIntHashMap(int initialCapacity, float loadFactor, short noEntryKey, int noEntryValue) {
        super(initialCapacity, loadFactor, noEntryKey, noEntryValue);
    }

    public TShortIntHashMap(short[] keys2, int[] values2) {
        super(Math.max(keys2.length, values2.length));
        int size = Math.min(keys2.length, values2.length);
        for (int i = 0; i < size; ++i) {
            this.put(keys2[i], values2[i]);
        }
    }

    public TShortIntHashMap(TShortIntMap map) {
        super(map.size());
        if (map instanceof TShortIntHashMap) {
            TShortIntHashMap hashmap = (TShortIntHashMap)map;
            this._loadFactor = hashmap._loadFactor;
            this.no_entry_key = hashmap.no_entry_key;
            this.no_entry_value = hashmap.no_entry_value;
            if (this.no_entry_key != 0) {
                Arrays.fill(this._set, this.no_entry_key);
            }
            if (this.no_entry_value != 0) {
                Arrays.fill(this._values, this.no_entry_value);
            }
            this.setUp((int)Math.ceil(10.0f / this._loadFactor));
        }
        this.putAll(map);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new int[capacity];
        return capacity;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        short[] oldKeys = this._set;
        int[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new short[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            short o = oldKeys[i];
            int index = this.insertKey(o);
            this._values[index] = oldVals[i];
        }
    }

    @Override
    public int put(short key, int value) {
        int index = this.insertKey(key);
        return this.doPut(key, value, index);
    }

    @Override
    public int putIfAbsent(short key, int value) {
        int index = this.insertKey(key);
        if (index < 0) {
            return this._values[-index - 1];
        }
        return this.doPut(key, value, index);
    }

    private int doPut(short key, int value, int index) {
        int previous = this.no_entry_value;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Integer> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<? extends Short, ? extends Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TShortIntMap map) {
        this.ensureCapacity(map.size());
        TShortIntIterator iter = map.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.put(iter.key(), iter.value());
        }
    }

    @Override
    public int get(short key) {
        int index = this.index(key);
        return index < 0 ? this.no_entry_value : this._values[index];
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, this.no_entry_key);
        Arrays.fill(this._values, 0, this._values.length, this.no_entry_value);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public int remove(short key) {
        int prev = this.no_entry_value;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = this.no_entry_value;
        super.removeAt(index);
    }

    @Override
    public TShortSet keySet() {
        return new TKeyView();
    }

    @Override
    public short[] keys() {
        short[] keys2 = new short[this.size()];
        short[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys2[j++] = k[i];
        }
        return keys2;
    }

    @Override
    public short[] keys(short[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new short[size];
        }
        short[] keys2 = this._set;
        byte[] states = this._states;
        int i = keys2.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            array[j++] = keys2[i];
        }
        return array;
    }

    @Override
    public TIntCollection valueCollection() {
        return new TValueView();
    }

    @Override
    public int[] values() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    @Override
    public int[] values(int[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new int[size];
        }
        int[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            array[j++] = v[i];
        }
        return array;
    }

    @Override
    public boolean containsValue(int val) {
        byte[] states = this._states;
        int[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(short key) {
        return this.contains(key);
    }

    @Override
    public TShortIntIterator iterator() {
        return new TShortIntHashIterator(this);
    }

    @Override
    public boolean forEachKey(TShortProcedure procedure) {
        return this.forEach(procedure);
    }

    @Override
    public boolean forEachValue(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TShortIntProcedure procedure) {
        byte[] states = this._states;
        short[] keys2 = this._set;
        int[] values2 = this._values;
        int i = keys2.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transformValues(TIntFunction function) {
        byte[] states = this._states;
        int[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values2[i] = function.execute(values2[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TShortIntProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        short[] keys2 = this._set;
        int[] values2 = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys2.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    @Override
    public boolean increment(short key) {
        return this.adjustValue(key, 1);
    }

    @Override
    public boolean adjustValue(short key, int amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    @Override
    public int adjustOrPutValue(short key, int adjust_amount, int put_amount) {
        boolean isNewMapping;
        int newValue;
        int index = this.insertKey(key);
        if (index < 0) {
            int n = index = -index - 1;
            int n2 = this._values[n] + adjust_amount;
            this._values[n] = n2;
            newValue = n2;
            isNewMapping = false;
        } else {
            newValue = this._values[index] = put_amount;
            isNewMapping = true;
        }
        byte previousState = this._states[index];
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return newValue;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TShortIntMap)) {
            return false;
        }
        TShortIntMap that = (TShortIntMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        int[] values2 = this._values;
        byte[] states = this._states;
        int this_no_entry_value = this.getNoEntryValue();
        int that_no_entry_value = that.getNoEntryValue();
        int i = values2.length;
        while (i-- > 0) {
            short key;
            int that_value;
            int this_value;
            if (states[i] != 1 || (this_value = values2[i]) == (that_value = that.get(key = this._set[i])) || this_value == this_no_entry_value || that_value == that_no_entry_value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        byte[] states = this._states;
        int i = this._values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            hashcode += HashFunctions.hash(this._set[i]) ^ HashFunctions.hash(this._values[i]);
        }
        return hashcode;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TShortIntProcedure(){
            private boolean first = true;

            public boolean execute(short key, int value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeInt(this._size);
        int i = this._states.length;
        while (i-- > 0) {
            if (this._states[i] != 1) continue;
            out.writeShort(this._set[i]);
            out.writeInt(this._values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            short key = in.readShort();
            int val = in.readInt();
            this.put(key, val);
        }
    }

    class TShortIntHashIterator
    extends THashPrimitiveIterator
    implements TShortIntIterator {
        TShortIntHashIterator(TShortIntHashMap map) {
            super(map);
        }

        public void advance() {
            this.moveToNextIndex();
        }

        public short key() {
            return TShortIntHashMap.this._set[this._index];
        }

        public int value() {
            return TShortIntHashMap.this._values[this._index];
        }

        public int setValue(int val) {
            int old = this.value();
            TShortIntHashMap.this._values[this._index] = val;
            return old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TShortIntHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TShortIntValueHashIterator
    extends THashPrimitiveIterator
    implements TIntIterator {
        TShortIntValueHashIterator(TPrimitiveHash hash) {
            super(hash);
        }

        public int next() {
            this.moveToNextIndex();
            return TShortIntHashMap.this._values[this._index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TShortIntHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TShortIntKeyHashIterator
    extends THashPrimitiveIterator
    implements TShortIterator {
        TShortIntKeyHashIterator(TPrimitiveHash hash) {
            super(hash);
        }

        public short next() {
            this.moveToNextIndex();
            return TShortIntHashMap.this._set[this._index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TShortIntHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TValueView
    implements TIntCollection {
        protected TValueView() {
        }

        @Override
        public TIntIterator iterator() {
            return new TShortIntValueHashIterator(TShortIntHashMap.this);
        }

        @Override
        public int getNoEntryValue() {
            return TShortIntHashMap.this.no_entry_value;
        }

        @Override
        public int size() {
            return TShortIntHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TShortIntHashMap.this._size;
        }

        @Override
        public boolean contains(int entry) {
            return TShortIntHashMap.this.containsValue(entry);
        }

        @Override
        public int[] toArray() {
            return TShortIntHashMap.this.values();
        }

        @Override
        public int[] toArray(int[] dest) {
            return TShortIntHashMap.this.values(dest);
        }

        @Override
        public boolean add(int entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(int entry) {
            int[] values2 = TShortIntHashMap.this._values;
            short[] set = TShortIntHashMap.this._set;
            int i = values2.length;
            while (i-- > 0) {
                if (set[i] == 0 || set[i] == 2 || entry != values2[i]) continue;
                TShortIntHashMap.this.removeAt(i);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Integer) {
                    int ele = (Integer)element;
                    if (TShortIntHashMap.this.containsValue(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TIntCollection collection) {
            TIntIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TShortIntHashMap.this.containsValue(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(int[] array) {
            for (int element : array) {
                if (TShortIntHashMap.this.containsValue(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TIntCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TIntIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TIntCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TIntIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(int[] array) {
            boolean changed = false;
            Arrays.sort(array);
            int[] values2 = TShortIntHashMap.this._values;
            byte[] states = TShortIntHashMap.this._states;
            int i = values2.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array, values2[i]) >= 0) continue;
                TShortIntHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                int c;
                if (!(element instanceof Integer) || !this.remove(c = ((Integer)element).intValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TIntCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TIntIterator iter = collection.iterator();
            while (iter.hasNext()) {
                int element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(int[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TShortIntHashMap.this.clear();
        }

        @Override
        public boolean forEach(TIntProcedure procedure) {
            return TShortIntHashMap.this.forEachValue(procedure);
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TShortIntHashMap.this.forEachValue(new TIntProcedure(){
                private boolean first = true;

                public boolean execute(int value) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(value);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TKeyView
    implements TShortSet {
        protected TKeyView() {
        }

        @Override
        public TShortIterator iterator() {
            return new TShortIntKeyHashIterator(TShortIntHashMap.this);
        }

        @Override
        public short getNoEntryValue() {
            return TShortIntHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TShortIntHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TShortIntHashMap.this._size;
        }

        @Override
        public boolean contains(short entry) {
            return TShortIntHashMap.this.contains(entry);
        }

        @Override
        public short[] toArray() {
            return TShortIntHashMap.this.keys();
        }

        @Override
        public short[] toArray(short[] dest) {
            return TShortIntHashMap.this.keys(dest);
        }

        @Override
        public boolean add(short entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(short entry) {
            return TShortIntHashMap.this.no_entry_value != TShortIntHashMap.this.remove(entry);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Short) {
                    short ele = (Short)element;
                    if (TShortIntHashMap.this.containsKey(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TShortCollection collection) {
            TShortIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TShortIntHashMap.this.containsKey(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(short[] array) {
            for (short element : array) {
                if (TShortIntHashMap.this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Short> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TShortCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(short[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TShortIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TShortCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TShortIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(short[] array) {
            boolean changed = false;
            Arrays.sort(array);
            short[] set = TShortIntHashMap.this._set;
            byte[] states = TShortIntHashMap.this._states;
            int i = set.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
                TShortIntHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                short c;
                if (!(element instanceof Short) || !this.remove(c = ((Short)element).shortValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TShortCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TShortIterator iter = collection.iterator();
            while (iter.hasNext()) {
                short element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(short[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TShortIntHashMap.this.clear();
        }

        @Override
        public boolean forEach(TShortProcedure procedure) {
            return TShortIntHashMap.this.forEachKey(procedure);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TShortSet)) {
                return false;
            }
            TShortSet that = (TShortSet)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = TShortIntHashMap.this._states.length;
            while (i-- > 0) {
                if (TShortIntHashMap.this._states[i] != 1 || that.contains(TShortIntHashMap.this._set[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashcode = 0;
            int i = TShortIntHashMap.this._states.length;
            while (i-- > 0) {
                if (TShortIntHashMap.this._states[i] != 1) continue;
                hashcode += HashFunctions.hash(TShortIntHashMap.this._set[i]);
            }
            return hashcode;
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TShortIntHashMap.this.forEachKey(new TShortProcedure(){
                private boolean first = true;

                public boolean execute(short key) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(key);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }
}

