/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.thermal;

import cofh.lib.common.block.CropBlockPerennial;
import cofh.lib.util.helpers.MathHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.mixin.common.thermal.CropBlockCoFHAccessor;

public class PerennialCrop
extends CustomizedCrop {
    @Override
    public boolean isCrop(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() instanceof CropBlockPerennial;
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestPositionFunction getSpecialHarvestPosition(@NotNull PlantBlockContext context) {
        return this::getHarvestPosition;
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestMethodFunction getSpecialHarvestMethod(@NotNull PlantBlockContext context) {
        return this::harvest;
    }

    private BlockPos getHarvestPosition(@NotNull PlantBlockContext context) {
        CropBlockPerennial block;
        BlockState state = context.getState();
        Block block2 = state.m_60734_();
        if (block2 instanceof CropBlockPerennial && (block = (CropBlockPerennial)block2).canHarvest(state)) {
            return context.getPosition();
        }
        return null;
    }

    private List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            BlockState state = context.getState();
            CropBlockPerennial block = (CropBlockPerennial)state.m_60734_();
            CropBlockCoFHAccessor accessor = (CropBlockCoFHAccessor)block;
            int fortune = 0;
            ItemStack drop = new ItemStack(accessor.invokeGetCropItem(), 2 + MathHelper.binomialDist((int)fortune, (double)0.5));
            level.m_7731_(context.getPosition(), block.m_52289_(accessor.invokeGetPostHarvestAge()), 2);
            return Collections.singletonList(drop);
        }
        return Collections.emptyList();
    }
}

