/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.reliquary;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import reliquary.entities.shot.NeutralShotEntity;
import reliquary.entities.shot.ShotEntityBase;
import reliquary.init.ModItems;
import reliquary.init.ModSounds;
import reliquary.items.HandgunItem;
import reliquary.items.MagazineItem;
import reliquary.util.potions.XRPotionHelper;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAIContext;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.CustomizedAIGunner;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.AttackDelayConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.BulletMode;
import steve_gall.minecolonies_compatibility.mixin.common.reliquary.HandgunItemAccessor;
import steve_gall.minecolonies_compatibility.module.common.reliquary.Magazine;
import steve_gall.minecolonies_compatibility.module.common.reliquary.ReliquaryConfig;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class GunnerHandgunAI
extends CustomizedAIGunner {
    public static final String TAG_KEY = MineColoniesCompatibility.rl("reliquary_gunner_handgun").toString();
    public static final String TAG_DAMAGE = MineColoniesCompatibility.rl("damage").toString();

    @Override
    public boolean test(@NotNull CustomizedAIContext context) {
        return super.test(context) && context.getWeapon().m_41720_() instanceof HandgunItem;
    }

    @Override
    @NotNull
    public String getTagKey() {
        return TAG_KEY;
    }

    public ReliquaryConfig.JobConfig.GunnerHandgunConfig getWeaponConfig() {
        return MineColoniesCompatibilityConfigServer.INSTANCE.modules.reliquary.job.gunnerHandgun;
    }

    @Override
    protected boolean testAmmo(ItemStack stack) {
        MagazineItem item;
        Item item2 = stack.m_41720_();
        return item2 instanceof MagazineItem && (item = (MagazineItem)item2) != ModItems.EMPTY_MAGAZINE.get();
    }

    @Override
    protected IDeliverableObject createAmmoRequest(int minCount) {
        return new Magazine(minCount);
    }

    @Override
    protected boolean isAmmoRequest(IDeliverableObject object) {
        return object instanceof Magazine;
    }

    @Override
    protected int getAmmoMinCount() {
        return 2;
    }

    @Override
    protected AttackDelayConfig getAttackDealyConfig() {
        return this.getWeaponConfig().attackDelay;
    }

    @Override
    protected int getReloadDuration() {
        return (Integer)this.getWeaponConfig().reloadDuration.get();
    }

    @Override
    protected boolean isNeedRequestAmmo(@NotNull AbstractEntityCitizen user) {
        return super.isNeedRequestAmmo(user) && this.getBulletCount(user) <= 0;
    }

    @Override
    public boolean canAttack(@NotNull CustomizedAIContext context, @NotNull LivingEntity target) {
        if (!super.canAttack(context, target)) {
            return false;
        }
        AbstractEntityCitizen user = context.getUser();
        InventoryCitizen inventory = user.getInventoryCitizen();
        int magazineSlot = this.getAmmoSlot((IItemHandler)inventory);
        if (this.getBulletCount(user) <= 0 || magazineSlot > -1 && this.getMagazineType(user).isEmpty()) {
            if (magazineSlot > -1) {
                ItemStack magazine = inventory.extractItem(magazineSlot, 1, false);
                this.setMagazineType(user, ForgeRegistries.ITEMS.getKey((Object)magazine.m_41720_()).toString());
                this.setPotionEffects(user, XRPotionHelper.getPotionEffectsFromStack((ItemStack)magazine));
                this.insertItem(user, (IItemHandler)inventory, new ItemStack((ItemLike)ModItems.EMPTY_MAGAZINE.get()));
            } else if (((BulletMode)((Object)this.getJobConfig().bulletMode.get())).canDefault()) {
                this.setMagazineType(user, "");
                this.setPotionEffects(user, Collections.emptyList());
            } else {
                return false;
            }
            this.setBulletCount(user, 8);
            if (!this.reload(user)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void onReloadStarted(@NotNull AbstractEntityCitizen user) {
        super.onReloadStarted(user);
        user.m_5496_((SoundEvent)ModSounds.HANDGUN_LOAD.get(), 0.25f, 1.0f);
    }

    @Override
    public void doAttack(@NotNull CustomizedAIContext context, @NotNull LivingEntity target) {
        AbstractEntityCitizen user = context.getUser();
        ItemStack weapon = context.getWeapon();
        String magazineType = this.getMagazineType(user);
        Map<String, HandgunItem.IShotEntityFactory> magazineShotFactories = ((HandgunItemAccessor)weapon.m_41720_()).getMagazineShotFactories();
        HandgunItem.IShotEntityFactory shotfactory = null;
        if (magazineType.isEmpty()) {
            shotfactory = (level, player, hand) -> {
                NeutralShotEntity shot = new NeutralShotEntity(level, player, hand);
                double damage = this.getWeaponConfig().defaultBulletDamage.apply(user, this.getPrimarySkillLevel(user));
                shot.getPersistentData().m_128405_(TAG_DAMAGE, (int)damage);
                return shot;
            };
        } else if (magazineShotFactories.containsKey(magazineType)) {
            shotfactory = magazineShotFactories.get(magazineType);
        }
        if (shotfactory != null) {
            ServerLevel level2 = (ServerLevel)user.m_9236_();
            FakePlayer player2 = FakePlayerFactory.getMinecraft((ServerLevel)level2);
            player2.m_146884_(user.m_20182_());
            player2.m_146926_(user.m_146909_());
            player2.m_146922_(user.m_146908_());
            List<MobEffectInstance> potionEffects = this.getPotionEffects(user);
            ShotEntityBase shot = shotfactory.createShot((Level)level2, (Player)player2, InteractionHand.MAIN_HAND).addPotionEffects(potionEffects);
            float motionX = -Mth.m_14031_((float)(player2.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(player2.m_146909_() / 180.0f * (float)Math.PI));
            float motionZ = Mth.m_14089_((float)(player2.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(player2.m_146909_() / 180.0f * (float)Math.PI));
            float motionY = -Mth.m_14031_((float)(player2.m_146909_() / 180.0f * (float)Math.PI));
            shot.m_6686_((double)motionX, (double)motionY, (double)motionZ, 1.2f, 1.0f);
            level2.m_7967_((Entity)shot);
            user.m_5496_((SoundEvent)ModSounds.HANDGUN_SHOT.get(), 0.5f, 1.2f);
        } else {
            user.m_5496_((SoundEvent)SoundEvents.f_12215_.get(), 1.0f, 1.0f);
        }
        if (!magazineType.isEmpty()) {
            this.insertItem(user, (IItemHandler)user.getInventoryCitizen(), new ItemStack((ItemLike)ModItems.EMPTY_BULLET.get()));
        }
        this.setBulletCount(user, this.getBulletCount(user) - 1);
    }

    public int getBulletCount(@NotNull AbstractEntityCitizen user) {
        return this.getOrEmptyTag(user).m_128451_("bulletCount");
    }

    public void setBulletCount(@NotNull AbstractEntityCitizen user, int count) {
        this.getOrCreateTag(user).m_128405_("bulletCount", Math.max(count, 0));
    }

    public String getMagazineType(@NotNull AbstractEntityCitizen user) {
        return this.getOrEmptyTag(user).m_128461_("magazineType");
    }

    public void setMagazineType(@NotNull AbstractEntityCitizen user, String magazine) {
        this.getOrCreateTag(user).m_128359_("magazineType", magazine);
    }

    public void setPotionEffects(@NotNull AbstractEntityCitizen user, List<MobEffectInstance> effects) {
        CompoundTag tag = new CompoundTag();
        XRPotionHelper.addPotionEffectsToCompoundTag((CompoundTag)tag, effects);
        this.getOrCreateTag(user).m_128365_("potionEffects", (Tag)tag);
    }

    public List<MobEffectInstance> getPotionEffects(@NotNull AbstractEntityCitizen user) {
        CompoundTag tag = this.getOrEmptyTag(user).m_128469_("potionEffects");
        return XRPotionHelper.getPotionEffectsFromCompoundTag((CompoundTag)tag);
    }
}

