/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.pamhc2trees;

import com.pam.pamhc2trees.blocks.BlockPamFruit;
import com.pam.pamhc2trees.blocks.BlockPamLogFruit;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class PamFruit
extends CustomizedFruit {
    private final Block block;
    private final Block sapling;
    private final Item fruit;

    public PamFruit(Block block, Block sapling, Item fruit) {
        this.block = block;
        this.sapling = sapling;
        this.fruit = fruit;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ForgeRegistries.BLOCKS.getKey((Object)this.block);
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.sapling), new ItemStack((ItemLike)this.block));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.fruit));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == this.block;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        BlockPamLogFruit logFruit;
        BlockPamFruit fruit;
        BlockState state = context.getState();
        Block block = state.m_60734_();
        if (block instanceof BlockPamFruit && (fruit = (BlockPamFruit)block).isMaxAge(state)) {
            return true;
        }
        return block instanceof BlockPamLogFruit && (logFruit = (BlockPamLogFruit)block).isMaxAge(state);
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            BlockState newState = context.getState().m_60734_().m_49966_();
            level.m_7731_(context.getPosition(), newState, 2);
        }
        return context.getDrops(null);
    }
}

