/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.minecraft;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class SweetBerryFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50685_);
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)Items.f_42780_));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)Items.f_42780_));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == Blocks.f_50685_;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)SweetBerryBushBlock.f_57244_) > 1;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)SweetBerryBushBlock.f_57244_) == 3;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            Integer age = (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_);
            int count = 1 + level.f_46441_.m_188503_(2) + (age == 3 ? 1 : 0);
            level.m_7731_(context.getPosition(), (BlockState)state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
            return Collections.singletonList(new ItemStack((ItemLike)Items.f_42780_, count));
        }
        return Collections.emptyList();
    }
}

