/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.menu;

import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import steve_gall.minecolonies_compatibility.api.common.inventory.GhostSlot;
import steve_gall.minecolonies_compatibility.core.common.crafting.IngredientHelper;
import steve_gall.minecolonies_compatibility.core.common.inventory.ReadOnlySlotsContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleCraftingTypes;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleMenuTypes;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class TeachCuttingMenu
extends TeachRecipeMenu<CuttingBoardRecipe, RecipeWrapper> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_SLOTS = 1;
    public static final int CRAFTING_COLS = 1;
    public static final int CRAFTING_X = 14;
    public static final int CRAFTING_Y = 36;
    public static final int RESULT_X = 73;
    public static final int RESULT_Y = 18;
    public static final int RESULT_COLUMNS = 5;
    private final IToolType toolType;
    private List<ChanceResult> results;

    public TeachCuttingMenu(int windowId, Inventory inventory, BlockPos buildingId, int moduleId, IToolType toolType) {
        super((MenuType)ModuleMenuTypes.TEACH_CUTTING.get(), windowId, inventory, buildingId, moduleId);
        this.toolType = toolType;
        this.setup();
    }

    public TeachCuttingMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.TEACH_CUTTING.get(), windowId, inventory, buffer);
        this.toolType = ToolType.getToolType((String)buffer.m_130277_());
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 1, 1);
        for (int i2 = 0; i2 < 1; ++i2) {
            int col = i2 % 1;
            int row = i2 / 1;
            this.craftSlots.add(this.m_38897_(new GhostSlot((Container)this.craftMatrix, i2, 14 + col * 18, 36 + row * 18){

                public boolean m_5857_(ItemStack stack) {
                    return true;
                }

                public boolean m_8010_(Player stack) {
                    return false;
                }
            }));
        }
        this.results = new ArrayList<ChanceResult>();
        this.resultContainer = new ReadOnlySlotsContainer(this.results::size, i -> this.results.get(i).getStack());
    }

    @Override
    public void onRecipeTransfer(CuttingBoardRecipe recipe, CompoundTag tag) {
        super.onRecipeTransfer(recipe, tag);
        ((Slot)this.craftSlots.get(0)).m_5852_(ItemStack.m_41712_((CompoundTag)tag));
    }

    @Override
    protected void onSetRecipe(CuttingBoardRecipe recipe) {
        int prevSlots = this.resultSlots.size();
        this.results.clear();
        if (recipe != null && this.testRecipe(recipe)) {
            this.recipe = recipe;
            this.results.addAll((Collection<ChanceResult>)((CuttingBoardRecipe)this.recipe).getRollableResults());
        } else {
            this.recipe = null;
        }
        int addingSlots = this.results.size() - prevSlots;
        for (int i = 0; i < addingSlots; ++i) {
            int index = prevSlots + i;
            int xi = index % 5;
            int yi = index / 5;
            int x = 73 + xi * 18;
            int y = 18 + yi * 18;
            this.resultSlots.add(this.m_38897_(new Slot(this.resultContainer, index, x, y){

                public boolean m_8010_(Player player) {
                    return false;
                }

                public boolean m_6659_() {
                    return !this.m_7993_().m_41619_();
                }
            }));
        }
    }

    public boolean testRecipe(CuttingBoardRecipe recipe) {
        return ItemStackHelper.isTool(IngredientHelper.getStacks(recipe.getTool()), this.getToolType());
    }

    @Override
    public RecipeType<CuttingBoardRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.CUTTING.get();
    }

    @Override
    public CraftingType getCraftingType() {
        return (CraftingType)ModuleCraftingTypes.CUTTING.get();
    }

    @Override
    protected RecipeWrapper createRecipeContainer(CraftingContainer craftContainer) {
        return new RecipeWrapper((IItemHandlerModifiable)new InvWrapper((Container)craftContainer));
    }

    public IToolType getToolType() {
        return this.toolType;
    }

    public List<ChanceResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }
}

