/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.menu;

import com.minecolonies.api.crafting.registry.CraftingType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import steve_gall.minecolonies_compatibility.api.common.inventory.GhostSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.ReadOnlySlotsContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleCraftingTypes;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleMenuTypes;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class TeachCookingMenu
extends TeachRecipeMenu<CookingPotRecipe, RecipeWrapper> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_SLOTS = 6;
    public static final int CRAFTING_COLS = 3;
    public static final int CRAFTING_X = 26;
    public static final int CRAFTING_Y = 17;
    public static final int CRAFTING_COLUMNS = 3;
    public static final int CRAFTING_ROW = 2;
    public static final int RESULT_X = 130;
    public static final int RESULT_Y = 30;
    public static final int CONTAINER_X = 88;
    public static final int CONTAINER_Y = 45;

    public TeachCookingMenu(int windowId, Inventory inventory, BlockPos buildingId, int moduleId) {
        super((MenuType)ModuleMenuTypes.TEACH_COOKING.get(), windowId, inventory, buildingId, moduleId);
        this.setup();
    }

    public TeachCookingMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.TEACH_COOKING.get(), windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 2);
        for (int i2 = 0; i2 < 6; ++i2) {
            int col = i2 % 3;
            int row = i2 / 3;
            this.craftSlots.add(this.m_38897_(new GhostSlot((Container)this.craftMatrix, i2, 26 + col * 18, 17 + row * 18){

                public boolean m_5857_(ItemStack stack) {
                    return true;
                }

                public boolean m_8010_(Player stack) {
                    return false;
                }
            }));
        }
        this.resultContainer = new ReadOnlySlotsContainer(this.resultSlots::size, i -> {
            if (this.recipe == null) {
                return ItemStack.f_41583_;
            }
            if (i == 0) {
                return ((CookingPotRecipe)this.recipe).m_8043_(this.inventory.f_35978_.m_9236_().m_9598_());
            }
            if (i == 1) {
                return ((CookingPotRecipe)this.recipe).getOutputContainer();
            }
            return ItemStack.f_41583_;
        });
        this.resultSlots.add(this.m_38897_(new Slot(this.resultContainer, 0, 130, 30)));
        this.resultSlots.add(this.m_38897_(new Slot(this.resultContainer, 1, 88, 45)));
    }

    @Override
    public void onRecipeTransfer(CookingPotRecipe recipe, CompoundTag tag) {
        super.onRecipeTransfer(recipe, tag);
        List<ItemStack> input = NBTUtils2.deserializeList(tag, "input", ItemStack::m_41712_);
        for (int i = 0; i < 6; ++i) {
            ((Slot)this.craftSlots.get(i)).m_5852_(i < input.size() ? input.get(i) : ItemStack.f_41583_);
        }
    }

    @Override
    protected void onSetRecipe(CookingPotRecipe recipe) {
        this.recipe = recipe;
        ((Slot)this.resultSlots.get(0)).m_5852_(recipe != null ? recipe.m_8043_(this.inventory.f_35978_.m_9236_().m_9598_()) : ItemStack.f_41583_);
    }

    @Override
    public RecipeType<CookingPotRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.COOKING.get();
    }

    @Override
    public CraftingType getCraftingType() {
        return (CraftingType)ModuleCraftingTypes.COOKING.get();
    }

    @Override
    protected RecipeWrapper createRecipeContainer(CraftingContainer craftContainer) {
        return new RecipeWrapper((IItemHandlerModifiable)new InvWrapper((Container)craftContainer));
    }
}

