/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.entity.ai;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.colony.jobs.JobCook;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAISkill;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.crafting.ItemStorageHelper;
import steve_gall.minecolonies_compatibility.core.common.item.ItemHandlerHelper2;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.building.module.CookingCraftingModule;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CookingRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.entity.ai.FarmersCookAIState;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.job.JobFarmersCook;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizableRecipeStorage;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class EntityAIWorkFarmersCook
extends AbstractEntityAISkill<JobFarmersCook, BuildingCook> {
    public static final int SATURATION_TO_SERVE = 16;
    public static final double BASE_XP_GAIN = 2.0;
    public static final int LEVEL_TO_FEED_PLAYER = 10;
    public static final VisibleCitizenStatus COOK_ICON = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/cook.png"), "com.minecolonies.gui.visiblestatus.cook");
    private CookingRecipeStorage selectedRecipe = null;
    private BlockPos cookingPotPosition = null;
    private final List<ItemStorage> needsStorages = new ArrayList<ItemStorage>();
    private final Map<ItemStorage, AtomicInteger> totalNeeds = new HashMap<ItemStorage, AtomicInteger>();
    private final List<IRecipeStorage> availableRecipes = new ArrayList<IRecipeStorage>();
    private final List<AbstractEntityCitizen> citizenToServe = new ArrayList<AbstractEntityCitizen>();
    private final List<Player> playerToServe = new ArrayList<Player>();
    private Set<ItemStorage> reservedItemCache = new HashSet<ItemStorage>();

    public EntityAIWorkFarmersCook(@NotNull JobFarmersCook job) {
        super((AbstractJob)job);
        super.registerTargets(new TickingTransition[]{new AITarget((IState)AIWorkerState.IDLE, (IState)AIWorkerState.START_WORKING, 5), new AITarget((IState)AIWorkerState.START_WORKING, this::startWorking, 5), new AITarget((IState)FarmersCookAIState.INSERT_INPUT, this::insertInput, 5), new AITarget((IState)FarmersCookAIState.EXTRACT_OUTPUT, this::extractOutput, 5), new AITarget((IState)AIWorkerState.COOK_SERVE_FOOD_TO_CITIZEN, this::serveFood, 30), new AIEventTarget(AIBlockingEventType.AI_BLOCKING, this::accelerateCookingPots, 20)});
        this.worker.m_21553_(true);
    }

    public IAIState startWorking() {
        this.cookingPotPosition = null;
        if (this.walkToBuilding()) {
            return this.getState();
        }
        ICitizenData citizen = this.worker.getCitizenData();
        citizen.setVisibleStatus(VisibleCitizenStatus.WORKING);
        CookingCraftingModule cookingModule = (CookingCraftingModule)((BuildingCook)this.building).getFirstModuleOccurance(CookingCraftingModule.class);
        cookingModule.requestFindWorkingBlocks(this.worker);
        List<BlockPos> cookingPots = cookingModule.getWorkingBlocks((LevelReader)this.world).toList();
        if (cookingPots.size() == 0) {
            citizen.triggerInteraction((IInteractionResponseHandler)new StandardInteraction(cookingModule.getWorkingBlockNotFoundMessage(), (IChatPriority)ChatPriority.BLOCKING));
            return AIWorkerState.START_WORKING;
        }
        IAIState checkCompleted = this.checkCompletedCookingPots(cookingPots);
        if (checkCompleted != null) {
            return checkCompleted;
        }
        IAIState checkServe = this.checkNeedServe();
        if (checkServe != null) {
            return checkServe;
        }
        if (cookingModule.getRecipes().size() == 0) {
            citizen.triggerInteraction((IInteractionResponseHandler)new StandardInteraction((Component)Component.m_237115_((String)"minecolonies_compatibility.interaction.no_farmers_cooking_recipe"), (IChatPriority)ChatPriority.BLOCKING));
            this.walkToBuilding();
            return this.getState();
        }
        IAIState checkIdling = this.checkIdlingCookingPots(cookingPots);
        if (checkIdling != null) {
            return checkIdling;
        }
        return AIWorkerState.START_WORKING;
    }

    protected IAIState checkCompletedCookingPots(List<BlockPos> cookingPots) {
        BlockEntity blockEntity;
        Optional<BlockPos> completedPosition = this.findCompletedCookingPots(cookingPots).findAny();
        if (completedPosition.isPresent() && (blockEntity = this.world.m_7702_(completedPosition.get())) instanceof CookingPotBlockEntity) {
            CookingPotBlockEntity cookingPot = (CookingPotBlockEntity)blockEntity;
            ItemStackHandler potInventory = cookingPot.getInventory();
            if (potInventory.getStackInSlot(8).m_41619_()) {
                this.needsStorages.add(new ItemStorage(cookingPot.getContainer()));
            }
            this.cookingPotPosition = completedPosition.get();
            return FarmersCookAIState.EXTRACT_OUTPUT;
        }
        return null;
    }

    protected IAIState checkNeedServe() {
        this.citizenToServe.clear();
        this.playerToServe.clear();
        boolean hasFoodInBuilding = false;
        InventoryCitizen ownInventory = this.worker.getInventoryCitizen();
        for (EntityCitizen citizen : WorldUtil.getEntitiesWithinBuilding((Level)this.world, EntityCitizen.class, (IBuilding)this.building, null)) {
            IJob job = citizen.getCitizenJobHandler().getColonyJob();
            if (job instanceof JobCook || job instanceof JobFarmersCook || !this.shouldBeFed((AbstractEntityCitizen)citizen) || InventoryUtils.hasItemInItemHandler((IItemHandler)citizen.getItemHandlerCitizen(), stack -> ItemStackUtils.CAN_EAT.test(stack) && this.canEat((LivingEntity)citizen, (ItemStack)stack))) continue;
            Predicate<ItemStack> foodPredicate = stack -> ItemStackUtils.CAN_EAT.test(stack) && this.canEat((LivingEntity)citizen, (ItemStack)stack) && !this.isItemStackForAssistant((ItemStack)stack);
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)ownInventory, foodPredicate)) {
                this.citizenToServe.add((AbstractEntityCitizen)citizen);
                continue;
            }
            if (!InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, foodPredicate)) continue;
            hasFoodInBuilding = true;
            this.needsCurrently = new Tuple(foodPredicate, (Object)64);
        }
        for (Player player : WorldUtil.getEntitiesWithinBuilding((Level)this.world, Player.class, (IBuilding)this.building, null)) {
            if (player.m_36324_().m_38702_() >= 10 || !((BuildingCook)this.building).getColony().getPermissions().hasPermission(player, Action.MANAGE_HUTS) || InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), stack -> ItemStackUtils.CAN_EAT.test(stack) && this.canEat((LivingEntity)player, (ItemStack)stack))) continue;
            Predicate<ItemStack> foodPredicate = stack -> ItemStackUtils.CAN_EAT.test(stack) && !this.isItemStackForAssistant((ItemStack)stack);
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)ownInventory, foodPredicate)) {
                this.playerToServe.add(player);
                continue;
            }
            if (!InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, foodPredicate)) continue;
            hasFoodInBuilding = true;
            this.needsCurrently = new Tuple(foodPredicate, (Object)64);
        }
        if (hasFoodInBuilding) {
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (!this.citizenToServe.isEmpty() || !this.playerToServe.isEmpty()) {
            return AIWorkerState.COOK_SERVE_FOOD_TO_CITIZEN;
        }
        return null;
    }

    protected IAIState checkIdlingCookingPots(List<BlockPos> cookingPots) {
        Optional<BlockPos> idlingPosition = this.findIdlingCookingPots(cookingPots).findAny();
        if (idlingPosition.isPresent()) {
            this.selectedRecipe = null;
            this.requestTotalNeeds();
            if (this.availableRecipes.size() > 0) {
                CookingRecipeStorage r2;
                ICustomizableRecipeStorage r1;
                ICustomizedRecipeStorage iCustomizedRecipeStorage;
                IRecipeStorage recipe = this.availableRecipes.get(0);
                this.selectedRecipe = recipe instanceof ICustomizableRecipeStorage && (iCustomizedRecipeStorage = (r1 = (ICustomizableRecipeStorage)recipe).getImpl()) instanceof CookingRecipeStorage ? (r2 = (CookingRecipeStorage)iCustomizedRecipeStorage) : null;
                this.needsStorages.addAll(recipe.getCleanedInput());
                this.cookingPotPosition = idlingPosition.get();
                return FarmersCookAIState.INSERT_INPUT;
            }
        }
        return null;
    }

    protected IAIState insertInput() {
        CookingPotBlockEntity cookingPot;
        if (this.cookingPotPosition == null || this.selectedRecipe == null) {
            return AIWorkerState.START_WORKING;
        }
        IAIState getNeeds = this.getNeeds();
        if (getNeeds != null) {
            return getNeeds;
        }
        if (this.walkToBlock(this.cookingPotPosition) || this.hasNotDelayed(5)) {
            return this.getState();
        }
        AbstractEntityCitizen worker = this.worker;
        CookingRecipeStorage recipe = this.selectedRecipe;
        InventoryCitizen ownInventory = worker.getInventoryCitizen();
        IToolType requiredTool = recipe.getRequiredTool();
        int toolSlot = -1;
        if (requiredTool != ToolType.NONE) {
            toolSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)ownInventory, stack -> ItemStackUtils.isTool((ItemStack)stack, (IToolType)requiredTool));
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (toolSlot != -1) {
            ownInventory.setHeldItem(hand, toolSlot);
            worker.m_21008_(hand, ownInventory.getStackInSlot(toolSlot));
        } else {
            worker.m_21008_(hand, ItemStack.f_41583_);
        }
        BlockEntity blockEntity = this.world.m_7702_(this.cookingPotPosition);
        if (blockEntity instanceof CookingPotBlockEntity && this.isIdling(cookingPot = (CookingPotBlockEntity)blockEntity)) {
            ItemStackHandler potInventory = cookingPot.getInventory();
            this.extractFromPotInventory((IItemHandlerModifiable)potInventory);
            if (!this.insertIntoPotInventory((IItemHandlerModifiable)potInventory, recipe)) {
                this.extractFromPotInventory((IItemHandlerModifiable)potInventory);
            }
        }
        return AIWorkerState.START_WORKING;
    }

    protected IAIState extractOutput() {
        if (this.cookingPotPosition == null) {
            return AIWorkerState.START_WORKING;
        }
        IAIState getNeeds = this.getNeeds();
        if (getNeeds != null) {
            return getNeeds;
        }
        if (this.walkToBlock(this.cookingPotPosition) || this.hasNotDelayed(5)) {
            return this.getState();
        }
        BlockEntity blockEntity = this.world.m_7702_(this.cookingPotPosition);
        if (blockEntity instanceof CookingPotBlockEntity) {
            CookingPotBlockEntity cookingPot = (CookingPotBlockEntity)blockEntity;
            ItemStackHandler potInventory = cookingPot.getInventory();
            ItemStack output = potInventory.getStackInSlot(8);
            if (!output.m_41619_() && InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)potInventory, (int)8, (IItemHandler)this.getInventory())) {
                this.worker.getCitizenExperienceHandler().addExperience(2.0);
                this.incrementActionsDoneAndDecSaturation();
                return AIWorkerState.INVENTORY_FULL;
            }
            ItemStack container = cookingPot.getContainer();
            if (!container.m_41619_()) {
                this.extractOrThrow((IItemHandlerModifiable)potInventory, 7);
                if (ItemHandlerHelper2.move(this.worker.getItemHandlerCitizen(), (IItemHandlerModifiable)potInventory, 7, Arrays.asList(new ItemStorage(container)))) {
                    return this.getState();
                }
            }
        }
        return AIWorkerState.START_WORKING;
    }

    protected IAIState getNeeds() {
        List<ItemStorage> needs = this.needsStorages;
        while (needs.size() > 0) {
            ItemStorage need = needs.get(0);
            int countInInventory = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStorageHelper.matches(need, stack, true));
            int countInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, (ItemStorage)need);
            if (countInInventory >= need.getAmount()) {
                needs.remove(0);
                continue;
            }
            if (countInInventory + countInBuilding >= need.getAmount()) {
                this.needsCurrently = new Tuple(stack -> ItemStorageHelper.matches(need, stack, false), (Object)need.getAmount());
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            return AIWorkerState.START_WORKING;
        }
        return null;
    }

    protected IAIState serveFood() {
        InventoryCitizen handler;
        AbstractEntityCitizen living;
        List<AbstractEntityCitizen> list;
        if (this.citizenToServe.isEmpty() && this.playerToServe.isEmpty()) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(COOK_ICON);
        Player player = null;
        AbstractEntityCitizen citizen = null;
        List<Object> list2 = list = this.playerToServe.isEmpty() ? this.citizenToServe : this.playerToServe;
        if (list == this.citizenToServe) {
            living = citizen = this.citizenToServe.get(0);
            handler = citizen.getInventoryCitizen();
        } else {
            player = this.playerToServe.get(0);
            living = player;
            handler = new InvWrapper((Container)player.m_150109_());
        }
        if (!((BuildingCook)this.building).isInBuilding(living.m_20183_()) || living.m_21224_()) {
            list.remove(0);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(living.m_20183_())) {
            return this.getState();
        }
        InventoryCitizen ownInventory = this.worker.getInventoryCitizen();
        IColony colony = this.worker.getCitizenColonyHandler().getColony();
        if (InventoryUtils.isItemHandlerFull((IItemHandler)handler)) {
            int foodSlot;
            if (citizen != null && (foodSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)handler, arg_0 -> this.lambda$serveFood$7((LivingEntity)living, arg_0))) != -1) {
                ItemStack stack = ownInventory.extractItem(foodSlot, 1, true);
                if (stack.m_41614_()) {
                    ownInventory.extractItem(foodSlot, 1, false);
                    citizen.getCitizenData().increaseSaturation((double)stack.m_41720_().getFoodProperties(stack, (LivingEntity)this.worker).m_38744_() * 0.5);
                }
                colony.getStatisticsManager().increment("food_served", colony.getDay());
            }
            list.remove(0);
            return this.getState();
        }
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)handler, arg_0 -> this.lambda$serveFood$8((LivingEntity)living, arg_0))) {
            list.remove(0);
            return this.getState();
        }
        int foodCount = InventoryUtils.transferFoodUpToSaturation((ICapabilityProvider)this.worker, (IItemHandler)handler, (int)(((BuildingCook)this.building).getBuildingLevel() * 16), arg_0 -> this.lambda$serveFood$9((LivingEntity)living, arg_0));
        if (foodCount <= 0) {
            list.remove(0);
            return this.getState();
        }
        colony.getStatisticsManager().incrementBy("food_served", foodCount, this.worker.getCitizenColonyHandler().getColony().getDay());
        if (player != null) {
            MessageUtils.format((String)"com.minecolonies.coremod.cook.serve.player", (Object[])new Object[]{this.worker.m_7755_().getString()}).sendTo(new Player[]{player});
        }
        list.remove(0);
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.START_WORKING;
    }

    protected IAIState accelerateCookingPots() {
        int skillLevel = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getPrimarySkill());
        int accelerationTicks = (int)((double)skillLevel * (Double)MineColoniesCompatibilityConfigServer.INSTANCE.jobs.farmersCook.acceleratePerSkillLevel.get());
        Level world = ((BuildingCook)this.building).getColony().getWorld();
        CookingCraftingModule cookingModule = (CookingCraftingModule)((BuildingCook)this.building).getFirstModuleOccurance(CookingCraftingModule.class);
        List cookingPots = cookingModule.getWorkingBlocks((LevelReader)this.world).toList();
        for (BlockPos pos : cookingPots) {
            BlockEntity blockEntity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, (BlockPos)pos) || !((blockEntity = world.m_7702_(pos)) instanceof CookingPotBlockEntity)) continue;
            CookingPotBlockEntity cookingPot = (CookingPotBlockEntity)blockEntity;
            for (int i = 0; i < accelerationTicks; ++i) {
                CookingPotBlockEntity.cookingTick((Level)world, (BlockPos)pos, (BlockState)world.m_8055_(pos), (CookingPotBlockEntity)cookingPot);
            }
        }
        return null;
    }

    protected void requestTotalNeeds() {
        this.totalNeeds.clear();
        this.availableRecipes.clear();
        CookingCraftingModule cookingModule = (CookingCraftingModule)((BuildingCook)this.building).getFirstModuleOccurance(CookingCraftingModule.class);
        InventoryCitizen ownInventory = this.worker.getInventoryCitizen();
        for (IToken iToken : cookingModule.getRecipes()) {
            int countInBuilding;
            if (cookingModule.isDisabled(iToken)) continue;
            IRecipeStorage recipe = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get((Object)iToken);
            boolean isReady = true;
            ItemStorage output = new ItemStorage(recipe.getPrimaryOutput());
            int countInInventory = InventoryUtils.getItemCountInItemHandler((IItemHandler)ownInventory, stack -> ItemStorageHelper.matches(output, stack, true));
            if (countInInventory + (countInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, (ItemStorage)output)) >= output.getItemStack().m_41741_()) continue;
            for (ItemStorage ingredient : recipe.getCleanedInput()) {
                int countInInventory2 = InventoryUtils.getItemCountInItemHandler((IItemHandler)ownInventory, stack -> ItemStorageHelper.matches(ingredient, stack, true));
                int countInBuilding2 = InventoryUtils.getCountFromBuilding((IBuilding)this.building, (ItemStorage)ingredient);
                int needCount = ingredient.getAmount() - (countInInventory2 + countInBuilding2);
                if (needCount <= 0) continue;
                isReady = false;
                AtomicInteger totallyNeedCount = this.totalNeeds.computeIfAbsent(ingredient, i -> new AtomicInteger());
                if (needCount <= totallyNeedCount.get()) continue;
                totallyNeedCount.set(needCount);
            }
            if (!isReady) continue;
            this.availableRecipes.add(recipe);
        }
        for (Map.Entry entry : this.totalNeeds.entrySet()) {
            ItemStorage storage = (ItemStorage)entry.getKey();
            this.checkIfRequestForItemExistOrCreateAsync(storage.getItemStack(), ((AtomicInteger)entry.getValue()).get(), 1, !storage.ignoreDamageValue());
        }
    }

    protected boolean shouldBeFed(AbstractEntityCitizen citizen) {
        ICitizenData citizenData = citizen.getCitizenData();
        return citizenData != null && !citizenData.isWorking() && citizenData.getSaturation() <= 10.0 && !citizenData.justAte();
    }

    protected boolean canEat(LivingEntity entity, ItemStack stack) {
        AbstractEntityCitizen citizen;
        IBuilding building;
        ItemListModule foodExclusionListModule = (ItemListModule)this.worker.getCitizenData().getWorkBuilding().getModuleMatching(ItemListModule.class, m -> m.getId().equals("food"));
        if (foodExclusionListModule.isItemInList(new ItemStorage(stack))) {
            return false;
        }
        if (entity instanceof AbstractEntityCitizen && (building = (citizen = (AbstractEntityCitizen)entity).getCitizenData().getWorkBuilding()) != null) {
            return building.canEat(stack);
        }
        return true;
    }

    protected boolean isItemStackForAssistant(ItemStack stack) {
        if (this.reservedItemCache.isEmpty()) {
            this.reservedItemCache.addAll(((BuildingCook.CraftingModule)((BuildingCook)this.building).getModule(BuildingModules.COOKASSISTENT_CRAFT)).reservedStacks().keySet());
        }
        return this.reservedItemCache.contains(new ItemStorage(stack));
    }

    protected boolean insertIntoPotInventory(IItemHandlerModifiable potInventory, CookingRecipeStorage recipe) {
        InventoryCitizen ownInventory = this.worker.getInventoryCitizen();
        if (!ItemHandlerHelper2.move((IItemHandler)ownInventory, potInventory, 0, recipe.getIngredients())) {
            return false;
        }
        return recipe.getContainer().isEmpty() || ItemHandlerHelper2.move((IItemHandler)ownInventory, potInventory, 7, Arrays.asList(recipe.getContainer()));
    }

    protected void extractFromPotInventory(IItemHandlerModifiable potInventory) {
        for (int i = 0; i < 6; ++i) {
            this.extractOrThrow(potInventory, i);
        }
        this.extractOrThrow(potInventory, 7);
    }

    protected void extractOrThrow(IItemHandlerModifiable potInventory, int potSot) {
        if (!InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)potInventory, (int)potSot, (IItemHandler)this.worker.getInventoryCitizen())) {
            ItemStack remained = potInventory.extractItem(potSot, Integer.MAX_VALUE, false).m_41777_();
            BehaviorUtils.m_22613_((LivingEntity)this.worker, (ItemStack)remained, (Vec3)this.worker.m_20182_());
        }
    }

    public Stream<BlockPos> findCompletedCookingPots(List<BlockPos> positions) {
        return positions.stream().filter(pos -> {
            CookingPotBlockEntity cookingPot;
            BlockEntity patt22262$temp = this.world.m_7702_(pos);
            return patt22262$temp instanceof CookingPotBlockEntity && this.isCompleted(cookingPot = (CookingPotBlockEntity)patt22262$temp);
        });
    }

    public boolean isCompleted(CookingPotBlockEntity cookingPot) {
        ItemStackHandler potInventory = cookingPot.getInventory();
        ItemStack output = potInventory.getStackInSlot(8);
        ItemStack display = potInventory.getStackInSlot(6);
        return !output.m_41619_() || !display.m_41619_();
    }

    public Stream<BlockPos> findHeatedCookingPots(List<BlockPos> positions) {
        return positions.stream().filter(pos -> {
            CookingPotBlockEntity cookingPot;
            BlockEntity patt22860$temp = this.world.m_7702_(pos);
            return patt22860$temp instanceof CookingPotBlockEntity && (cookingPot = (CookingPotBlockEntity)patt22860$temp).isHeated();
        });
    }

    public Stream<BlockPos> findIdlingCookingPots(List<BlockPos> positions) {
        return positions.stream().filter(pos -> {
            CookingPotBlockEntity cookingPot;
            BlockEntity patt23111$temp = this.world.m_7702_(pos);
            return patt23111$temp instanceof CookingPotBlockEntity && this.isIdling(cookingPot = (CookingPotBlockEntity)patt23111$temp);
        });
    }

    public boolean isIdling(CookingPotBlockEntity cookingPot) {
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)cookingPot.getInventory());
        return this.world.m_7465_().m_44015_((RecipeType)ModRecipeTypes.COOKING.get(), (Container)wrapper, this.world).isEmpty();
    }

    public Class<BuildingCook> getExpectedBuildingClass() {
        return BuildingCook.class;
    }

    private /* synthetic */ boolean lambda$serveFood$9(LivingEntity living, ItemStack stack) {
        return ItemStackUtils.CAN_EAT.test(stack) && this.canEat(living, stack);
    }

    private /* synthetic */ boolean lambda$serveFood$8(LivingEntity living, ItemStack stack) {
        return ItemStackUtils.CAN_EAT.test(stack) && this.canEat(living, stack);
    }

    private /* synthetic */ boolean lambda$serveFood$7(LivingEntity living, ItemStack stack) {
        return ItemStackUtils.CAN_EAT.test(stack) && this.canEat(living, stack);
    }
}

