/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.GenericedRecipeStorage;
import steve_gall.minecolonies_compatibility.api.common.crafting.ISecondaryRollableRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.crafting.ItemStorageHelper;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingChanceResult;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingGenericRecipe;

public class CuttingRecipeStorage
extends GenericedRecipeStorage<CuttingGenericRecipe>
implements ISecondaryRollableRecipeStorage {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("farmerdelight_cutting");
    private final ResourceLocation recipeId;
    private final List<ItemStorage> ingreidnts;
    private final List<CuttingChanceResult> results;
    private final IToolType toolType;
    private final CuttingGenericRecipe genericRecipe;

    public static void serialize(CompoundTag tag, CuttingRecipeStorage recipe) {
        tag.m_128359_("recipeId", recipe.recipeId.toString());
        NBTUtils2.serializeList(tag, "ingreidnts", recipe.ingreidnts, arg_0 -> ((StandardFactoryController)StandardFactoryController.getInstance()).serialize(arg_0));
        NBTUtils2.serializeList(tag, "results", recipe.results, CuttingChanceResult::serializeNBT);
        tag.m_128359_("toolType", recipe.toolType.getName());
    }

    public static CuttingRecipeStorage deserialize(CompoundTag tag) {
        ResourceLocation recipeId = new ResourceLocation(tag.m_128461_("recipeId"));
        List<ItemStorage> ingreidnts = NBTUtils2.deserializeList(tag, "ingreidnts", arg_0 -> ((StandardFactoryController)StandardFactoryController.getInstance()).deserialize(arg_0));
        List<CuttingChanceResult> results = NBTUtils2.deserializeList(tag, "results", CuttingChanceResult::new);
        IToolType toolType = ToolType.getToolType((String)tag.m_128461_("toolType"));
        return new CuttingRecipeStorage(recipeId, ingreidnts, results, toolType);
    }

    public CuttingRecipeStorage(ResourceLocation recipeId, List<ItemStorage> ingreidnts, List<CuttingChanceResult> results, IToolType toolType) {
        this.recipeId = recipeId;
        this.ingreidnts = Collections.unmodifiableList(ingreidnts);
        this.results = Collections.unmodifiableList(results);
        this.toolType = toolType;
        this.genericRecipe = new CuttingGenericRecipe(recipeId, ItemStorageHelper.getStacksLists(ingreidnts), results, toolType);
    }

    @Override
    @NotNull
    public List<ItemStack> rollSecondaryOutputs(@NotNull LootParams context) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (CuttingChanceResult result : this.genericRecipe.getAdditionalResults()) {
            double roll = context.m_287182_().m_213780_().m_188500_();
            if (!(roll <= (double)result.getChance())) continue;
            list.add(result.getStack());
        }
        list.addAll(ItemStorageHelper.getCraftingRemainings(this.ingreidnts));
        return list;
    }

    public int hashCode() {
        return Objects.hash(this.recipeId, this.ingreidnts, this.results, this.toolType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CuttingRecipeStorage) {
            CuttingRecipeStorage other = (CuttingRecipeStorage)o;
            return this.recipeId.equals((Object)other.recipeId) && this.ingreidnts.equals(other.ingreidnts) && this.results.equals(other.results) && this.toolType.equals(other.toolType);
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public List<ItemStorage> getInput() {
        return this.ingreidnts;
    }

    public List<CuttingChanceResult> getResults() {
        return this.results;
    }

    @Override
    @NotNull
    protected CuttingGenericRecipe getGenericRecipe() {
        return this.genericRecipe;
    }
}

