/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.GenericedRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.crafting.ItemStorageHelper;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CookingGenericRecipe;

public class CookingRecipeStorage
extends GenericedRecipeStorage<CookingGenericRecipe> {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("farmerdelight_cooking");
    private final ResourceLocation recipeId;
    private final List<ItemStorage> ingreidnts;
    private final ItemStorage container;
    private final ItemStack output;
    private final CookingGenericRecipe genericRecipe;

    public static void serialize(CompoundTag tag, CookingRecipeStorage recipe) {
        tag.m_128359_("recipeId", recipe.recipeId.toString());
        NBTUtils2.serializeList(tag, "ingreidnts", recipe.ingreidnts, arg_0 -> ((StandardFactoryController)StandardFactoryController.getInstance()).serialize(arg_0));
        tag.m_128365_("container", (Tag)StandardFactoryController.getInstance().serialize((Object)recipe.container));
        tag.m_128365_("output", (Tag)recipe.output.serializeNBT());
    }

    public static CookingRecipeStorage deserialize(CompoundTag tag) {
        ResourceLocation recipeId = new ResourceLocation(tag.m_128461_("recipeId"));
        List<ItemStorage> ingreidnts = NBTUtils2.deserializeList(tag, "ingreidnts", arg_0 -> ((StandardFactoryController)StandardFactoryController.getInstance()).deserialize(arg_0));
        ItemStorage container = (ItemStorage)StandardFactoryController.getInstance().deserialize(tag.m_128469_("container"));
        ItemStack output = ItemStack.m_41712_((CompoundTag)tag.m_128469_("output"));
        return new CookingRecipeStorage(recipeId, ingreidnts, container, output);
    }

    public CookingRecipeStorage(ResourceLocation recipeId, List<ItemStorage> ingreidnts, ItemStorage container, ItemStack output) {
        this.recipeId = recipeId;
        this.ingreidnts = Collections.unmodifiableList(ingreidnts);
        this.container = container;
        this.output = output;
        this.genericRecipe = new CookingGenericRecipe(recipeId, ItemStorageHelper.getStacksLists(ingreidnts), ItemStorageHelper.getStacks(container), output);
    }

    public int hashCode() {
        return Objects.hash(this.recipeId, this.ingreidnts, this.container.getItem(), this.output.m_41720_());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CookingRecipeStorage) {
            CookingRecipeStorage other = (CookingRecipeStorage)o;
            return this.recipeId.equals((Object)other.recipeId) && this.ingreidnts.equals(other.ingreidnts) && this.container.equals((Object)other.container) && ItemStackHelper.equals(this.output, other.output);
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public List<ItemStorage> getInput() {
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
        input.addAll(this.ingreidnts);
        input.add(this.container);
        return input;
    }

    public List<ItemStorage> getIngredients() {
        return this.ingreidnts;
    }

    public ItemStorage getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    protected CookingGenericRecipe getGenericRecipe() {
        return this.genericRecipe;
    }
}

