/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.building.module;

import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.constant.IToolType;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.AbstractModuleWithExternalWorkingBlocks;
import steve_gall.minecolonies_compatibility.api.common.entity.pathfinding.PathJobFindWorkingBlocks;
import steve_gall.minecolonies_compatibility.api.common.entity.pathfinding.WorkingBlocksPathResult;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleCraftingTypes;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class CuttingCraftingModule
extends AbstractModuleWithExternalWorkingBlocks {
    private final IToolType toolType;

    public CuttingCraftingModule(JobEntry jobEntry, IToolType toolType) {
        super(jobEntry);
        this.toolType = toolType;
    }

    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.m_130070_(this.getToolType().getName());
    }

    @Override
    public boolean isIntermediate(@NotNull Block block) {
        return block == ModBlocks.CUTTING_BOARD.get();
    }

    @Override
    @NotNull
    public BlockPos getWalkingPosition(@NotNull LevelReader level, @NotNull BlockPos pos) {
        return pos.m_7495_();
    }

    @Override
    @NotNull
    public BlockPos getParticlePosition(@NotNull LevelReader level, @NotNull BlockPos pos) {
        return pos.m_7495_().m_7495_();
    }

    @NotNull
    public String getId() {
        return "farmers_cutting_" + this.getToolType().getName();
    }

    public Set<CraftingType> getSupportedCraftingTypes() {
        return this.building == null || this.building.getBuildingLevel() >= 3 ? Collections.singleton((CraftingType)ModuleCraftingTypes.CUTTING.get()) : ImmutableSet.of();
    }

    public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
        return recipe.getRequiredTool() == this.getToolType();
    }

    @Override
    @NotNull
    public Component getWorkingBlockNotFoundMessage() {
        return Component.m_237115_((String)"minecolonies_compatibility.interaction.no_cutting_board");
    }

    public IToolType getToolType() {
        return this.toolType;
    }

    @Override
    protected WorkingBlocksPathResult createPathResult(@Nullable AbstractEntityCitizen citizen) {
        return new WorkingBlocksPathResult(this){

            @Override
            public boolean test(@NotNull PathJobFindWorkingBlocks<?> job, @NotNull BlockPos.MutableBlockPos pos) {
                return super.test(job, pos) || super.test(job, pos.m_142448_(pos.m_123342_() + 1));
            }
        };
    }
}

