/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.delightful;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.brnbrd.delightful.common.block.DelightfulBlocks;
import net.brnbrd.delightful.common.block.SalmonberryBushBlock;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class SalmonberryFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return DelightfulBlocks.SALMONBERRY_BUSH.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)DelightfulItems.SALMONBERRY_PIPS.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)DelightfulItems.SALMONBERRIES.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == DelightfulBlocks.SALMONBERRY_BUSH.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)SalmonberryBushBlock.AGE) > 2;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        BlockState state = context.getState();
        return ((SalmonberryBushBlock)state.m_60734_()).isMaxAge(state);
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            boolean flag = ((SalmonberryBushBlock)state.m_60734_()).isMaxAge(state);
            int count = flag ? 2 + level.f_46441_.m_188503_(2) : 1;
            level.m_7731_(context.getPosition(), (BlockState)state.m_61124_((Property)SalmonberryBushBlock.AGE, (Comparable)Integer.valueOf(1)), 2);
            return Collections.singletonList(new ItemStack((ItemLike)DelightfulItems.SALMONBERRIES.get(), count));
        }
        return Collections.emptyList();
    }
}

