/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.blue_skies;

import com.legacy.blue_skies.blocks.natural.BrewberryBushBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.mixin.common.blue_skies.BrewberryBushBlockAccessor;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;

public class BrewBerryFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return new ResourceLocation(ModuleManager.BLUE_SKIES.getModId(), "brewberry_bush");
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)SkiesBlocks.brewberry_bush));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.stream(BrewberryBushBlock.Type.values()).map(BrewberryBushBlock.Type::getBerry).map(ItemStack::new).toList();
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == SkiesBlocks.brewberry_bush;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Boolean)context.getState().m_61143_((Property)BrewberryBushBlock.MATURE);
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof Level) {
            Level level = (Level)levelReader;
            BlockState state = context.getState();
            level.m_7731_(context.getPosition(), (BlockState)state.m_61124_((Property)BrewberryBushBlock.MATURE, (Comparable)Boolean.valueOf(false)), 2);
            ItemStack result = ((BrewberryBushBlockAccessor)state.m_60734_()).invokeGetBerry(level, state, context.getPosition());
            return Collections.singletonList(result);
        }
        return Collections.emptyList();
    }
}

