/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import steve_gall.minecolonies_compatibility.module.common.OptionalModule;
import steve_gall.minecolonies_compatibility.module.common.aether.AetherModule;
import steve_gall.minecolonies_compatibility.module.common.ars_nouveau.ArsNouveauModule;
import steve_gall.minecolonies_compatibility.module.common.blue_skies.BlueSkiesModule;
import steve_gall.minecolonies_compatibility.module.common.cobblemon.CobblemonModule;
import steve_gall.minecolonies_compatibility.module.common.croptopia.CroptopiaModule;
import steve_gall.minecolonies_compatibility.module.common.cyclic.CyclicModule;
import steve_gall.minecolonies_compatibility.module.common.delightful.DelightfulModule;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.FarmersDelightModule;
import steve_gall.minecolonies_compatibility.module.common.ie.IEModule;
import steve_gall.minecolonies_compatibility.module.common.minecraft.MinecraftModule;
import steve_gall.minecolonies_compatibility.module.common.oreberries.OreberriesModule;
import steve_gall.minecolonies_compatibility.module.common.pamhc2trees.PamsHarvestCraft2TreesModule;
import steve_gall.minecolonies_compatibility.module.common.polymorph.PolymorphModule;
import steve_gall.minecolonies_compatibility.module.common.regions_unexplored.RegionsUnexploredModule;
import steve_gall.minecolonies_compatibility.module.common.reliquary.ReliquaryModule;
import steve_gall.minecolonies_compatibility.module.common.thermal.ThermalModule;
import steve_gall.minecolonies_compatibility.module.common.undergarden.UndergardenModule;
import steve_gall.minecolonies_compatibility.module.common.vinery.VineryModule;

public class ModuleManager {
    private static final List<OptionalModule> _MODULES = new ArrayList<OptionalModule>();
    public static final List<OptionalModule> MODULES = Collections.unmodifiableList(_MODULES);
    private static boolean INITIALIZED;
    private static final List<OptionalModule> _LOADED_MODULES;
    public static final List<OptionalModule> LOADED_MODULES;
    public static final OptionalModule MINECRAFT;
    public static final OptionalModule AETHER;
    public static final OptionalModule ARS_NOUVEAU;
    public static final OptionalModule BLUE_SKIES;
    public static final OptionalModule CROPTOPIA;
    public static final OptionalModule CYCLIC;
    public static final OptionalModule DELIGHTFUL;
    public static final OptionalModule FARMERSDELIGHT;
    public static final OptionalModule IE;
    public static final OptionalModule OREBERRIES;
    public static final OptionalModule PHC2TREES;
    public static final OptionalModule POLYMORPH;
    public static final OptionalModule REGIONS_UNEXPLORED;
    public static final OptionalModule RELIQUARY;
    public static final OptionalModule THERMAL;
    public static final OptionalModule UNDERGARDEN;
    public static final OptionalModule VINERY;
    public static final OptionalModule COBBLEMON;

    private static OptionalModule register(String modid, Supplier<Runnable> initializer) {
        OptionalModule module = new OptionalModule(modid, initializer);
        _MODULES.add(module);
        return module;
    }

    public static boolean isInitialized() {
        return INITIALIZED;
    }

    public static void initialize() {
        if (INITIALIZED) {
            throw new IllegalCallerException();
        }
        INITIALIZED = true;
        _LOADED_MODULES.clear();
        for (OptionalModule module : MODULES) {
            module.tryLoad();
            if (!module.isLoaded()) continue;
            _LOADED_MODULES.add(module);
        }
    }

    static {
        _LOADED_MODULES = new ArrayList<OptionalModule>();
        LOADED_MODULES = Collections.unmodifiableList(_LOADED_MODULES);
        MINECRAFT = ModuleManager.register("minecraft", () -> MinecraftModule::onLoad);
        AETHER = ModuleManager.register("aether", () -> AetherModule::onLoad);
        ARS_NOUVEAU = ModuleManager.register("ars_nouveau", () -> ArsNouveauModule::onLoad);
        BLUE_SKIES = ModuleManager.register("blue_skies", () -> BlueSkiesModule::onLoad);
        CROPTOPIA = ModuleManager.register("croptopia", () -> CroptopiaModule::onLoad);
        CYCLIC = ModuleManager.register("cyclic", () -> CyclicModule::onLoad);
        DELIGHTFUL = ModuleManager.register("delightful", () -> DelightfulModule::onLoad);
        FARMERSDELIGHT = ModuleManager.register("farmersdelight", () -> FarmersDelightModule::onLoad);
        IE = ModuleManager.register("immersiveengineering", () -> IEModule::onLoad);
        OREBERRIES = ModuleManager.register("oreberriesreplanted", () -> OreberriesModule::onLoad);
        PHC2TREES = ModuleManager.register("pamhc2trees", () -> PamsHarvestCraft2TreesModule::onLoad);
        POLYMORPH = ModuleManager.register("polymorph", () -> PolymorphModule::onLoad);
        REGIONS_UNEXPLORED = ModuleManager.register("regions_unexplored", () -> RegionsUnexploredModule::onLoad);
        RELIQUARY = ModuleManager.register("reliquary", () -> ReliquaryModule::onLoad);
        THERMAL = ModuleManager.register("thermal", () -> ThermalModule::onLoad);
        UNDERGARDEN = ModuleManager.register("undergarden", () -> UndergardenModule::onLoad);
        VINERY = ModuleManager.register("vinery", () -> VineryModule::onLoad);
        COBBLEMON = ModuleManager.register("cobblemon", () -> CobblemonModule::onLoad);
    }
}

