/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.research.effects.IResearchEffectManager;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.entity.ai.combat.AttackMoveAI;
import com.minecolonies.core.entity.ai.combat.CombatUtils;
import com.minecolonies.core.entity.ai.workers.guard.RangerCombatAI;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.CombatUtils2;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.RangerConfig;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;

@Mixin(value={RangerCombatAI.class}, remap=false)
public abstract class RangerCombatAIMixin
extends AttackMoveAI<EntityCitizen> {
    public RangerCombatAIMixin(EntityCitizen owner, ITickRateStateMachine<?> stateMachine) {
        super((Mob)owner, stateMachine);
    }

    @Redirect(method={"canAttack"}, remap=false, at=@At(value="FIELD", target="com/minecolonies/api/util/constant/ToolType.BOW", opcode=178))
    private ToolType canAttack_ToolType() {
        return ModToolTypes.RANGER_WEAPON.getToolType();
    }

    @ModifyConstant(method={"doAttack"}, remap=false, constant={@Constant(intValue=1, ordinal=0)})
    private int doAttack_amountOfArrows(int amountOfArrows) {
        ItemStack weapon = ((EntityCitizen)this.user).m_21120_(InteractionHand.MAIN_HAND);
        if (ItemStackUtils.isTool((ItemStack)weapon, (IToolType)ModToolTypes.CROSSBOW.getToolType())) {
            return 0;
        }
        return amountOfArrows;
    }

    @Redirect(method={"doAttack"}, remap=false, at=@At(value="INVOKE", target="com/minecolonies/api/research/effects/IResearchEffectManager.getEffectStrength"))
    private double doAttack_getEffectStrength_DOUBLE_ARROWS(IResearchEffectManager researchManager, ResourceLocation id) {
        ItemStack weapon = ((EntityCitizen)this.user).m_21120_(InteractionHand.MAIN_HAND);
        if (ItemStackUtils.isTool((ItemStack)weapon, (IToolType)ModToolTypes.CROSSBOW.getToolType()) && id.equals((Object)ResearchConstants.DOUBLE_ARROWS)) {
            return 0.0;
        }
        return researchManager.getEffectStrength(id);
    }

    @Inject(method={"doAttack"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void doAttack(LivingEntity target, CallbackInfo ci) {
        ItemStack weapon = ((EntityCitizen)this.user).m_21120_(InteractionHand.MAIN_HAND);
        if (ItemStackUtils.isTool((ItemStack)weapon, (IToolType)ModToolTypes.CROSSBOW.getToolType())) {
            int amountOfProjectiles = weapon.getEnchantmentLevel(Enchantments.f_44959_) == 0 ? 1 : 3;
            IResearchEffectManager researchEffects = ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects();
            RangerConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.ranger;
            int ammoSlot = -1;
            if (((Boolean)config.canShootFireworkRocket.get()).booleanValue() && researchEffects.getEffectStrength(ResearchConstants.ARCHER_USE_ARROWS) > 0.0) {
                ammoSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), item -> item.m_150930_(Items.f_42688_));
            }
            ItemStack ammo = ammoSlot == -1 ? ItemStack.f_41583_ : ((EntityCitizen)this.user).getInventoryCitizen().extractItem(ammoSlot, 1, false);
            int weaponDamage = ammoSlot == -1 ? 1 : 3;
            Projectile[] projectiles = new Projectile[amountOfProjectiles];
            float chance = 15.0f / (float)(((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) + 1);
            for (int i = 0; i < amountOfProjectiles; ++i) {
                float horizontalAngle = this.getShootHorizontalAngle(i);
                Vec3 upVector = ((EntityCitizen)this.user).m_20289_(1.0f);
                Quaternionf quaternion = new Quaternionf().setAngleAxis((double)(horizontalAngle * ((float)Math.PI / 180)), upVector.f_82479_, upVector.f_82480_, upVector.f_82481_);
                Projectile projectile = this.createProjectile(i, weapon, ammo, target, chance, quaternion, projectiles);
                ((EntityCitizen)this.user).m_9236_().m_7967_((Entity)projectile);
                projectiles[i] = projectile;
                ((EntityCitizen)this.user).m_5496_(SoundEvents.f_11847_, 1.0f, (float)SoundUtils.getRandomPitch((RandomSource)((EntityCitizen)this.user).m_217043_()));
                ((EntityCitizen)this.user).getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, i == 0 ? weaponDamage - 1 : weaponDamage);
            }
        }
    }

    private Projectile createProjectile(int i, ItemStack weapon, ItemStack ammo, LivingEntity target, float chance, Quaternionf quaternion, Projectile[] projectiles) {
        if (ammo.m_150930_(Items.f_42688_)) {
            FireworkRocketEntity fireworkRocket = new FireworkRocketEntity(((EntityCitizen)this.user).m_9236_(), ammo, (Entity)this.user, ((EntityCitizen)this.user).m_20185_(), ((EntityCitizen)this.user).m_20188_() - 0.15, ((EntityCitizen)this.user).m_20189_(), true);
            CombatUtils2.setVector((Projectile)fireworkRocket, target, chance, false, quaternion);
            return fireworkRocket;
        }
        AbstractArrow arrow = CombatUtils.createArrowForShooter((LivingEntity)this.user);
        arrow.m_36793_(true);
        if (i == 0) {
            IResearchEffectManager researchEffects = ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects();
            int piercing = weapon.getEnchantmentLevel(Enchantments.f_44961_);
            if (researchEffects.getEffectStrength(ResearchConstants.ARROW_PIERCE) > 0.0) {
                piercing += 2;
            }
            if (piercing > 0) {
                arrow.m_36767_((byte)Math.min(piercing, 127));
            }
            arrow.m_36781_(this.calculateDamage(arrow));
        } else {
            AbstractArrow first = (AbstractArrow)projectiles[0];
            arrow.m_36767_(first.m_36796_());
            arrow.m_36781_(first.m_36789_());
        }
        CombatUtils2.setVector((Projectile)arrow, target, chance, true, quaternion);
        return arrow;
    }

    private float getShootHorizontalAngle(int i) {
        if (i == 0) {
            return 0.0f;
        }
        if (i == 1) {
            return -10.0f;
        }
        if (i == 2) {
            return 10.0f;
        }
        return 0.0f;
    }

    @Inject(method={"getAttackDelay"}, remap=false, at={@At(value="RETURN")}, cancellable=true)
    private void getAttackDelay(CallbackInfoReturnable<Integer> cir) {
        ItemStack weapon = ((EntityCitizen)this.user).m_21120_(InteractionHand.MAIN_HAND);
        if (!ItemStackUtils.isTool((ItemStack)weapon, (IToolType)ModToolTypes.CROSSBOW.getToolType())) {
            return;
        }
        int i = weapon.getEnchantmentLevel(Enchantments.f_44960_);
        if (i > 0) {
            int attackDelay = cir.getReturnValueI() - 5 * i;
            cir.setReturnValue((Object)Math.max(attackDelay, 20));
        }
    }

    @Shadow(remap=false)
    abstract double calculateDamage(AbstractArrow var1);
}

