/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.entity.ai.combat.AttackMoveAI;
import com.minecolonies.core.entity.ai.workers.guard.KnightCombatAI;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import java.util.Collection;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;

@Mixin(value={KnightCombatAI.class}, remap=false)
public abstract class KnightCombatAIMixin
extends AttackMoveAI<EntityCitizen> {
    public KnightCombatAIMixin(EntityCitizen owner, ITickRateStateMachine<?> stateMachine) {
        super((Mob)owner, stateMachine);
    }

    @Redirect(method={"canAttack"}, remap=false, at=@At(value="FIELD", target="com/minecolonies/api/util/constant/ToolType.SWORD", opcode=178))
    private ToolType canAttack_ToolType() {
        return ModToolTypes.KNIGHT_WEAPON.getToolType();
    }

    @Redirect(method={"getAttackDamage"}, remap=false, at=@At(value="INVOKE", target="com/minecolonies/api/compatibility/tinkers/TinkersToolHelper.getDamage"))
    private double getAttackDamage_getDamage(ItemStack stack) {
        if (!TinkersToolHelper.isTinkersSword((ItemStack)stack)) {
            double amount = this.getAdditionsAmount(stack, Attributes.f_22281_);
            return amount + 3.0;
        }
        return TinkersToolHelper.getDamage((ItemStack)stack);
    }

    @ModifyConstant(method={"getAttackDelay"}, remap=false, constant={@Constant(intValue=32)})
    private int modifyDelay(int KNIGHT_ATTACK_DELAY_BASE) {
        ItemStack stack = ((EntityCitizen)this.user).m_21120_(InteractionHand.MAIN_HAND);
        if (!TinkersToolHelper.isTinkersSword((ItemStack)stack)) {
            double base = Attributes.f_22283_.m_22082_();
            double amount = this.getAdditionsAmount(stack, Attributes.f_22283_);
            return (int)((double)KNIGHT_ATTACK_DELAY_BASE * ((base - 2.4) / (base + amount)));
        }
        return KNIGHT_ATTACK_DELAY_BASE;
    }

    private double getAdditionsAmount(ItemStack stack, Attribute attribute) {
        double amount = 0.0;
        Collection modifiers = stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)attribute);
        for (AttributeModifier modifier : modifiers) {
            if (modifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            amount += modifier.m_22218_();
        }
        return amount;
    }
}

