/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.colony.jobs.JobFarmer;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.entity.ai.workers.production.agriculture.EntityAIWorkFarmer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantSeedContext;

@Mixin(value={EntityAIWorkFarmer.class}, remap=false)
public abstract class EntityAIWorkFarmerMixin
extends AbstractEntityAICrafting<JobFarmer, BuildingFarmer> {
    @Shadow(remap=false)
    @Nullable
    private BlockPos prevPos;

    public EntityAIWorkFarmerMixin(@NotNull JobFarmer job) {
        super((AbstractJobCrafter)job);
    }

    @Inject(method={"plantCrop"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void plantCrop(ItemStack stack, @NotNull BlockPos position, CallbackInfoReturnable<Boolean> cir) {
        if (stack == null || stack.m_41619_()) {
            cir.setReturnValue((Object)false);
            return;
        }
        AbstractEntityCitizen worker = this.worker;
        int slot = worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(stack.m_41720_());
        if (slot == -1) {
            cir.setReturnValue((Object)false);
            return;
        }
        Level level = this.world;
        BlockPos plantPosition = position.m_7494_();
        if (!level.m_8055_(plantPosition).m_60795_()) {
            cir.setReturnValue((Object)true);
            return;
        }
        PlantSeedContext context = new PlantSeedContext((LevelReader)level, plantPosition, stack);
        CustomizedCrop crop = CustomizedCrop.selectBySeed(context);
        BlockState plantState = null;
        if (crop != null) {
            plantState = crop.getPlantState(context);
            if (plantState == null) {
                cir.setReturnValue((Object)true);
                return;
            }
        } else {
            BlockItem item;
            Item item2 = stack.m_41720_();
            if (item2 instanceof BlockItem && (item2 = (item = (BlockItem)item2).m_40614_()) instanceof StemBlock) {
                StemBlock block = (StemBlock)item2;
                if (this.prevPos != null && !level.m_46859_(this.prevPos.m_7494_())) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                plantState = block.getPlant((BlockGetter)level, plantPosition);
            }
        }
        if (plantState != null) {
            level.m_7731_(plantPosition, plantState, 3);
            worker.decreaseSaturationForContinuousAction();
            this.getInventory().extractItem(slot, 1, false);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"findHarvestableSurface"}, remap=false, at={@At(value="RETURN")}, cancellable=true)
    private void findHarvestableSurface(@NotNull BlockPos position, CallbackInfoReturnable<BlockPos> cir) {
        BlockState state;
        if (position == null) {
            return;
        }
        Level level = this.world;
        BlockPos plantPosition = position.m_7494_();
        PlantBlockContext context = new PlantBlockContext((LevelReader)level, plantPosition, state = level.m_8055_(plantPosition));
        CustomizedCrop crop = CustomizedCrop.selectByCrop(context);
        if (crop != null) {
            CustomizedCrop.SpecialHarvestPositionFunction specialPositionFunction = crop.getSpecialHarvestPosition(context);
            if (specialPositionFunction != null) {
                BlockPos harvestPosition = specialPositionFunction.apply(context);
                if (harvestPosition != null) {
                    cir.setReturnValue((Object)harvestPosition.m_7495_());
                } else {
                    cir.setReturnValue(null);
                }
            }
        } else if (state.m_60734_() instanceof StemGrownBlock) {
            cir.setReturnValue((Object)position);
        }
    }

    @Redirect(method={"harvestIfAble"}, remap=false, at=@At(value="INVOKE", target="mineBlock(Lnet/minecraft/core/BlockPos;)Z"))
    private boolean harvestIfAble_mineBlock(EntityAIWorkFarmer self, BlockPos position) {
        CustomizedCrop.SpecialHarvestMethodFunction method;
        AbstractEntityCitizen worker = this.worker;
        Level level = this.world;
        BlockState state = level.m_8055_(position);
        PlantBlockContext context = new PlantBlockContext((LevelReader)level, position, state);
        CustomizedCrop crop = CustomizedCrop.selectByCrop(context);
        if (crop != null && (method = crop.getSpecialHarvestMethod(context)) != null) {
            if (!this.holdEfficientTool(state, position)) {
                return false;
            }
            if (this.hasNotDelayed(this.getBlockMiningDelay(state, position))) {
                return false;
            }
            InventoryCitizen inventory = worker.getInventoryCitizen();
            InteractionHand hand = worker.m_7655_();
            HarvesterContext harvester = new HarvesterContext((LivingEntity)worker, inventory.getHeldItem(hand));
            List drops = this.increaseBlockDrops(method.harvest(context, harvester));
            level.m_5594_(null, position, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            for (ItemStack stack : drops) {
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((ItemStack)stack, (IItemHandler)inventory);
            }
            worker.m_6674_(hand);
            worker.getCitizenItemHandler().damageItemInHand(hand, 1);
            this.incrementActionsDone();
            worker.decreaseSaturationForContinuousAction();
            this.onBlockDropReception(drops);
            return true;
        }
        return this.mineBlock(position);
    }

    @ModifyVariable(method={"getSurfacePos(Lnet/minecraft/core/BlockPos;Ljava/lang/Integer;)Lnet/minecraft/core/BlockPos;"}, remap=false, at=@At(value="STORE"), ordinal=0)
    private Block getSurfacePos(Block curBlock) {
        if (curBlock instanceof StemGrownBlock) {
            return Blocks.f_50133_;
        }
        return curBlock;
    }
}

