/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.jobs.JobRanger;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.ai.workers.guard.EntityAIRanger;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.RangerConfig;
import steve_gall.minecolonies_compatibility.core.common.init.ModBuildingModules;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;

@Mixin(value={EntityAIRanger.class}, remap=false)
public abstract class EntityAIRangerMixin
extends AbstractEntityAIGuard<JobRanger, AbstractBuildingGuards> {
    public EntityAIRangerMixin(@NotNull JobRanger job) {
        super((AbstractJobGuard)job);
    }

    @Inject(method={"<init>"}, remap=false, at={@At(value="TAIL")}, cancellable=false)
    private void init(JobRanger job, CallbackInfo ci) {
        if (this.toolsNeeded.remove(ToolType.BOW)) {
            this.toolsNeeded.add(ModToolTypes.RANGER_WEAPON.getToolType());
        }
    }

    @Inject(method={"atBuildingActions"}, remap=false, at={@At(value="TAIL")}, cancellable=true)
    private void atBuildingActions(CallbackInfo ci) {
        RangerConfig config = MineColoniesCompatibilityConfigServer.INSTANCE.jobs.ranger;
        if (((Boolean)config.canUseCrossbow.get()).booleanValue() && ((Boolean)config.canShootFireworkRocket.get()).booleanValue() && this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_USE_ARROWS) > 0.0) {
            InventoryCitizen inventory = this.worker.getInventoryCitizen();
            int crossbowSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)inventory, (IToolType)ModToolTypes.CROSSBOW.getToolType(), (int)0, (int)((AbstractBuildingGuards)this.building).getMaxToolLevel());
            if (crossbowSlot == -1) {
                return;
            }
            InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler((ICapabilityProvider)this.building, item -> item.m_150930_(Items.f_42688_), (int)64, (IItemHandler)inventory);
            if (((BoolSetting)((AbstractBuildingGuards)this.building).getSetting(ModBuildingModules.REQUEST_FIREWORK_ROCKET)).getValue().booleanValue() && InventoryUtils.getItemCountInItemHandler((IItemHandler)inventory, item -> item.m_150930_(Items.f_42688_)) < 16) {
                this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.f_42688_), 64, 16);
            }
        }
    }
}

