/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.core.entity.ai.combat.AttackMoveAI;
import com.minecolonies.core.entity.ai.combat.TargetAI;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAI;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAIAttack;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.ICustomizableAttackMoveAI;

@Mixin(value={AttackMoveAI.class}, remap=false)
public abstract class AttackMoveAIMixin<T extends Mob>
extends TargetAI<T> {
    public AttackMoveAIMixin(T user, int targetFrequency, ITickRateStateMachine<?> stateMachine) {
        super(user, targetFrequency, stateMachine);
    }

    @Shadow(remap=false)
    public abstract double getAttackDistance();

    @Inject(method={"move"}, remap=false, at={@At(value="RETURN")}, cancellable=true)
    private void move_return(CallbackInfoReturnable<IState> cir) {
        if (cir.getReturnValue() == CombatAIStates.NO_TARGET && this.target != null) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"tryAttack"}, remap=false, at={@At(value="RETURN")}, cancellable=true)
    private void tryAttack_return(CallbackInfoReturnable<IState> cir) {
        if (cir.getReturnValue() == CombatAIStates.NO_TARGET && this.target != null) {
            cir.setReturnValue(null);
        }
    }

    @Redirect(method={"move"}, remap=false, at=@At(value="INVOKE", target="checkForTarget"))
    private boolean move_checkForTarget(AttackMoveAI<T> ai) {
        ICustomizableAttackMoveAI self;
        Object parentAI;
        CustomizedAI customizedAI;
        if (!this.checkForTarget()) {
            return false;
        }
        AttackMoveAIMixin attackMoveAIMixin = this;
        if (attackMoveAIMixin instanceof ICustomizableAttackMoveAI && (customizedAI = (parentAI = (self = (ICustomizableAttackMoveAI)((Object)attackMoveAIMixin)).getParentAI()).getSelectedAI()) instanceof CustomizedAIAttack) {
            CustomizedAIAttack attack = (CustomizedAIAttack)customizedAI;
            return attack.canAttack(parentAI.getAIContext(), this.target);
        }
        return true;
    }

    @Inject(method={"canAttack"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void canAttack(CallbackInfoReturnable<Boolean> cir) {
        AttackMoveAIMixin attackMoveAIMixin = this;
        if (attackMoveAIMixin instanceof ICustomizableAttackMoveAI) {
            ICustomizableAttackMoveAI self = (ICustomizableAttackMoveAI)((Object)attackMoveAIMixin);
            Object parentAI = self.getParentAI();
            CustomizedAI customizedAI = parentAI.getSelectedAI();
            if (customizedAI instanceof CustomizedAIAttack) {
                CustomizedAIAttack attack = (CustomizedAIAttack)customizedAI;
                cir.setReturnValue((Object)attack.canAttack(parentAI.getAIContext(), this.target));
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"doAttack"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void doAttack(LivingEntity target, CallbackInfo ci) {
        ICustomizableAttackMoveAI self;
        Object parentAI;
        CustomizedAI customizedAI;
        AttackMoveAIMixin attackMoveAIMixin = this;
        if (attackMoveAIMixin instanceof ICustomizableAttackMoveAI && (customizedAI = (parentAI = (self = (ICustomizableAttackMoveAI)((Object)attackMoveAIMixin)).getParentAI()).getSelectedAI()) instanceof CustomizedAIAttack) {
            CustomizedAIAttack attack = (CustomizedAIAttack)customizedAI;
            attack.doAttack(parentAI.getAIContext(), target);
            Mob user = this.user;
            target.m_6703_((LivingEntity)user);
            user.m_6674_(InteractionHand.MAIN_HAND);
            user.m_21573_().m_26573_();
            if (user instanceof EntityCitizen) {
                EntityCitizen citizen = (EntityCitizen)user;
                citizen.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
                citizen.decreaseSaturationForContinuousAction();
            }
            ci.cancel();
        }
    }

    @Inject(method={"getAttackDelay"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void getAttackDelay(CallbackInfoReturnable<Integer> cir) {
        AttackMoveAIMixin attackMoveAIMixin = this;
        if (attackMoveAIMixin instanceof ICustomizableAttackMoveAI) {
            ICustomizableAttackMoveAI self = (ICustomizableAttackMoveAI)((Object)attackMoveAIMixin);
            Object parentAI = self.getParentAI();
            CustomizedAI customizedAI = parentAI.getSelectedAI();
            if (customizedAI instanceof CustomizedAIAttack) {
                CustomizedAIAttack attack = (CustomizedAIAttack)customizedAI;
                int attackDelay = attack.getAttackDelay(parentAI.getAIContext(), this.target);
                cir.setReturnValue((Object)Math.max(attackDelay, 10));
            } else {
                cir.setReturnValue((Object)0);
            }
        }
    }

    @Inject(method={"getAttackDistance"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void getAttackDistance(CallbackInfoReturnable<Double> cir) {
        AttackMoveAIMixin attackMoveAIMixin = this;
        if (attackMoveAIMixin instanceof ICustomizableAttackMoveAI) {
            ICustomizableAttackMoveAI self = (ICustomizableAttackMoveAI)((Object)attackMoveAIMixin);
            Object parentAI = self.getParentAI();
            CustomizedAI customizedAI = parentAI.getSelectedAI();
            if (customizedAI instanceof CustomizedAIAttack) {
                CustomizedAIAttack attack = (CustomizedAIAttack)customizedAI;
                cir.setReturnValue((Object)attack.getAttackDistance(parentAI.getAIContext(), this.target));
            } else {
                cir.setReturnValue((Object)0.0);
            }
        }
    }

    @Inject(method={"moveInAttackPosition"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void moveInAttackPosition(LivingEntity target, CallbackInfoReturnable<PathResult<?>> cir) {
        AttackMoveAIMixin attackMoveAIMixin = this;
        if (attackMoveAIMixin instanceof ICustomizableAttackMoveAI) {
            ICustomizableAttackMoveAI self = (ICustomizableAttackMoveAI)((Object)attackMoveAIMixin);
            Object parentAI = self.getParentAI();
            CustomizedAI customizedAI = parentAI.getSelectedAI();
            if (customizedAI instanceof CustomizedAIAttack) {
                CustomizedAIAttack attack = (CustomizedAIAttack)customizedAI;
                double speed = attack.getCombatMovementSpeed(parentAI.getAIContext());
                double min = 0.1;
                int max = 2;
                speed = Mth.m_14008_((double)speed, (double)min, (double)max);
                cir.setReturnValue((Object)((ICustomizableAttackMoveAI)((Object)this)).createPathResult(target, this.user, speed));
            } else {
                cir.setReturnValue(null);
            }
        }
    }

    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        ICustomizableAttackMoveAI self;
        Object parentAI;
        AttackMoveAIMixin attackMoveAIMixin = this;
        if (attackMoveAIMixin instanceof ICustomizableAttackMoveAI && (parentAI = (self = (ICustomizableAttackMoveAI)((Object)attackMoveAIMixin)).getParentAI()) instanceof AbstractEntityAIGuard) {
            AbstractEntityAIGuard guard = (AbstractEntityAIGuard)parentAI;
            CustomizedAI customizedAI = parentAI.getSelectedAI();
            if (customizedAI instanceof CustomizedAIAttack) {
                CustomizedAIAttack attack = (CustomizedAIAttack)customizedAI;
                return guard.isWithinPersecutionDistance(target.m_20183_(), attack.getAttackDistance(parentAI.getAIContext(), target));
            }
        }
        return super.isWithinPersecutionDistance(target);
    }
}

